/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.izzel.arclight.api.EnumHelper;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.bridge.bukkit.EntityTypeBridge;
import io.izzel.arclight.common.bridge.bukkit.MaterialBridge;
import io.izzel.arclight.common.bridge.bukkit.SimpleRegistryBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.entity.EntityClassLookup;
import io.izzel.arclight.common.mod.util.ResourceLocationUtil;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.i18n.conf.EntityPropertySpec;
import io.izzel.arclight.i18n.conf.MaterialPropertySpec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_20_R3.CraftStatistic;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftSpawnCategory;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.potion.PotionType;

public class BukkitRegistry {
    private static final List<Class<?>> MAT_CTOR = ImmutableList.of(Integer.TYPE);
    private static final List<Class<?>> ENTITY_CTOR = ImmutableList.of(String.class, Class.class, Integer.TYPE);
    private static final List<Class<?>> ENV_CTOR = ImmutableList.of(Integer.TYPE);
    private static final Map<String, Material> BY_NAME = (Map)Unsafe.getStatic(Material.class, (String)"BY_NAME");
    private static final Map<Block, Material> BLOCK_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, (String)"BLOCK_MATERIAL");
    private static final Map<Item, Material> ITEM_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, (String)"ITEM_MATERIAL");
    private static final Map<Material, Item> MATERIAL_ITEM = (Map)Unsafe.getStatic(CraftMagicNumbers.class, (String)"MATERIAL_ITEM");
    private static final Map<Material, Block> MATERIAL_BLOCK = (Map)Unsafe.getStatic(CraftMagicNumbers.class, (String)"MATERIAL_BLOCK");
    private static final Map<String, EntityType> ENTITY_NAME_MAP = (Map)Unsafe.getStatic(EntityType.class, (String)"NAME_MAP");
    private static final Map<Integer, World.Environment> ENVIRONMENT_MAP = (Map)Unsafe.getStatic(World.Environment.class, (String)"lookup");
    static final BiMap<ResourceKey<LevelStem>, World.Environment> DIM_MAP = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    private static final Map<String, Art> ART_BY_NAME = (Map)Unsafe.getStatic(Art.class, (String)"BY_NAME");
    private static final Map<Integer, Art> ART_BY_ID = (Map)Unsafe.getStatic(Art.class, (String)"BY_ID");
    private static final BiMap<ResourceLocation, Statistic> STATS = HashBiMap.create((Map)((Map)Unsafe.getStatic(CraftStatistic.class, (String)"statistics")));

    public static void registerAll(DedicatedServer console) {
        BukkitRegistry.loadMaterials();
        BukkitRegistry.loadPotions();
        BukkitRegistry.loadEnchantmentTargets();
        BukkitRegistry.loadEntities();
        BukkitRegistry.loadVillagerProfessions();
        BukkitRegistry.loadBiomes(console);
        BukkitRegistry.loadArts();
        BukkitRegistry.loadStats();
        BukkitRegistry.loadSpawnCategory();
        BukkitRegistry.loadEndDragonPhase();
        BukkitRegistry.loadCookingBookCategory();
        BukkitRegistry.loadFluids();
        try {
            for (Field field : Registry.class.getFields()) {
                Object object;
                if (!Modifier.isStatic(field.getModifiers()) || !((object = field.get(null)) instanceof Registry.SimpleRegistry)) continue;
                Registry.SimpleRegistry registry = (Registry.SimpleRegistry)object;
                ((SimpleRegistryBridge)((Object)registry)).bridge$reload();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void loadFluids() {
        int id = org.bukkit.Fluid.values().length;
        ArrayList<org.bukkit.Fluid> newTypes = new ArrayList<org.bukkit.Fluid>();
        Field keyField = Arrays.stream(org.bukkit.Fluid.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset((Field)keyField);
        for (Fluid fluidType : BuiltInRegistries.f_257020_) {
            ResourceLocation key = BuiltInRegistries.f_257020_.m_7981_((Object)fluidType);
            String name = ResourceLocationUtil.standardize(key);
            try {
                org.bukkit.Fluid.valueOf(name);
            }
            catch (Exception e) {
                org.bukkit.Fluid bukkit = (org.bukkit.Fluid)EnumHelper.makeEnum(org.bukkit.Fluid.class, (String)name, (int)id++, List.of(), List.of());
                Unsafe.putObject((Object)bukkit, (long)keyOffset, (Object)CraftNamespacedKey.fromMinecraft(key));
                newTypes.add(bukkit);
                ArclightServer.LOGGER.debug("Registered {} as fluid {}", (Object)key, (Object)bukkit);
            }
        }
        EnumHelper.addEnums(org.bukkit.Fluid.class, newTypes);
    }

    private static void loadCookingBookCategory() {
        int id = net.minecraft.world.item.crafting.CookingBookCategory.values().length;
        ArrayList<CookingBookCategory> newTypes = new ArrayList<CookingBookCategory>();
        for (net.minecraft.world.item.crafting.CookingBookCategory category : net.minecraft.world.item.crafting.CookingBookCategory.values()) {
            try {
                CraftRecipe.getCategory(category);
            }
            catch (Exception e) {
                String name = category.name();
                CookingBookCategory bukkit = (CookingBookCategory)((Object)EnumHelper.makeEnum(CookingBookCategory.class, (String)name, (int)id++, List.of(), List.of()));
                newTypes.add(bukkit);
                ArclightServer.LOGGER.debug("Registered {} as cooking category {}", (Object)name, (Object)bukkit);
            }
        }
        EnumHelper.addEnums(CookingBookCategory.class, newTypes);
    }

    private static void loadEndDragonPhase() {
        int max = EnderDragonPhase.m_31406_();
        ArrayList<EnderDragon.Phase> newTypes = new ArrayList<EnderDragon.Phase>();
        for (int id = EnderDragon.Phase.values().length; id < max; ++id) {
            String name = "MOD_PHASE_" + id;
            EnderDragon.Phase newPhase = (EnderDragon.Phase)((Object)EnumHelper.makeEnum(EnderDragon.Phase.class, (String)name, (int)id, List.of(), List.of()));
            newTypes.add(newPhase);
            ArclightServer.LOGGER.debug("Registered {} as ender dragon phase {}", (Object)name, (Object)newPhase);
        }
        EnumHelper.addEnums(EnderDragon.Phase.class, newTypes);
    }

    private static void loadSpawnCategory() {
        int id = SpawnCategory.values().length;
        ArrayList<SpawnCategory> newTypes = new ArrayList<SpawnCategory>();
        for (MobCategory category : MobCategory.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = (SpawnCategory)((Object)EnumHelper.makeEnum(SpawnCategory.class, (String)name, (int)id++, List.of(), List.of()));
                newTypes.add(spawnCategory);
                ArclightServer.LOGGER.debug("Registered {} as spawn category {}", (Object)name, (Object)spawnCategory);
            }
        }
        EnumHelper.addEnums(SpawnCategory.class, newTypes);
    }

    private static void loadStats() {
        int i = Statistic.values().length;
        ArrayList<Statistic> newTypes = new ArrayList<Statistic>();
        Field key = Arrays.stream(Statistic.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset((Field)key);
        for (StatType statType : BuiltInRegistries.f_256899_) {
            ResourceLocation location;
            Statistic statistic;
            if (statType == Stats.f_12988_ || (statistic = (Statistic)STATS.get((Object)(location = BuiltInRegistries.f_256899_.m_7981_((Object)statType)))) != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            Statistic.Type type = statType.m_12893_() == BuiltInRegistries.f_256780_ ? Statistic.Type.ENTITY : (statType.m_12893_() == BuiltInRegistries.f_256975_ ? Statistic.Type.BLOCK : (statType.m_12893_() == BuiltInRegistries.f_257033_ ? Statistic.Type.ITEM : Statistic.Type.UNTYPED));
            statistic = (Statistic)EnumHelper.makeEnum(Statistic.class, (String)standardName, (int)i, (List)ImmutableList.of(Statistic.Type.class), (List)ImmutableList.of((Object)((Object)type)));
            Unsafe.putObject((Object)statistic, (long)keyOffset, (Object)location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            ArclightServer.LOGGER.debug("Registered {} as stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        for (ResourceLocation location : BuiltInRegistries.f_256771_) {
            Statistic statistic = (Statistic)STATS.get((Object)location);
            if (statistic != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            statistic = (Statistic)EnumHelper.makeEnum(Statistic.class, (String)standardName, (int)i, (List)ImmutableList.of(), (List)ImmutableList.of());
            Unsafe.putObject((Object)statistic, (long)keyOffset, (Object)location);
            newTypes.add(statistic);
            STATS.put((Object)location, (Object)statistic);
            ArclightServer.LOGGER.debug("Registered {} as custom stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        EnumHelper.addEnums(Statistic.class, newTypes);
        BukkitRegistry.putStatic(CraftStatistic.class, "statistics", STATS);
    }

    private static void loadArts() {
        int i = Art.values().length;
        ArrayList<Art> newTypes = new ArrayList<Art>();
        Field key = Arrays.stream(Art.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset((Field)key);
        for (PaintingVariant paintingType : BuiltInRegistries.f_257051_) {
            ResourceLocation location = BuiltInRegistries.f_257051_.m_7981_((Object)paintingType);
            String lookupName = location.m_135815_().toLowerCase(Locale.ROOT);
            Art bukkit = Art.getByName(lookupName);
            if (bukkit != null) continue;
            String standardName = ResourceLocationUtil.standardize(location);
            bukkit = (Art)EnumHelper.makeEnum(Art.class, (String)standardName, (int)i, (List)ImmutableList.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), (List)ImmutableList.of((Object)i, (Object)paintingType.m_218908_(), (Object)paintingType.m_218909_()));
            newTypes.add(bukkit);
            Unsafe.putObject((Object)bukkit, (long)keyOffset, (Object)CraftNamespacedKey.fromMinecraft(location));
            ART_BY_ID.put(i, bukkit);
            ART_BY_NAME.put(lookupName, bukkit);
            ArclightServer.LOGGER.debug("Registered {} as art {}", (Object)location, (Object)bukkit);
            ++i;
        }
        EnumHelper.addEnums(Art.class, newTypes);
    }

    private static void loadBiomes(DedicatedServer console) {
        int i = Biome.values().length;
        ArrayList<Biome> newTypes = new ArrayList<Biome>();
        Field key = Arrays.stream(Biome.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset((Field)key);
        net.minecraft.core.Registry registry = console.m_206579_().m_175515_(Registries.f_256952_);
        for (net.minecraft.world.level.biome.Biome biome : registry) {
            Biome bukkit;
            ResourceLocation location = registry.m_7981_((Object)biome);
            String name = ResourceLocationUtil.standardize(location);
            try {
                bukkit = Biome.valueOf(name);
            }
            catch (Throwable t) {
                bukkit = null;
            }
            if (bukkit != null) continue;
            bukkit = (Biome)EnumHelper.makeEnum(Biome.class, (String)name, (int)i++, (List)ImmutableList.of(), (List)ImmutableList.of());
            newTypes.add(bukkit);
            Unsafe.putObject((Object)bukkit, (long)keyOffset, (Object)CraftNamespacedKey.fromMinecraft(location));
            ArclightServer.LOGGER.debug("Registered {} as biome {}", (Object)location, (Object)bukkit);
        }
        EnumHelper.addEnums(Biome.class, newTypes);
        ArclightServer.LOGGER.info("registry.biome", (Object)newTypes.size());
    }

    private static void loadVillagerProfessions() {
        int i = Villager.Profession.values().length;
        ArrayList<Villager.Profession> newTypes = new ArrayList<Villager.Profession>();
        Field key = Arrays.stream(Villager.Profession.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset((Field)key);
        for (VillagerProfession villagerProfession : BuiltInRegistries.f_256735_) {
            Villager.Profession profession;
            ResourceLocation location = BuiltInRegistries.f_256735_.m_7981_((Object)villagerProfession);
            String name = ResourceLocationUtil.standardize(location);
            try {
                profession = Villager.Profession.valueOf(name);
            }
            catch (Throwable t) {
                profession = null;
            }
            if (profession != null) continue;
            profession = (Villager.Profession)EnumHelper.makeEnum(Villager.Profession.class, (String)name, (int)i++, (List)ImmutableList.of(), (List)ImmutableList.of());
            newTypes.add(profession);
            Unsafe.putObject((Object)profession, (long)keyOffset, (Object)CraftNamespacedKey.fromMinecraft(location));
            ArclightServer.LOGGER.debug("Registered {} as villager profession {}", (Object)location, (Object)profession);
        }
        EnumHelper.addEnums(Villager.Profession.class, newTypes);
        ArclightServer.LOGGER.info("registry.villager-profession", (Object)newTypes.size());
    }

    public static void registerEnvironments(net.minecraft.core.Registry<LevelStem> registry) {
        int i = World.Environment.values().length;
        ArrayList<World.Environment> newTypes = new ArrayList<World.Environment>();
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment = (World.Environment)((Object)DIM_MAP.get((Object)key));
            if (environment != null) continue;
            String name = ResourceLocationUtil.standardize(key.m_135782_());
            environment = (World.Environment)((Object)EnumHelper.makeEnum(World.Environment.class, (String)name, (int)i, ENV_CTOR, (List)ImmutableList.of((Object)(i - 1))));
            newTypes.add(environment);
            ENVIRONMENT_MAP.put(i - 1, environment);
            DIM_MAP.put((Object)key, (Object)environment);
            ArclightServer.LOGGER.debug("Registered {} as environment {}", (Object)key.m_135782_(), (Object)environment);
            ++i;
        }
        EnumHelper.addEnums(World.Environment.class, newTypes);
        ArclightServer.LOGGER.info("registry.environment", (Object)newTypes.size());
    }

    private static void loadEntities() {
        int origin;
        int i = origin = EntityType.values().length;
        ArrayList<EntityType> newTypes = new ArrayList<EntityType>(BuiltInRegistries.f_256780_.m_6579_().size() - origin + 1);
        for (net.minecraft.world.entity.EntityType type : BuiltInRegistries.f_256780_) {
            ResourceLocation location = BuiltInRegistries.f_256780_.m_7981_((Object)type);
            EntityType entityType = null;
            boolean found = false;
            if (location.m_135827_().equals("minecraft")) {
                entityType = EntityType.fromName(location.m_135815_());
                if (entityType != null) {
                    found = true;
                    ((EntityTypeBridge)((Object)entityType)).bridge$setHandle(type);
                } else {
                    ArclightServer.LOGGER.warn("Not found {} in {}", (Object)location, EntityType.class);
                }
            }
            if (!found) {
                String name = ResourceLocationUtil.standardize(location);
                entityType = (EntityType)EnumHelper.makeEnum(EntityType.class, (String)name, (int)i++, ENTITY_CTOR, (List)ImmutableList.of((Object)location.m_135815_(), Entity.class, (Object)-1));
                ((EntityTypeBridge)((Object)entityType)).bridge$setup(location, type, BukkitRegistry.entitySpec(location));
                newTypes.add(entityType);
                ArclightServer.LOGGER.debug("Registered {} as entity {}", (Object)location, (Object)entityType);
            }
            ENTITY_NAME_MAP.put(location.toString(), entityType);
        }
        EnumHelper.addEnums(EntityType.class, newTypes);
        EntityClassLookup.init();
        ArclightServer.LOGGER.info("registry.entity-type", (Object)newTypes.size());
    }

    private static void loadEnchantmentTargets() {
        int origin = EnchantmentTarget.values().length;
        int size = EnchantmentCategory.values().length;
    }

    private static void loadPotions() {
        int typeId = PotionType.values().length;
        ArrayList<PotionType> newTypes = new ArrayList<PotionType>();
        for (Potion potion : BuiltInRegistries.f_256980_) {
            ResourceLocation location = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
            String name = ResourceLocationUtil.standardize(location);
            try {
                PotionType.valueOf(name);
            }
            catch (Exception e) {
                PotionType potionType = (PotionType)EnumHelper.makeEnum(PotionType.class, (String)name, (int)typeId++, List.of(String.class), List.of(location.toString()));
                newTypes.add(potionType);
                ArclightServer.LOGGER.debug("Registered {} as potion type {}", (Object)location, (Object)potionType);
            }
        }
        EnumHelper.addEnums(PotionType.class, newTypes);
    }

    private static void loadMaterials() {
        Item value;
        Material material;
        String name;
        ResourceLocation location;
        int i;
        int blocks = 0;
        int items = 0;
        int origin = i = Material.values().length;
        ArrayList<Material> list = new ArrayList<Material>();
        for (Block block : BuiltInRegistries.f_256975_) {
            location = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = (Material)EnumHelper.makeEnum(Material.class, (String)name, (int)i, MAT_CTOR, (List)ImmutableList.of((Object)i));
                ((MaterialBridge)((Object)material)).bridge$setupBlock(location, block, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++blocks;
                ArclightServer.LOGGER.debug("Registered {} as block {}", (Object)location, (Object)material);
                list.add(material);
            } else {
                ((MaterialBridge)((Object)material)).bridge$setupVanillaBlock(BukkitRegistry.matSpec(location));
            }
            BLOCK_MATERIAL.put(block, material);
            MATERIAL_BLOCK.put(material, block);
            value = (Item)BuiltInRegistries.f_257033_.m_7745_(location);
            if (value == null || value == Items.f_41852_) continue;
            ((MaterialBridge)((Object)material)).bridge$setItem();
            ITEM_MATERIAL.put(value, material);
            MATERIAL_ITEM.put(material, value);
        }
        for (Item item : BuiltInRegistries.f_257033_) {
            location = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = (Material)EnumHelper.makeEnum(Material.class, (String)name, (int)i, MAT_CTOR, (List)ImmutableList.of((Object)i));
                ((MaterialBridge)((Object)material)).bridge$setupItem(location, item, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++items;
                ArclightServer.LOGGER.debug("Registered {} as item {}", (Object)location, (Object)material);
                list.add(material);
            }
            ITEM_MATERIAL.put(item, material);
            MATERIAL_ITEM.put(material, item);
            value = (Block)BuiltInRegistries.f_256975_.m_7745_(location);
            if (value == null || value == Blocks.f_50016_) continue;
            ((MaterialBridge)((Object)material)).bridge$setBlock();
            BLOCK_MATERIAL.put((Block)value, material);
            MATERIAL_BLOCK.put(material, (Block)value);
        }
        EnumHelper.addEnums(Material.class, list);
        ArclightServer.LOGGER.info("registry.material", (Object)(i - origin), (Object)blocks, (Object)items);
    }

    private static MaterialPropertySpec matSpec(ResourceLocation location) {
        return ArclightConfig.spec().getCompat().getMaterial(location.toString()).orElse(MaterialPropertySpec.EMPTY);
    }

    private static EntityPropertySpec entitySpec(ResourceLocation location) {
        return ArclightConfig.spec().getCompat().getEntity(location.toString()).orElse(EntityPropertySpec.EMPTY);
    }

    public static Pose toBukkitPose(net.minecraft.world.entity.Pose nms) {
        if (Pose.values().length <= nms.ordinal()) {
            ArrayList<Pose> newTypes = new ArrayList<Pose>();
            int forgeCount = net.minecraft.world.entity.Pose.values().length;
            for (int id = Pose.values().length; id < forgeCount; ++id) {
                String name = net.minecraft.world.entity.Pose.values()[id].name();
                Pose newPhase = (Pose)((Object)EnumHelper.makeEnum(Pose.class, (String)name, (int)id, List.of(), List.of()));
                newTypes.add(newPhase);
                ArclightServer.LOGGER.debug("Registered {} as pose {}", (Object)name, (Object)newPhase);
            }
            EnumHelper.addEnums(Pose.class, newTypes);
        }
        return Pose.values()[nms.ordinal()];
    }

    private static void putStatic(Class<?> cl, String name, Object o) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase((Field)field);
            long materialByNameOffset = Unsafe.staticFieldOffset((Field)field);
            Unsafe.putObject((Object)materialByNameBase, (long)materialByNameOffset, (Object)o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void putBool(Class<?> cl, String name, boolean b) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase((Field)field);
            long materialByNameOffset = Unsafe.staticFieldOffset((Field)field);
            Unsafe.putBoolean((Object)materialByNameBase, (long)materialByNameOffset, (boolean)b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

