/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server.event;

import io.izzel.arclight.common.bridge.core.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.level.block.BlockBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.inventory.ItemStack;

public abstract class ArclightEventFactory {
    public static void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    public static EntityRegainHealthEvent callEntityRegainHealthEvent(Entity entity, float amount, EntityRegainHealthEvent.RegainReason regainReason) {
        EntityRegainHealthEvent event = new EntityRegainHealthEvent(entity, amount, regainReason);
        ArclightEventFactory.callEvent(event);
        return event;
    }

    public static EntityResurrectEvent callEntityResurrectEvent(org.bukkit.entity.LivingEntity livingEntity) {
        EntityResurrectEvent event = new EntityResurrectEvent(livingEntity);
        ArclightEventFactory.callEvent(event);
        return event;
    }

    public static void callEntityDeathEvent(LivingEntity entity, List<ItemStack> drops) {
        CraftLivingEntity craftLivingEntity = ((LivingEntityBridge)entity).bridge$getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent(craftLivingEntity, drops, ((LivingEntityBridge)entity).bridge$getExpReward());
        ArclightEventFactory.callEvent(event);
        ((LivingEntityBridge)entity).bridge$setExpToDrop(event.getDroppedExp());
    }

    public static EntityDeathEvent callEntityDeathEvent(org.bukkit.entity.LivingEntity entity, List<ItemStack> drops, int droppedExp) {
        EntityDeathEvent event = new EntityDeathEvent(entity, drops, droppedExp);
        ArclightEventFactory.callEvent(event);
        return event;
    }

    public static EntityDropItemEvent callEntityDropItemEvent(Entity entity, Item drop) {
        EntityDropItemEvent bukkitEvent = new EntityDropItemEvent(entity, drop);
        ArclightEventFactory.callEvent(bukkitEvent);
        return bukkitEvent;
    }

    public static boolean onBlockBreak(ServerPlayerGameMode controller, ServerLevel level, ServerPlayer player, BlockPos pos, net.minecraft.world.level.block.state.BlockState state, boolean isSwordNoBreak) {
        if (level.m_7702_(pos) == null && !isSwordNoBreak) {
            ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(pos, Blocks.f_50016_.m_49966_());
            player.f_8906_.m_141995_((Packet)packet);
        }
        CraftBlock bblock = CraftBlock.at((LevelAccessor)level, pos);
        BlockBreakEvent event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (org.bukkit.entity.Player)((Object)player.bridge$getBukkitEntity()));
        ArclightCaptures.captureBlockBreakPlayer(event);
        event.setCancelled(isSwordNoBreak);
        Block nmsBlock = state.m_60734_();
        net.minecraft.world.item.ItemStack itemstack = player.m_6844_(EquipmentSlot.MAINHAND);
        if (!event.isCancelled() && !controller.m_9295_() && player.m_36298_(nmsBlock.m_49966_())) {
            event.setExpToDrop(((BlockBridge)nmsBlock).bridge$getExpDrop(state, level, pos, itemstack));
        }
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            Packet packet;
            if (isSwordNoBreak) {
                return false;
            }
            player.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            for (Direction dir : Direction.values()) {
                player.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos.m_121945_(dir)));
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null && (packet = blockEntity.m_58483_()) != null) {
                player.f_8906_.m_141995_(packet);
            }
            return false;
        }
        return !level.m_8055_(pos).m_60795_();
    }

    public static InteractionResult onBlockPlace(UseOnContext context, Player player, net.minecraft.world.item.ItemStack oldStack, net.minecraft.world.item.ItemStack currentStack, InteractionResult result) {
        ServerLevel world = (ServerLevel)context.m_43725_();
        BlockPos blockposition = context.m_8083_();
        InteractionHand enumhand = context.m_43724_();
        BlockPlaceEvent placeEvent = null;
        ArrayList<BlockState> blocks = new ArrayList<BlockState>(((WorldBridge)world).bridge$getCapturedBlockState().values());
        int newSize = currentStack.m_41613_();
        CompoundTag newNBT = null;
        if (currentStack.m_41783_() != null) {
            newNBT = currentStack.m_41783_().m_6426_();
        }
        int size = oldStack.m_41613_();
        CompoundTag nbt = null;
        if (oldStack.m_41783_() != null) {
            nbt = oldStack.m_41783_().m_6426_();
        }
        currentStack.m_41764_(size);
        currentStack.m_41751_(nbt);
        if (blocks.size() > 1) {
            placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, player, enumhand, blocks, blockposition.m_123341_(), blockposition.m_123342_(), blockposition.m_123343_());
        } else if (blocks.size() == 1) {
            placeEvent = CraftEventFactory.callBlockPlaceEvent(world, player, enumhand, (BlockState)blocks.get(0), blockposition.m_123341_(), blockposition.m_123342_(), blockposition.m_123343_());
        }
        if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
            result = InteractionResult.FAIL;
            placeEvent.getPlayer().updateInventory();
            ((WorldBridge)world).bridge$preventPoiUpdated(true);
            for (BlockState blockState : blocks) {
                blockState.update(true, false);
            }
            ((WorldBridge)world).bridge$preventPoiUpdated(false);
            BlockPos placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
            for (Direction dir : Direction.values()) {
                ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, placedPos.m_121945_(dir)));
            }
        } else {
            BlockPos position;
            net.minecraft.world.level.block.state.BlockState blockState;
            if (currentStack.m_41613_() == size && Objects.equals(currentStack.m_41783_(), nbt)) {
                currentStack.m_41751_(newNBT);
                currentStack.m_41764_(newSize);
            }
            for (Map.Entry<BlockPos, BlockEntity> entry : ((WorldBridge)world).bridge$getCapturedBlockEntity().entrySet()) {
                world.m_151523_(entry.getValue());
            }
            for (BlockState blockState2 : blocks) {
                int updateFlag = ((CraftBlockState)blockState2).getFlag();
                net.minecraft.world.level.block.state.BlockState oldBlock = ((CraftBlockState)blockState2).getHandle();
                BlockPos newblockposition = ((CraftBlockState)blockState2).getPosition();
                net.minecraft.world.level.block.state.BlockState block = world.m_8055_(newblockposition);
                block.m_60734_().m_6807_(block, (Level)world, newblockposition, oldBlock, true);
                ((WorldBridge)world).bridge$forge$notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, updateFlag, 512);
            }
            if (placeEvent != null && currentStack.m_41720_() instanceof BedItem && (blockState = world.m_8055_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).m_60734_() instanceof BedBlock) {
                world.m_6289_(position, Blocks.f_50016_);
                blockState.m_60701_((LevelAccessor)world, position, 3);
            }
        }
        return result;
    }
}

