/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.izzel.arclight.i18n.ArclightConfig;
import io.netty.buffer.Unpooled;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.jetbrains.annotations.NotNull;

public class VelocitySupport {
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    public static final int MODERN_FORWARDING_WITH_KEY = 2;
    public static final int MODERN_FORWARDING_WITH_KEY_V2 = 3;
    public static final int MODERN_LAZY_SESSION = 4;
    public static final byte MAX_SUPPORTED_FORWARDING_VERSION = 4;
    public static final ResourceLocation PLAYER_INFO_CHANNEL = new ResourceLocation("velocity", "player_info");

    public static boolean isEnabled() {
        return ArclightConfig.spec().getVelocity().isEnable();
    }

    public static CustomQueryPayload createPacket() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeByte(4);
        return new VelocityForwardQuery(buf);
    }

    public static boolean checkIntegrity(FriendlyByteBuf buf) {
        byte[] signature = new byte[32];
        buf.readBytes(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(ArclightConfig.spec().getVelocity().getSecret().getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    public static InetAddress readAddress(FriendlyByteBuf buf) {
        return InetAddresses.forString((String)buf.m_130136_(Short.MAX_VALUE));
    }

    public static GameProfile createProfile(FriendlyByteBuf buf) {
        GameProfile profile = new GameProfile(buf.m_130259_(), buf.m_130136_(16));
        VelocitySupport.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(FriendlyByteBuf buf, GameProfile profile) {
        int properties = buf.m_130242_();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.m_130136_(Short.MAX_VALUE);
            String value = buf.m_130136_(Short.MAX_VALUE);
            String signature = buf.readBoolean() ? buf.m_130136_(Short.MAX_VALUE) : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }

    public static ProfilePublicKey.Data readForwardedKey(FriendlyByteBuf buf) {
        return new ProfilePublicKey.Data(buf);
    }

    public static UUID readSignerUuidOrElse(FriendlyByteBuf buf, UUID orElse) {
        return buf.readBoolean() ? buf.m_130259_() : orElse;
    }

    private record VelocityForwardQuery(FriendlyByteBuf data) implements CustomQueryPayload
    {
        @NotNull
        public ResourceLocation m_293131_() {
            return PLAYER_INFO_CHANNEL;
        }

        public void m_294761_(@NotNull FriendlyByteBuf buf) {
            buf.writeBytes(this.data.slice());
        }
    }
}

