/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class IteratorUtil {
    public static <T> Iterator<T> filter(Iterator<T> iterator, Predicate<T> predicate) {
        return new FilterIterator<T>(iterator, predicate);
    }

    private static class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private final Predicate<T> predicate;
        private boolean nextComputed = false;
        private boolean hasNext = false;
        private T next;

        private FilterIterator(Iterator<T> iterator, Predicate<T> predicate) {
            this.iterator = iterator;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextComputed) {
                this.computeNext();
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.nextComputed) {
                this.computeNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.next;
                return t;
            }
            finally {
                this.nextComputed = false;
            }
        }

        private void computeNext() {
            this.nextComputed = true;
            while (this.iterator.hasNext()) {
                T next = this.iterator.next();
                if (!this.predicate.test(next)) continue;
                this.hasNext = true;
                this.next = next;
                return;
            }
            this.hasNext = false;
            this.next = null;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

