/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forge.mixin.core.server;

import com.google.common.collect.ImmutableSet;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin_Forge
implements MinecraftServerBridge {
    @Shadow(remap=false)
    public abstract void markWorldsDirty();

    @Override
    public void bridge$platform$loadLevel(Level level) {
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)level));
    }

    @Override
    public void bridge$platform$unloadLevel(Level level) {
        MinecraftForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)level));
    }

    @Override
    public void bridge$forge$markLevelsDirty() {
        this.markWorldsDirty();
    }

    @Override
    public void bridge$platform$serverStarted() {
        ServerLifecycleHooks.handleServerStarted((MinecraftServer)((MinecraftServer)this));
    }

    @Override
    public void bridge$platform$serverStopping() {
        ServerLifecycleHooks.handleServerStopping((MinecraftServer)((MinecraftServer)this));
    }

    @Override
    public void bridge$forge$expectServerStopped() {
        ServerLifecycleHooks.expectServerStopped();
    }

    @Override
    public void bridge$platform$serverStopped() {
        ServerLifecycleHooks.handleServerStopped((MinecraftServer)((MinecraftServer)this));
    }

    @Override
    public void bridge$forge$reinstatePersistentChunks(ServerLevel level, ForcedChunksSavedData savedData) {
        ForgeChunkManager.reinstatePersistentChunks((ServerLevel)level, (ForcedChunksSavedData)savedData);
    }

    private static Set<IForgeRegistry<?>> arclight$registries() {
        return ImmutableSet.of((Object)ForgeRegistries.BLOCKS, (Object)ForgeRegistries.ITEMS, (Object)ForgeRegistries.MOB_EFFECTS, (Object)ForgeRegistries.POTIONS, (Object)ForgeRegistries.ENTITY_TYPES, (Object)ForgeRegistries.BLOCK_ENTITY_TYPES, (Object[])new IForgeRegistry[]{ForgeRegistries.BIOMES});
    }

    @Override
    public void bridge$forge$lockRegistries() {
        for (IForgeRegistry<?> registry : MinecraftServerMixin_Forge.arclight$registries()) {
            if (!(registry instanceof ForgeRegistry)) continue;
            ((ForgeRegistry)registry).freeze();
        }
    }

    @Override
    public void bridge$forge$unlockRegistries() {
        for (IForgeRegistry<?> registry : MinecraftServerMixin_Forge.arclight$registries()) {
            if (!(registry instanceof ForgeRegistry)) continue;
            ((ForgeRegistry)registry).unfreeze();
        }
    }
}

