/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forge.mixin.core.world.entity;

import io.izzel.arclight.common.bridge.core.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.forge.mixin.core.world.entity.EntityMixin_Forge;
import io.izzel.tools.product.Product;
import io.izzel.tools.product.Product3;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Forge
extends EntityMixin_Forge
implements LivingEntityBridge {
    @Shadow
    public abstract boolean m_5803_();

    @Shadow
    public abstract Collection<MobEffectInstance> m_21220_();

    @Shadow
    protected abstract void m_21226_();

    @Inject(method={"hurt"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$livingHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!ForgeHooks.onLivingAttack((LivingEntity)((LivingEntity)this), (DamageSource)source, (float)amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", ordinal=0, remap=false, target="Lnet/minecraft/world/entity/LivingEntity;captureDrops(Ljava/util/Collection;)Ljava/util/Collection;"))
    private Collection<ItemEntity> arclight$captureIfNeed(LivingEntity livingEntity, Collection<ItemEntity> value) {
        Collection drops = livingEntity.captureDrops();
        return drops == null ? livingEntity.captureDrops(value) : drops;
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", remap=false, target="Ljava/util/Collection;forEach(Ljava/util/function/Consumer;)V"))
    private void arclight$cancelEvent(Collection<ItemEntity> collection, Consumer<ItemEntity> action) {
        if (this instanceof ServerPlayerEntityBridge) {
            this.captureDrops(collection);
        } else {
            collection.forEach(action);
        }
    }

    @Redirect(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropExperience()V"))
    private void arclight$dropLater(LivingEntity livingEntity) {
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="RETURN")})
    private void arclight$dropLast(DamageSource damageSourceIn, CallbackInfo ci) {
        this.m_21226_();
    }

    @Override
    public boolean bridge$forge$mobEffectExpired(MobEffectInstance effect) {
        return MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Expired((LivingEntity)this, effect));
    }

    @Override
    public boolean bridge$forge$mobEffectAdded(MobEffectInstance old, MobEffectInstance effect, Entity entity) {
        return MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added((LivingEntity)this, old, effect, entity));
    }

    @Override
    public float bridge$forge$onLivingHurt(LivingEntity entity, DamageSource src, float amount) {
        return ForgeHooks.onLivingHurt((LivingEntity)entity, (DamageSource)src, (float)amount);
    }

    @Override
    public Product3<Boolean, Float, Boolean> bridge$forge$onShieldBlock(LivingEntity blocker, DamageSource source, float blocked) {
        ShieldBlockEvent event = ForgeEventFactory.onShieldBlock((LivingEntity)blocker, (DamageSource)source, (float)blocked);
        return Product.of((Object)event.isCanceled(), (Object)Float.valueOf(event.getBlockedDamage()), (Object)event.shieldTakesDamage());
    }

    @Override
    public float bridge$forge$onLivingDamage(LivingEntity entity, DamageSource src, float amount) {
        return ForgeHooks.onLivingDamage((LivingEntity)entity, (DamageSource)src, (float)amount);
    }

    @Override
    public boolean bridge$forge$onLivingUseTotem(LivingEntity entity, DamageSource damageSource, ItemStack totem, InteractionHand hand) {
        return ForgeHooks.onLivingUseTotem((LivingEntity)entity, (DamageSource)damageSource, (ItemStack)totem, (InteractionHand)hand);
    }

    @Override
    @Nullable
    public LivingEntity bridge$forge$onLivingChangeTarget(LivingEntity entity, LivingEntity originalTarget, LivingEntityBridge.LivingTargetType targetType) {
        LivingChangeTargetEvent event = ForgeHooks.onLivingChangeTarget((LivingEntity)entity, (LivingEntity)originalTarget, (LivingChangeTargetEvent.ILivingTargetType)LivingChangeTargetEvent.LivingTargetType.valueOf((String)targetType.name()));
        return event.isCanceled() ? null : event.getNewTarget();
    }

    @Override
    public BlockPos bridge$forge$onEnderTeleport(LivingEntity entity, double targetX, double targetY, double targetZ) {
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)entity, (double)targetX, (double)targetY, (double)targetZ);
        return event.isCanceled() ? null : BlockPos.m_274446_((Position)event.getTarget());
    }

    @Override
    public void bridge$forge$onLivingConvert(LivingEntity entity, LivingEntity outcome) {
        ForgeEventFactory.onLivingConvert((LivingEntity)entity, (LivingEntity)outcome);
    }

    @Override
    public boolean bridge$forge$canEntityDestroy(Level level, BlockPos pos, LivingEntity entity) {
        return ForgeHooks.canEntityDestroy((Level)level, (BlockPos)pos, (LivingEntity)entity);
    }

    @Override
    public boolean bridge$forge$onEntityDestroyBlock(LivingEntity entity, BlockPos pos, BlockState state) {
        return ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public void bridge$common$startCaptureDrops() {
    }

    @Override
    public boolean bridge$common$isCapturingDrops() {
        return false;
    }

    @Override
    public void bridge$common$captureDrop(ItemEntity itemEntity) {
    }

    @Override
    public Collection<ItemEntity> bridge$common$getCapturedDrops() {
        return this.captureDrops(null);
    }

    @Override
    public void bridge$common$finishCaptureAndFireEvent() {
    }
}

