/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forge.mixin.core.world.entity.player;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.inventory.container.ContainerBridge;
import io.izzel.arclight.common.bridge.core.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.level.block.PortalInfoBridge;
import io.izzel.arclight.common.mod.server.block.ChestBlockDoubleInventoryHacks;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.forge.mixin.core.world.entity.player.PlayerMixin_Forge;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin_Forge
extends PlayerMixin_Forge
implements ServerPlayerEntityBridge {
    @Shadow
    public boolean f_8927_;
    @Shadow
    public boolean f_8944_;
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Shadow
    private boolean f_8928_;
    @Shadow
    @Final
    public MinecraftServer f_8924_;
    @Shadow
    @Nullable
    private Vec3 f_8933_;
    @Shadow
    @Final
    public ServerPlayerGameMode f_8941_;
    @Shadow
    public int f_8920_;
    @Shadow
    private float f_8917_;
    @Shadow
    private int f_8918_;

    @Shadow
    public abstract ServerLevel m_284548_();

    @Shadow
    public abstract CommonPlayerSpawnInfo m_292591_(ServerLevel var1);

    @Shadow
    protected abstract void m_9006_(ServerLevel var1, BlockPos var2);

    @Shadow
    public abstract void m_284127_(ServerLevel var1);

    @Shadow
    public abstract void m_9209_(ServerLevel var1);

    @Inject(method={"die"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$onDeath(DamageSource source, CallbackInfo ci) {
        if (ForgeHooks.onLivingDeath((LivingEntity)((ServerPlayer)this), (DamageSource)source)) {
            ci.cancel();
        }
    }

    @Inject(method={"openHorseInventory"}, at={@At(value="TAIL")})
    private void arclight$openHorstContainer(AbstractHorse arg, Container arg2, CallbackInfo ci) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)((ServerPlayer)this), this.f_36096_));
    }

    @Inject(method={"setRespawnPosition"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$forgeRespawnPos(ResourceKey<Level> arg, BlockPos arg2, float f, boolean bl, boolean bl2, CallbackInfo ci) {
        if (ForgeEventFactory.onPlayerSpawnSet((Player)((ServerPlayer)this), arg2 == null ? Level.f_46428_ : arg, (BlockPos)arg2, (boolean)bl)) {
            ci.cancel();
        }
    }

    @Override
    @Nullable
    public Entity m_5489_(ServerLevel arg) {
        return this.changeDimension(arg, (ITeleporter)arg.m_8871_());
    }

    @Override
    @Overwrite(remap=false)
    @Nullable
    public Entity changeDimension(ServerLevel server, ITeleporter teleporter) {
        PlayerTeleportEvent.TeleportCause cause = this.bridge$getTeleportCause().orElse(PlayerTeleportEvent.TeleportCause.UNKNOWN);
        if (this.m_5803_()) {
            return (ServerPlayer)this;
        }
        if (ForgeEventFactory.onTravelToDimension((Entity)((ServerPlayer)this), (ResourceKey)server.m_46472_())) {
            return null;
        }
        ServerLevel serverworld = this.m_284548_();
        ResourceKey<LevelStem> registrykey = ((WorldBridge)serverworld).bridge$getTypeKey();
        if (registrykey == LevelStem.f_63973_ && ((WorldBridge)server).bridge$getTypeKey() == LevelStem.f_63971_ && teleporter.isVanilla()) {
            this.f_8927_ = true;
            this.m_19877_();
            this.m_284548_().m_143261_((ServerPlayer)this, Entity.RemovalReason.CHANGED_DIMENSION);
            if (!this.f_8944_) {
                this.f_8944_ = true;
                this.f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132157_, this.f_8928_ ? 0.0f : 1.0f));
                this.f_8928_ = true;
            }
            return (ServerPlayer)this;
        }
        PortalInfo portalinfo = teleporter.getPortalInfo((Entity)((ServerPlayer)this), server, x$0 -> this.m_7937_((ServerLevel)x$0));
        if (portalinfo != null) {
            if (((PortalInfoBridge)portalinfo).bridge$getWorld() != null) {
                server = ((PortalInfoBridge)portalinfo).bridge$getWorld();
            }
            ServerLevel[] exitWorld = new ServerLevel[]{server};
            LevelData iworldinfo = server.m_6106_();
            this.f_8906_.m_141995_((Packet)new ClientboundRespawnPacket(this.m_292591_(server), 3));
            this.f_8906_.m_141995_((Packet)new ClientboundChangeDifficultyPacket(iworldinfo.m_5472_(), iworldinfo.m_5474_()));
            PlayerList playerlist = this.f_8924_.m_6846_();
            playerlist.m_11289_((ServerPlayer)this);
            this.m_284548_().m_143261_((ServerPlayer)this, Entity.RemovalReason.CHANGED_DIMENSION);
            this.revive();
            Entity e = teleporter.placeEntity((Entity)((ServerPlayer)this), serverworld, exitWorld[0], this.m_146908_(), spawnPortal -> {
                serverworld.m_46473_().m_6180_("moving");
                if (exitWorld[0] != null) {
                    if (registrykey == LevelStem.f_63971_ && ((WorldBridge)exitWorld[0]).bridge$getTypeKey() == LevelStem.f_63972_) {
                        this.f_8933_ = this.m_20182_();
                    } else if (spawnPortal.booleanValue() && ((WorldBridge)exitWorld[0]).bridge$getTypeKey() == LevelStem.f_63973_ && (((PortalInfoBridge)portalinfo).bridge$getPortalEventInfo() == null || ((PortalInfoBridge)portalinfo).bridge$getPortalEventInfo().getCanCreatePortal())) {
                        this.m_9006_(exitWorld[0], BlockPos.m_274446_((Position)portalinfo.f_77676_));
                    }
                }
                Location enter = this.bridge$getBukkitEntity().getLocation();
                Location exit = exitWorld[0] == null ? null : new Location(exitWorld[0].bridge$getWorld(), portalinfo.f_77676_.f_82479_, portalinfo.f_77676_.f_82480_, portalinfo.f_77676_.f_82481_, portalinfo.f_77678_, portalinfo.f_77679_);
                PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((org.bukkit.entity.Player)((Object)this.bridge$getBukkitEntity()), enter, exit, cause);
                Bukkit.getServer().getPluginManager().callEvent(tpEvent);
                if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
                    return null;
                }
                exit = tpEvent.getTo();
                serverworld.m_46473_().m_7238_();
                serverworld.m_46473_().m_6180_("placing");
                this.f_8927_ = true;
                ServerLevel newWorld = ((CraftWorld)exit.getWorld()).getHandle();
                if (newWorld != exitWorld[0]) {
                    exitWorld[0] = newWorld;
                    LevelData newWorldInfo = exitWorld[0].m_6106_();
                    this.f_8906_.m_141995_((Packet)new ClientboundRespawnPacket(this.m_292591_(newWorld), 3));
                    this.f_8906_.m_141995_((Packet)new ClientboundChangeDifficultyPacket(newWorldInfo.m_5472_(), newWorldInfo.m_5474_()));
                }
                this.m_284127_(exitWorld[0]);
                exitWorld[0].m_8817_((ServerPlayer)this);
                ((ServerPlayNetHandlerBridge)this.f_8906_).bridge$teleport(exit);
                this.f_8906_.m_9953_();
                serverworld.m_46473_().m_7238_();
                this.m_9209_(exitWorld[0]);
                return (ServerPlayer)this;
            });
            if (e == null) {
                serverworld.m_8817_((ServerPlayer)this);
                return (ServerPlayer)this;
            }
            if (e != this) {
                throw new IllegalArgumentException(String.format("Teleporter %s returned not the player entity but instead %s, expected PlayerEntity %s", teleporter, e, this));
            }
            this.f_8941_.m_9260_(exitWorld[0]);
            this.f_8906_.m_141995_((Packet)new ClientboundPlayerAbilitiesPacket(this.m_150110_()));
            playerlist.m_11229_((ServerPlayer)this, exitWorld[0]);
            playerlist.m_11292_((ServerPlayer)this);
            for (MobEffectInstance effectinstance : this.m_21220_()) {
                this.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(this.m_19879_(), effectinstance));
            }
            if (teleporter.playTeleportSound((ServerPlayer)this, serverworld, exitWorld[0])) {
                this.f_8906_.m_141995_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
            }
            this.f_8920_ = -1;
            this.f_8917_ = -1.0f;
            this.f_8918_ = -1;
            ForgeEventFactory.onPlayerChangedDimension((Player)((ServerPlayer)this), (ResourceKey)serverworld.m_46472_(), (ResourceKey)exitWorld[0].m_46472_());
            PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((org.bukkit.entity.Player)((Object)this.bridge$getBukkitEntity()), serverworld.bridge$getWorld());
            Bukkit.getPluginManager().callEvent(changeEvent);
        }
        return (ServerPlayer)this;
    }

    @Redirect(method={"openMenu"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;closeContainer()V"))
    private void arclight$skipSwitch(ServerPlayer serverPlayer) {
    }

    @Inject(method={"openMenu"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/MenuProvider;createMenu(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;")})
    private void arclight$invOpen(MenuProvider iTileInventory, CallbackInfoReturnable<OptionalInt> cir, AbstractContainerMenu container) {
        if (container != null) {
            ((ContainerBridge)container).bridge$setTitle(iTileInventory.m_5446_());
            boolean cancelled = false;
            ArclightCaptures.captureContainerOwner((Player)((ServerPlayer)this));
            container = CraftEventFactory.callInventoryOpenEvent((ServerPlayer)this, container, cancelled);
            ArclightCaptures.resetContainerOwner();
            if (container == null && !cancelled) {
                if (iTileInventory instanceof Container) {
                    ((Container)iTileInventory).m_5785_((Player)((ServerPlayer)this));
                } else if (ChestBlockDoubleInventoryHacks.isInstance(iTileInventory)) {
                    ChestBlockDoubleInventoryHacks.get(iTileInventory).m_5785_((Player)((ServerPlayer)this));
                }
                cir.setReturnValue((Object)OptionalInt.empty());
            }
        }
    }
}

