/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forge.mixin.core.world.level;

import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class LevelMixin_Forge
implements WorldBridge {
    @Shadow(remap=false)
    public boolean restoringBlockSnapshots;

    @Shadow(remap=false)
    public abstract void markAndNotifyBlock(BlockPos var1, @Nullable LevelChunk var2, BlockState var3, BlockState var4, int var5, int var6);

    @Shadow
    public abstract ResourceKey<Level> m_46472_();

    @Inject(method={"markAndNotifyBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;updateNeighbourShapes(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;II)V")})
    private void arclight$callBlockPhysics(BlockPos pos, LevelChunk chunk, BlockState blockstate, BlockState state, int flags, int recursionLeft, CallbackInfo ci) {
        try {
            if (this.bridge$getWorld() != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at((LevelAccessor)this, pos), CraftBlockData.fromData(state));
                Bukkit.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
        catch (StackOverflowError e) {
            this.bridge$setLastPhysicsProblem(pos);
        }
    }

    @Inject(method={"markAndNotifyBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void arclight$preventPoiUpdate(BlockPos p_46605_, LevelChunk levelchunk, BlockState blockstate, BlockState p_46606_, int p_46607_, int p_46608_, CallbackInfo ci) {
        if (this.bridge$preventPoiUpdated()) {
            ci.cancel();
        }
    }

    @Override
    public void bridge$forge$notifyAndUpdatePhysics(BlockPos pos, LevelChunk chunk, BlockState oldBlock, BlockState newBlock, int i, int j) {
        this.markAndNotifyBlock(pos, chunk, oldBlock, newBlock, i, j);
    }

    @Override
    public boolean bridge$forge$onBlockPlace(BlockPos pos, LivingEntity livingEntity, Direction direction) {
        return ForgeEventFactory.onBlockPlace((Entity)livingEntity, (BlockSnapshot)BlockSnapshot.create(this.m_46472_(), (LevelAccessor)((Level)this), (BlockPos)pos), (Direction)direction);
    }

    @Override
    public boolean bridge$forge$mobGriefing(Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((Level)((Level)this), (Entity)entity);
    }

    @Override
    public ItemStack bridge$forge$potionBrewMix(ItemStack a, ItemStack b) {
        return BrewingRecipeRegistry.getOutput((ItemStack)a, (ItemStack)b);
    }

    @Override
    public void bridge$forge$onPotionBrewed(NonNullList<ItemStack> stacks) {
        ForgeEventFactory.onPotionBrewed(stacks);
    }

    @Override
    public boolean bridge$forge$restoringBlockSnapshots() {
        return this.restoringBlockSnapshots;
    }
}

