/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.forge.mod;

import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.TransformingClassLoader;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.mod.ArclightCommon;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import org.objectweb.asm.ClassReader;

public class ForgeCommonImpl
implements ArclightCommon.Api {
    private static final MethodHandle MH_TRANSFORM;

    @Override
    public byte[] platformRemapClass(byte[] cl) {
        String className = new ClassReader(cl).getClassName();
        try {
            return MH_TRANSFORM.invokeExact(cl, className.replace('/', '.'), "source");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get() != null ? ModList.get().isLoaded(modid) : FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    static {
        try {
            ClassLoader classLoader = ForgeCommonImpl.class.getClassLoader();
            Field classTransformer = TransformingClassLoader.class.getDeclaredField("classTransformer");
            classTransformer.setAccessible(true);
            ClassTransformer tranformer = (ClassTransformer)classTransformer.get(classLoader);
            Method transform = tranformer.getClass().getDeclaredMethod("transform", byte[].class, String.class, String.class);
            MH_TRANSFORM = Unsafe.lookup().unreflect(transform).bindTo(tranformer);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unknown modlauncher version", t);
        }
    }
}

