/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.banner;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PatternType implements Keyed
{
    BASE("b", "base"),
    SQUARE_BOTTOM_LEFT("bl", "square_bottom_left"),
    SQUARE_BOTTOM_RIGHT("br", "square_bottom_right"),
    SQUARE_TOP_LEFT("tl", "square_top_left"),
    SQUARE_TOP_RIGHT("tr", "square_top_right"),
    STRIPE_BOTTOM("bs", "stripe_bottom"),
    STRIPE_TOP("ts", "stripe_top"),
    STRIPE_LEFT("ls", "stripe_left"),
    STRIPE_RIGHT("rs", "stripe_right"),
    STRIPE_CENTER("cs", "stripe_center"),
    STRIPE_MIDDLE("ms", "stripe_middle"),
    STRIPE_DOWNRIGHT("drs", "stripe_downright"),
    STRIPE_DOWNLEFT("dls", "stripe_downleft"),
    STRIPE_SMALL("ss", "small_stripes"),
    CROSS("cr", "cross"),
    STRAIGHT_CROSS("sc", "straight_cross"),
    TRIANGLE_BOTTOM("bt", "triangle_bottom"),
    TRIANGLE_TOP("tt", "triangle_top"),
    TRIANGLES_BOTTOM("bts", "triangles_bottom"),
    TRIANGLES_TOP("tts", "triangles_top"),
    DIAGONAL_LEFT("ld", "diagonal_left"),
    DIAGONAL_RIGHT("rd", "diagonal_up_right"),
    DIAGONAL_LEFT_MIRROR("lud", "diagonal_up_left"),
    DIAGONAL_RIGHT_MIRROR("rud", "diagonal_right"),
    CIRCLE_MIDDLE("mc", "circle"),
    RHOMBUS_MIDDLE("mr", "rhombus"),
    HALF_VERTICAL("vh", "half_vertical"),
    HALF_HORIZONTAL("hh", "half_horizontal"),
    HALF_VERTICAL_MIRROR("vhr", "half_vertical_right"),
    HALF_HORIZONTAL_MIRROR("hhb", "half_horizontal_bottom"),
    BORDER("bo", "border"),
    CURLY_BORDER("cbo", "curly_border"),
    CREEPER("cre", "creeper"),
    GRADIENT("gra", "gradient"),
    GRADIENT_UP("gru", "gradient_up"),
    BRICKS("bri", "bricks"),
    SKULL("sku", "skull"),
    FLOWER("flo", "flower"),
    MOJANG("moj", "mojang"),
    GLOBE("glb", "globe"),
    PIGLIN("pig", "piglin");

    private final String identifier;
    private final NamespacedKey key;
    private static final Map<String, PatternType> byString;

    static {
        byString = new HashMap<String, PatternType>();
        PatternType[] patternTypeArray = PatternType.values();
        int n = patternTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PatternType p = patternTypeArray[n2];
            byString.put(p.identifier, p);
            ++n2;
        }
    }

    private PatternType(String identifier, String key) {
        this.identifier = identifier;
        this.key = NamespacedKey.minecraft(key);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Deprecated
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PatternType getByIdentifier(@Nullable String identifier) {
        return byString.get(identifier);
    }
}

