/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.block;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Conduit;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.util.BoundingBox;

public class CraftConduit
extends CraftBlockEntityState<ConduitBlockEntity>
implements Conduit {
    public CraftConduit(World world, ConduitBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftConduit(CraftConduit state, Location location) {
        super(state, location);
    }

    @Override
    public CraftConduit copy() {
        return new CraftConduit(this, null);
    }

    @Override
    public CraftConduit copy(Location location) {
        return new CraftConduit(this, location);
    }

    @Override
    public boolean isActive() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        return conduit != null && conduit.m_59216_();
    }

    @Override
    public boolean isHunting() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        return conduit != null && conduit.m_59217_();
    }

    @Override
    public Collection<Block> getFrameBlocks() {
        this.ensureNoWorldGeneration();
        ArrayList<Block> blocks = new ArrayList<Block>();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        if (conduit != null) {
            for (BlockPos position : conduit.f_59188_) {
                blocks.add(CraftBlock.at(this.getWorldHandle(), position));
            }
        }
        return blocks;
    }

    @Override
    public int getFrameBlockCount() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        return conduit != null ? conduit.f_59188_.size() : 0;
    }

    @Override
    public int getRange() {
        this.ensureNoWorldGeneration();
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        return conduit != null ? ConduitBlockEntity.getRange((List)conduit.f_59188_) : 0;
    }

    @Override
    public boolean setTarget(org.bukkit.entity.LivingEntity target) {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        LivingEntity currentTarget = conduit.f_59189_;
        if (target == null) {
            if (currentTarget == null) {
                return false;
            }
            conduit.f_59189_ = null;
            conduit.f_59190_ = null;
        } else {
            if (currentTarget != null && target.getUniqueId().equals(currentTarget.m_20148_())) {
                return false;
            }
            conduit.f_59189_ = ((CraftLivingEntity)target).getHandle();
            conduit.f_59190_ = target.getUniqueId();
        }
        ConduitBlockEntity.updateDestroyTarget((Level)conduit.m_58904_(), (BlockPos)this.getPosition(), (BlockState)this.data, (List)conduit.f_59188_, (ConduitBlockEntity)conduit, (boolean)false);
        return true;
    }

    @Override
    public org.bukkit.entity.LivingEntity getTarget() {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        if (conduit == null) {
            return null;
        }
        LivingEntity nmsEntity = conduit.f_59189_;
        return nmsEntity != null ? (org.bukkit.entity.LivingEntity)((Object)nmsEntity.getBukkitEntity()) : null;
    }

    @Override
    public boolean hasTarget() {
        ConduitBlockEntity conduit = (ConduitBlockEntity)this.getTileEntityFromWorld();
        return conduit != null && conduit.f_59189_ != null && conduit.f_59189_.m_6084_();
    }

    @Override
    public BoundingBox getHuntingArea() {
        AABB bounds = ConduitBlockEntity.m_155431_((BlockPos)this.getPosition());
        return new BoundingBox(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_, bounds.f_82291_, bounds.f_82292_, bounds.f_82293_);
    }
}

