/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.damage;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Entity;

public class CraftDamageSource
implements org.bukkit.damage.DamageSource {
    private final DamageSource damageSource;
    private final org.bukkit.damage.DamageType damageType;

    public CraftDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        this.damageType = CraftDamageType.minecraftHolderToBukkit((Holder<DamageType>)damageSource.m_269150_());
    }

    public DamageSource getHandle() {
        return this.damageSource;
    }

    public World getCausingEntityWorld() {
        Entity causingEntity = this.getCausingEntity();
        return causingEntity != null ? causingEntity.getWorld() : null;
    }

    public Block getDirectBlock() {
        return this.getHandle().getDirectBlock();
    }

    @Override
    public org.bukkit.damage.DamageType getDamageType() {
        return this.damageType;
    }

    @Override
    public Entity getCausingEntity() {
        net.minecraft.world.entity.Entity entity = this.getHandle().getCausingEntity();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    @Override
    public Entity getDirectEntity() {
        net.minecraft.world.entity.Entity entity = this.getHandle().m_7640_();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    @Override
    public Location getDamageLocation() {
        Vec3 vec3D = this.getHandle().m_269181_();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    @Override
    public Location getSourceLocation() {
        Vec3 vec3D = this.getHandle().m_7270_();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    @Override
    public boolean isIndirect() {
        return this.getHandle().getCausingEntity() != this.getHandle().m_7640_();
    }

    @Override
    public float getFoodExhaustion() {
        return this.damageType.getExhaustion();
    }

    @Override
    public boolean scalesWithDifficulty() {
        return this.getHandle().m_7986_();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof org.bukkit.damage.DamageSource)) {
            return false;
        }
        org.bukkit.damage.DamageSource other = (org.bukkit.damage.DamageSource)obj;
        return Objects.equals(this.getDamageType(), other.getDamageType()) && Objects.equals(this.getCausingEntity(), other.getCausingEntity()) && Objects.equals(this.getDirectEntity(), other.getDirectEntity()) && Objects.equals(this.getDamageLocation(), other.getDamageLocation());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.damageType.hashCode();
        result = 31 * result + (this.getCausingEntity() != null ? this.getCausingEntity().hashCode() : 0);
        result = 31 * result + (this.getDirectEntity() != null ? this.getDirectEntity().hashCode() : 0);
        result = 31 * result + (this.getDamageLocation() != null ? this.getDamageLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DamageSource{damageType=" + this.getDamageType() + ",causingEntity=" + this.getCausingEntity() + ",directEntity=" + this.getDirectEntity() + ",damageLocation=" + this.getDamageLocation() + "}";
    }

    public static org.bukkit.damage.DamageSource buildFromBukkit(org.bukkit.damage.DamageType damageType, Entity causingEntity, Entity directEntity, Location damageLocation) {
        Holder<DamageType> holderDamageType = CraftDamageType.bukkitToMinecraftHolder(damageType);
        net.minecraft.world.entity.Entity nmsCausingEntity = null;
        if (causingEntity instanceof CraftEntity var6_7) {
            nmsCausingEntity = craftCausingEntity.getHandle();
        }
        net.minecraft.world.entity.Entity nmsDirectEntity = null;
        if (directEntity instanceof CraftEntity var10_10) {
            nmsDirectEntity = craftDirectEntity.getHandle();
        }
        Vec3 vec3D = damageLocation == null ? null : CraftLocation.toVec3D(damageLocation);
        return new CraftDamageSource(new DamageSource(holderDamageType, nmsDirectEntity, nmsCausingEntity, vec3D));
    }
}

