/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.enchantments;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.enchantment.BindingCurseEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.VanishingCurseEnchantment;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.Handleable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment
implements Handleable<Enchantment> {
    private final NamespacedKey key;
    private final Enchantment handle;
    private final int id;

    public static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        return CraftRegistry.minecraftToBukkit(minecraft, Registries.f_256762_, Registry.ENCHANTMENT);
    }

    public static Enchantment bukkitToMinecraft(org.bukkit.enchantments.Enchantment bukkit) {
        return (Enchantment)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftEnchantment(NamespacedKey key, Enchantment handle) {
        this.key = key;
        this.handle = handle;
        this.id = BuiltInRegistries.f_256876_.m_7447_((Object)handle);
    }

    @Override
    public Enchantment getHandle() {
        return this.handle;
    }

    @Override
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public int getMaxLevel() {
        return this.handle.m_6586_();
    }

    @Override
    public int getStartLevel() {
        return this.handle.m_44702_();
    }

    @Override
    public EnchantmentTarget getItemTarget() {
        return switch (this.handle.f_44672_) {
            case EnchantmentCategory.ARMOR -> EnchantmentTarget.ARMOR;
            case EnchantmentCategory.ARMOR_FEET -> EnchantmentTarget.ARMOR_FEET;
            case EnchantmentCategory.ARMOR_HEAD -> EnchantmentTarget.ARMOR_HEAD;
            case EnchantmentCategory.ARMOR_LEGS -> EnchantmentTarget.ARMOR_LEGS;
            case EnchantmentCategory.ARMOR_CHEST -> EnchantmentTarget.ARMOR_TORSO;
            case EnchantmentCategory.DIGGER -> EnchantmentTarget.TOOL;
            case EnchantmentCategory.WEAPON -> EnchantmentTarget.WEAPON;
            case EnchantmentCategory.BOW -> EnchantmentTarget.BOW;
            case EnchantmentCategory.FISHING_ROD -> EnchantmentTarget.FISHING_ROD;
            case EnchantmentCategory.BREAKABLE -> EnchantmentTarget.BREAKABLE;
            case EnchantmentCategory.WEARABLE -> EnchantmentTarget.WEARABLE;
            case EnchantmentCategory.TRIDENT -> EnchantmentTarget.TRIDENT;
            case EnchantmentCategory.CROSSBOW -> EnchantmentTarget.CROSSBOW;
            case EnchantmentCategory.VANISHABLE -> EnchantmentTarget.VANISHABLE;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public boolean isTreasure() {
        return this.handle.m_6591_();
    }

    @Override
    public boolean isCursed() {
        return this.handle instanceof BindingCurseEnchantment || this.handle instanceof VanishingCurseEnchantment;
    }

    @Override
    public boolean canEnchantItem(ItemStack item) {
        return this.handle.m_6081_(CraftItemStack.asNMSCopy(item));
    }

    @Override
    public String getName() {
        return switch (this.id) {
            case 0 -> "PROTECTION_ENVIRONMENTAL";
            case 1 -> "PROTECTION_FIRE";
            case 2 -> "PROTECTION_FALL";
            case 3 -> "PROTECTION_EXPLOSIONS";
            case 4 -> "PROTECTION_PROJECTILE";
            case 5 -> "OXYGEN";
            case 6 -> "WATER_WORKER";
            case 7 -> "THORNS";
            case 8 -> "DEPTH_STRIDER";
            case 9 -> "FROST_WALKER";
            case 10 -> "BINDING_CURSE";
            case 11 -> "SOUL_SPEED";
            case 12 -> "SWIFT_SNEAK";
            case 13 -> "DAMAGE_ALL";
            case 14 -> "DAMAGE_UNDEAD";
            case 15 -> "DAMAGE_ARTHROPODS";
            case 16 -> "KNOCKBACK";
            case 17 -> "FIRE_ASPECT";
            case 18 -> "LOOT_BONUS_MOBS";
            case 19 -> "SWEEPING_EDGE";
            case 20 -> "DIG_SPEED";
            case 21 -> "SILK_TOUCH";
            case 22 -> "DURABILITY";
            case 23 -> "LOOT_BONUS_BLOCKS";
            case 24 -> "ARROW_DAMAGE";
            case 25 -> "ARROW_KNOCKBACK";
            case 26 -> "ARROW_FIRE";
            case 27 -> "ARROW_INFINITE";
            case 28 -> "LUCK";
            case 29 -> "LURE";
            case 30 -> "LOYALTY";
            case 31 -> "IMPALING";
            case 32 -> "RIPTIDE";
            case 33 -> "CHANNELING";
            case 34 -> "MULTISHOT";
            case 35 -> "QUICK_CHARGE";
            case 36 -> "PIERCING";
            case 37 -> "MENDING";
            case 38 -> "VANISHING_CURSE";
            default -> this.getKey().toString();
        };
    }

    @Override
    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !this.handle.m_44695_(ench.getHandle());
    }

    @Override
    public String getTranslationKey() {
        return this.handle.m_44704_();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        return this.getKey().equals(((org.bukkit.enchantments.Enchantment)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftEnchantment[" + this.getKey() + "]";
    }
}

