/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected net.minecraft.world.entity.Entity entity;
    private final EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final Entity.Spigot spigot = new Entity.Spigot(){

        @Override
        public void sendMessage(BaseComponent component) {
        }

        @Override
        public void sendMessage(BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        @Override
        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }

    public CraftEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.m_6095_());
    }

    public static <T extends net.minecraft.world.entity.Entity> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof Player && !(entity instanceof ServerPlayer)) {
            return new CraftHumanEntity(server, (Player)entity);
        }
        if (entity instanceof EnderDragonPart var2_3) {
            if (complexPart.f_31010_ instanceof EnderDragon) {
                return new CraftEnderDragonPart(server, (EnderDragonPart)complexPart);
            }
            return new CraftComplexPart(server, (EnderDragonPart)complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.m_6095_()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
    }

    @Override
    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.m_20182_(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.m_146909_());
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.m_20185_());
            loc.setY(this.entity.m_20186_());
            loc.setZ(this.entity.m_20189_());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.m_146909_());
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.m_20184_());
    }

    @Override
    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        this.entity.m_20256_(CraftVector.toNMS(velocity));
        this.entity.f_19864_ = true;
    }

    @Override
    public double getHeight() {
        return this.getHandle().m_20206_();
    }

    @Override
    public double getWidth() {
        return this.getHandle().m_20205_();
    }

    @Override
    public BoundingBox getBoundingBox() {
        AABB bb = this.getHandle().m_20191_();
        return new BoundingBox(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof AbstractArrow) {
            return ((AbstractArrow)this.entity).f_36703_;
        }
        return this.entity.m_20096_();
    }

    @Override
    public boolean isInWater() {
        return this.entity.m_20069_();
    }

    @Override
    public World getWorld() {
        return this.entity.m_9236_().getWorld();
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite(pitch, "pitch not finite");
        NumberConversions.checkFinite(yaw, "yaw not finite");
        yaw = Location.normalizeYaw(yaw);
        pitch = Location.normalizePitch(pitch);
        this.entity.m_146922_(yaw);
        this.entity.m_146926_(pitch);
        this.entity.f_19859_ = yaw;
        this.entity.f_19860_ = pitch;
        this.entity.m_5616_(yaw);
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        location.checkFinite();
        if (this.entity.m_20160_() || this.entity.m_213877_()) {
            return false;
        }
        this.entity.m_8127_();
        if (location.getWorld() != null && !location.getWorld().equals(this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.teleportTo(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location));
            return true;
        }
        this.entity.m_19890_(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.m_5616_(location.getYaw());
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y, double z) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List notchEntityList = this.entity.m_9236_().m_6249_(this.entity, this.entity.m_20191_().m_82377_(x, y, z), (Predicate)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.world.entity.Entity e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.m_19879_();
    }

    @Override
    public int getFireTicks() {
        return this.entity.m_20094_();
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.m_6101_();
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.m_7311_(ticks);
    }

    @Override
    public void setVisualFire(boolean fire) {
        this.getHandle().f_146813_ = fire;
    }

    @Override
    public boolean isVisualFire() {
        return this.getHandle().f_146813_;
    }

    @Override
    public int getFreezeTicks() {
        return this.getHandle().m_146888_();
    }

    @Override
    public int getMaxFreezeTicks() {
        return this.getHandle().m_146891_();
    }

    @Override
    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().m_146917_(ticks);
    }

    @Override
    public boolean isFrozen() {
        return this.getHandle().m_146890_();
    }

    @Override
    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    @Override
    public boolean isDead() {
        return !this.entity.m_6084_();
    }

    @Override
    public boolean isValid() {
        return this.entity.m_6084_() && this.entity.valid && this.entity.isChunkLoaded() && this.isInWorld();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isPersistent() {
        return this.entity.persist;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : ((net.minecraft.world.entity.Entity)this.getHandle().f_19823_.get(0)).getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().m_20329_(this.getHandle());
        }
        return false;
    }

    @Override
    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.getHandle().f_19823_, input -> input.getBukkitEntity()));
    }

    @Override
    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().m_7998_(this.getHandle(), true);
    }

    @Override
    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().m_8127_();
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !this.getHandle().m_20160_();
    }

    @Override
    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().m_20153_();
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().f_19789_;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().f_19789_ = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().m_20148_();
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().f_19797_;
    }

    @Override
    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().f_19797_ = value;
    }

    public net.minecraft.world.entity.Entity getHandle() {
        return this.entity;
    }

    @Override
    public final EntityType getType() {
        return this.entityType;
    }

    @Override
    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().m_9236_().m_7605_(this.getHandle(), type.getData());
        }
    }

    @Override
    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound0());
    }

    @Override
    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound0());
    }

    @Override
    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound0());
    }

    public void setHandle(net.minecraft.world.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().m_20159_();
    }

    @Override
    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().m_8127_();
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().m_20202_().getBukkitEntity();
    }

    @Override
    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().m_6593_(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    public String getCustomName() {
        Component name = this.getHandle().m_7770_();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.getHandle().m_20340_(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.getHandle().m_20151_();
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (org.bukkit.entity.Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (org.bukkit.entity.Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    @Override
    public Set<org.bukkit.entity.Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.m_7726_().f_8325_.f_140150_.get(this.getEntityId());
        if (entityTracker != null) {
            for (ServerPlayerConnection connection : entityTracker.f_140475_) {
                players.add((Object)connection.m_142253_().getBukkitEntity());
            }
        }
        return players.build();
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendMessage(String ... messages) {
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    @Override
    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().m_7755_());
    }

    @Override
    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    @Override
    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    @Override
    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    @Override
    public void setGlowing(boolean flag) {
        this.getHandle().m_146915_(flag);
    }

    @Override
    public boolean isGlowing() {
        return this.getHandle().m_142038_();
    }

    @Override
    public void setInvulnerable(boolean flag) {
        this.getHandle().m_20331_(flag);
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().m_6673_(this.getHandle().m_269291_().m_269264_());
    }

    @Override
    public boolean isSilent() {
        return this.getHandle().m_20067_();
    }

    @Override
    public void setSilent(boolean flag) {
        this.getHandle().m_20225_(flag);
    }

    @Override
    public boolean hasGravity() {
        return !this.getHandle().m_20068_();
    }

    @Override
    public void setGravity(boolean gravity) {
        this.getHandle().m_20242_(!gravity);
    }

    @Override
    public int getPortalCooldown() {
        return this.getHandle().f_19839_;
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        this.getHandle().f_19839_ = cooldown;
    }

    @Override
    public Set<String> getScoreboardTags() {
        return this.getHandle().m_19880_();
    }

    @Override
    public boolean addScoreboardTag(String tag) {
        return this.getHandle().m_20049_(tag);
    }

    @Override
    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().m_20137_(tag);
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getHandle().m_7752_().ordinal());
    }

    @Override
    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().m_6374_());
    }

    @Override
    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public Pose getPose() {
        return Pose.values()[this.getHandle().m_20089_().ordinal()];
    }

    @Override
    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().m_6095_().m_20674_());
    }

    @Override
    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    @Override
    public Entity copy() {
        net.minecraft.world.entity.Entity copy = this.copy(this.getHandle().m_9236_());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    @Override
    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity copy = this.copy((Level)((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.m_6034_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity(copy.getBukkitEntity());
    }

    private net.minecraft.world.entity.Entity copy(Level level) {
        CompoundTag compoundTag = new CompoundTag();
        this.getHandle().saveAsPassenger(compoundTag, false);
        return net.minecraft.world.entity.EntityType.m_20645_((CompoundTag)compoundTag, (Level)level, Function.identity());
    }

    public void storeBukkitValues(CompoundTag c) {
        if (!this.persistentDataContainer.isEmpty()) {
            c.m_128365_("BukkitValues", (Tag)this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(CompoundTag c) {
        Tag base = c.m_128423_("BukkitValues");
        if (base instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)base);
        }
    }

    protected CompoundTag save() {
        CompoundTag nbttagcompound = new CompoundTag();
        nbttagcompound.m_128359_("id", this.getHandle().m_20078_());
        this.getHandle().m_20240_(nbttagcompound);
        return nbttagcompound;
    }

    protected void update() {
        if (!this.getHandle().m_6084_()) {
            return;
        }
        ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
        ChunkMap.TrackedEntity entityTracker = (ChunkMap.TrackedEntity)world.m_7726_().f_8325_.f_140150_.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.m_140489_(this.getHandle().m_5654_());
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                @Override
                public boolean isOp() {
                    return false;
                }

                @Override
                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }
}

