/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCow;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftCow
implements org.bukkit.entity.MushroomCow {
    public CraftMushroomCow(CraftServer server, MushroomCow entity) {
        super(server, (Cow)entity);
    }

    @Override
    public boolean hasEffectsForNextStew() {
        return this.getHandle().f_290954_ != null && !this.getHandle().f_290954_.isEmpty();
    }

    @Override
    public List<PotionEffect> getEffectsForNextStew() {
        if (this.hasEffectsForNextStew()) {
            return this.getHandle().f_290954_.stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.m_295282_())).toList();
        }
        return ImmutableList.of();
    }

    @Override
    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        MobEffectInstance minecraftPotionEffect = CraftPotionUtil.fromBukkit(potionEffect);
        if (!overwrite && this.hasEffectForNextStew(potionEffect.getType())) {
            return false;
        }
        if (this.getHandle().f_290954_ == null) {
            this.getHandle().f_290954_ = new ArrayList();
        }
        SuspiciousEffectHolder.EffectEntry recordSuspiciousEffect = new SuspiciousEffectHolder.EffectEntry(minecraftPotionEffect.m_19544_(), minecraftPotionEffect.m_19557_());
        this.removeEffectFromNextStew(potionEffect.getType());
        return this.getHandle().f_290954_.add(recordSuspiciousEffect);
    }

    @Override
    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectsForNextStew()) {
            return false;
        }
        MobEffect minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraft(potionEffectType);
        return this.getHandle().f_290954_.removeIf(recordSuspiciousEffect -> recordSuspiciousEffect.f_291780_().equals(minecraftPotionEffectType));
    }

    @Override
    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectsForNextStew()) {
            return false;
        }
        MobEffect minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraft(potionEffectType);
        return this.getHandle().f_290954_.stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.f_291780_().equals(minecraftPotionEffectType));
    }

    @Override
    public void clearEffectsForNextStew() {
        this.getHandle().f_290954_ = null;
    }

    public MushroomCow getHandle() {
        return (MushroomCow)this.entity;
    }

    @Override
    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().m_28554_().ordinal()];
    }

    @Override
    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().m_28464_(MushroomCow.MushroomType.values()[variant.ordinal()]);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

