/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Locale;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionEffectType
implements Keyed,
Translatable {
    private static final BiMap<Integer, PotionEffectType> ID_MAP = HashBiMap.create();
    public static final PotionEffectType SPEED = PotionEffectType.getPotionEffectType(1, "speed");
    public static final PotionEffectType SLOW = PotionEffectType.getPotionEffectType(2, "slowness");
    public static final PotionEffectType FAST_DIGGING = PotionEffectType.getPotionEffectType(3, "haste");
    public static final PotionEffectType SLOW_DIGGING = PotionEffectType.getPotionEffectType(4, "mining_fatigue");
    public static final PotionEffectType INCREASE_DAMAGE = PotionEffectType.getPotionEffectType(5, "strength");
    public static final PotionEffectType HEAL = PotionEffectType.getPotionEffectType(6, "instant_health");
    public static final PotionEffectType HARM = PotionEffectType.getPotionEffectType(7, "instant_damage");
    public static final PotionEffectType JUMP = PotionEffectType.getPotionEffectType(8, "jump_boost");
    public static final PotionEffectType CONFUSION = PotionEffectType.getPotionEffectType(9, "nausea");
    public static final PotionEffectType REGENERATION = PotionEffectType.getPotionEffectType(10, "regeneration");
    public static final PotionEffectType DAMAGE_RESISTANCE = PotionEffectType.getPotionEffectType(11, "resistance");
    public static final PotionEffectType FIRE_RESISTANCE = PotionEffectType.getPotionEffectType(12, "fire_resistance");
    public static final PotionEffectType WATER_BREATHING = PotionEffectType.getPotionEffectType(13, "water_breathing");
    public static final PotionEffectType INVISIBILITY = PotionEffectType.getPotionEffectType(14, "invisibility");
    public static final PotionEffectType BLINDNESS = PotionEffectType.getPotionEffectType(15, "blindness");
    public static final PotionEffectType NIGHT_VISION = PotionEffectType.getPotionEffectType(16, "night_vision");
    public static final PotionEffectType HUNGER = PotionEffectType.getPotionEffectType(17, "hunger");
    public static final PotionEffectType WEAKNESS = PotionEffectType.getPotionEffectType(18, "weakness");
    public static final PotionEffectType POISON = PotionEffectType.getPotionEffectType(19, "poison");
    public static final PotionEffectType WITHER = PotionEffectType.getPotionEffectType(20, "wither");
    public static final PotionEffectType HEALTH_BOOST = PotionEffectType.getPotionEffectType(21, "health_boost");
    public static final PotionEffectType ABSORPTION = PotionEffectType.getPotionEffectType(22, "absorption");
    public static final PotionEffectType SATURATION = PotionEffectType.getPotionEffectType(23, "saturation");
    public static final PotionEffectType GLOWING = PotionEffectType.getPotionEffectType(24, "glowing");
    public static final PotionEffectType LEVITATION = PotionEffectType.getPotionEffectType(25, "levitation");
    public static final PotionEffectType LUCK = PotionEffectType.getPotionEffectType(26, "luck");
    public static final PotionEffectType UNLUCK = PotionEffectType.getPotionEffectType(27, "unluck");
    public static final PotionEffectType SLOW_FALLING = PotionEffectType.getPotionEffectType(28, "slow_falling");
    public static final PotionEffectType CONDUIT_POWER = PotionEffectType.getPotionEffectType(29, "conduit_power");
    public static final PotionEffectType DOLPHINS_GRACE = PotionEffectType.getPotionEffectType(30, "dolphins_grace");
    public static final PotionEffectType BAD_OMEN = PotionEffectType.getPotionEffectType(31, "bad_omen");
    public static final PotionEffectType HERO_OF_THE_VILLAGE = PotionEffectType.getPotionEffectType(32, "hero_of_the_village");
    public static final PotionEffectType DARKNESS = PotionEffectType.getPotionEffectType(33, "darkness");

    @NotNull
    private static PotionEffectType getPotionEffectType(int typeId, @NotNull String key) {
        NamespacedKey namespacedKey = NamespacedKey.minecraft(key);
        PotionEffectType potionEffectType = Registry.EFFECT.get(namespacedKey);
        Preconditions.checkNotNull((Object)potionEffectType, (String)"No PotionEffectType found for %s. This is a bug.", (Object)namespacedKey);
        if (typeId > 0) {
            ID_MAP.put((Object)typeId, (Object)potionEffectType);
        }
        return potionEffectType;
    }

    @NotNull
    public abstract PotionEffect createEffect(int var1, int var2);

    public abstract boolean isInstant();

    @NotNull
    public abstract Color getColor();

    @Deprecated
    public abstract double getDurationModifier();

    @Deprecated
    public abstract int getId();

    @Deprecated
    @NotNull
    public abstract String getName();

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PotionEffectType getByKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return null;
        }
        return Registry.EFFECT.get(key);
    }

    @Deprecated
    @Nullable
    public static PotionEffectType getById(int id) {
        PotionEffectType type = (PotionEffectType)ID_MAP.get((Object)id);
        if (type != null) {
            return type;
        }
        for (PotionEffectType other : Registry.EFFECT) {
            if (other.getId() != id) continue;
            ID_MAP.put((Object)id, (Object)other);
            return other;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static PotionEffectType getByName(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        name = PotionEffectType.convertLegacy(name);
        return Registry.EFFECT.get(NamespacedKey.fromString(name.toLowerCase(Locale.ENGLISH)));
    }

    @Deprecated
    @NotNull
    public static PotionEffectType[] values() {
        return Lists.newArrayList(Registry.EFFECT).toArray(new PotionEffectType[0]);
    }

    private static String convertLegacy(String from) {
        if (from == null) {
            return null;
        }
        switch (from.toLowerCase()) {
            case "slow": {
                return "slowness";
            }
            case "fast_digging": {
                return "haste";
            }
            case "slow_digging": {
                return "mining_fatigue";
            }
            case "increase_damage": {
                return "strength";
            }
            case "heal": {
                return "instant_health";
            }
            case "harm": {
                return "instant_damage";
            }
            case "jump": {
                return "jump_boost";
            }
            case "confusion": {
                return "nausea";
            }
            case "damage_resistance": {
                return "resistance";
            }
        }
        return from;
    }
}

