/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class TimeArgument
implements ArgumentType<Integer> {
    private static final Collection<String> f_113031_ = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType f_113032_ = new SimpleCommandExceptionType((Message)Component.m_237115_("argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType f_263648_ = new Dynamic2CommandExceptionType((p_308389_, p_308390_) -> Component.m_307043_("argument.time.tick_count_too_low", p_308390_, p_308389_));
    private static final Object2IntMap<String> f_113034_ = new Object2IntOpenHashMap();
    final int f_263655_;

    private TimeArgument(int p_265107_) {
        this.f_263655_ = p_265107_;
    }

    public static TimeArgument m_113037_() {
        return new TimeArgument(0);
    }

    public static TimeArgument m_264474_(int p_265722_) {
        return new TimeArgument(p_265722_);
    }

    public Integer parse(StringReader p_113039_) throws CommandSyntaxException {
        float $$1 = p_113039_.readFloat();
        String $$2 = p_113039_.readUnquotedString();
        int $$3 = f_113034_.getOrDefault((Object)$$2, 0);
        if ($$3 == 0) {
            throw f_113032_.create();
        }
        int $$4 = Math.round($$1 * (float)$$3);
        if ($$4 < this.f_263655_) {
            throw f_263648_.create((Object)$$4, (Object)this.f_263655_);
        }
        return $$4;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_113044_, SuggestionsBuilder p_113045_) {
        StringReader $$2 = new StringReader(p_113045_.getRemaining());
        try {
            $$2.readFloat();
        }
        catch (CommandSyntaxException $$3) {
            return p_113045_.buildFuture();
        }
        return SharedSuggestionProvider.m_82970_((Iterable<String>)f_113034_.keySet(), p_113045_.createOffset(p_113045_.getStart() + $$2.getCursor()));
    }

    public Collection<String> getExamples() {
        return f_113031_;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static {
        f_113034_.put((Object)"d", 24000);
        f_113034_.put((Object)"s", 20);
        f_113034_.put((Object)"t", 1);
        f_113034_.put((Object)"", 1);
    }

    public static class Info
    implements ArgumentTypeInfo<TimeArgument, Template> {
        @Override
        public void m_214155_(Template p_265434_, FriendlyByteBuf p_265320_) {
            p_265320_.writeInt(p_265434_.f_263698_);
        }

        @Override
        public Template m_213618_(FriendlyByteBuf p_265324_) {
            int $$1 = p_265324_.readInt();
            return new Template($$1);
        }

        @Override
        public void m_213719_(Template p_265110_, JsonObject p_265629_) {
            p_265629_.addProperty("min", (Number)p_265110_.f_263698_);
        }

        @Override
        public Template m_214163_(TimeArgument p_265544_) {
            return new Template(p_265544_.f_263655_);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template m_213618_(FriendlyByteBuf friendlyByteBuf) {
            return this.m_213618_(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TimeArgument> {
            final int f_263698_;

            Template(int p_265096_) {
                this.f_263698_ = p_265096_;
            }

            @Override
            public TimeArgument m_213879_(CommandBuildContext p_265466_) {
                return TimeArgument.m_264474_(this.f_263698_);
            }

            @Override
            public ArgumentTypeInfo<TimeArgument, ?> m_213709_() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType m_213879_(CommandBuildContext commandBuildContext) {
                return this.m_213879_(commandBuildContext);
            }
        }
    }
}

