/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger f_124431_ = LogUtils.getLogger();
    private final PackOutput.PathProvider f_236267_;
    private final Set<ResourceLocation> f_243940_;
    private final List<SubProviderEntry> f_124434_;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceLocation> p_254481_, List<SubProviderEntry> p_253798_) {
        this.f_236267_ = p_254123_.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.f_124434_ = p_253798_;
        this.f_243940_ = p_254481_;
    }

    @Override
    public CompletableFuture<?> m_213708_(CachedOutput p_254060_) {
        final HashMap $$1 = Maps.newHashMap();
        Object2ObjectOpenHashMap $$2 = new Object2ObjectOpenHashMap();
        this.f_124434_.forEach(arg_0 -> LootTableProvider.m_287805_((Map)$$2, $$1, arg_0));
        ProblemReporter.Collector $$3 = new ProblemReporter.Collector();
        ValidationContext $$4 = new ValidationContext($$3, LootContextParamSets.f_81420_, new LootDataResolver(){

            @Override
            @Nullable
            public <T> T m_278667_(LootDataId<T> p_279283_) {
                if (p_279283_.f_278383_() == LootDataType.f_278413_) {
                    return (T)$$1.get(p_279283_.f_278500_());
                }
                return null;
            }
        });
        Sets.SetView $$5 = Sets.difference(this.f_243940_, $$1.keySet());
        for (ResourceLocation $$6 : $$5) {
            $$3.m_305802_("Missing built-in table: " + $$6);
        }
        $$1.forEach((p_278897_, p_278898_) -> p_278898_.m_79136_($$4.m_79355_(p_278898_.m_79122_()).m_278632_("{" + p_278897_ + "}", new LootDataId<LootTable>(LootDataType.f_278413_, (ResourceLocation)p_278897_))));
        Multimap<String, String> $$7 = $$3.m_306090_();
        if (!$$7.isEmpty()) {
            $$7.forEach((p_124446_, p_124447_) -> f_124431_.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])$$1.entrySet().stream().map(p_296354_ -> {
            ResourceLocation $$2 = (ResourceLocation)p_296354_.getKey();
            LootTable $$3 = (LootTable)p_296354_.getValue();
            Path $$4 = this.f_236267_.m_245731_($$2);
            return DataProvider.m_293028_(p_254060_, LootTable.f_290440_, $$3, $$4);
        }).toArray(CompletableFuture[]::new));
    }

    @Override
    public final String m_6055_() {
        return "Loot Tables";
    }

    private static /* synthetic */ void m_287805_(Map p_288261_, Map p_288262_, SubProviderEntry p_288263_) {
        p_288263_.f_243941_().get().m_245126_((p_288259_, p_288260_) -> {
            ResourceLocation $$5 = p_288261_.put(RandomSequence.m_288221_(p_288259_), p_288259_);
            if ($$5 != null) {
                Util.m_143785_("Loot table random sequence seed collision on " + $$5 + " and " + p_288259_);
            }
            p_288260_.m_287223_((ResourceLocation)p_288259_);
            if (p_288262_.put(p_288259_, p_288260_.m_79165_(p_288258_.f_244144_).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_288259_);
            }
        });
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> f_243941_, LootContextParamSet f_244144_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this);
        }

        @Override
        public final boolean equals(Object p_249337_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SubProviderEntry.class, "provider;paramSet", "f_243941_", "f_244144_"}, this, p_249337_);
        }
    }
}

