/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class StructureUtils {
    private static final Logger f_177742_ = LogUtils.getLogger();
    public static final String f_177741_ = "gameteststructures";
    public static String f_127833_ = "gameteststructures";

    public static Rotation m_127835_(int p_127836_) {
        switch (p_127836_) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + p_127836_);
    }

    public static int m_177751_(Rotation p_177752_) {
        switch (p_177752_) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + p_177752_);
    }

    public static AABB m_127847_(StructureBlockEntity p_127848_) {
        return AABB.m_82321_(StructureUtils.m_127904_(p_127848_));
    }

    public static BoundingBox m_127904_(StructureBlockEntity p_127905_) {
        BlockPos $$1 = StructureUtils.m_304927_(p_127905_);
        BlockPos $$2 = StructureUtils.m_305507_($$1, p_127905_.m_155805_(), p_127905_.m_59906_());
        return BoundingBox.m_162375_($$1, $$2);
    }

    public static BlockPos m_304927_(StructureBlockEntity p_311311_) {
        return p_311311_.m_58899_().m_121955_(p_311311_.m_59902_());
    }

    public static void m_127875_(BlockPos p_127876_, BlockPos p_127877_, Rotation p_127878_, ServerLevel p_127879_) {
        BlockPos $$4 = StructureTemplate.m_74593_(p_127876_.m_121955_(p_127877_), Mirror.NONE, p_127878_, p_127876_);
        p_127879_.m_46597_($$4, Blocks.f_50272_.m_49966_());
        CommandBlockEntity $$5 = (CommandBlockEntity)p_127879_.m_7702_($$4);
        $$5.m_59141_().m_6590_("test runthis");
        BlockPos $$6 = StructureTemplate.m_74593_($$4.m_7918_(0, 0, -1), Mirror.NONE, p_127878_, $$4);
        p_127879_.m_46597_($$6, Blocks.f_50124_.m_49966_().m_60717_(p_127878_));
    }

    public static void m_177764_(String p_177765_, BlockPos p_177766_, Vec3i p_177767_, Rotation p_177768_, ServerLevel p_177769_) {
        BoundingBox $$5 = StructureUtils.m_177760_(p_177766_.m_7494_(), p_177767_, p_177768_);
        StructureUtils.m_127849_($$5, p_177769_);
        p_177769_.m_46597_(p_177766_, Blocks.f_50677_.m_49966_());
        StructureBlockEntity $$6 = (StructureBlockEntity)p_177769_.m_7702_(p_177766_);
        $$6.m_59876_(false);
        $$6.m_59874_(new ResourceLocation(p_177765_));
        $$6.m_155797_(p_177767_);
        $$6.m_59860_(StructureMode.SAVE);
        $$6.m_59898_(true);
    }

    /*
     * WARNING - void declaration
     */
    public static StructureBlockEntity m_305479_(GameTestInfo p_311701_, BlockPos p_311042_, Rotation p_310584_, ServerLevel p_312330_) {
        void $$10;
        Vec3i $$4 = p_312330_.m_215082_().m_230407_(new ResourceLocation(p_311701_.m_127645_())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + p_311701_.m_127645_())).m_163801_();
        BoundingBox $$5 = StructureUtils.m_177760_(p_311042_, $$4, p_310584_);
        if (p_310584_ == Rotation.NONE) {
            BlockPos $$6 = p_311042_;
        } else if (p_310584_ == Rotation.CLOCKWISE_90) {
            BlockPos $$7 = p_311042_.m_7918_($$4.m_123343_() - 1, 0, 0);
        } else if (p_310584_ == Rotation.CLOCKWISE_180) {
            BlockPos $$8 = p_311042_.m_7918_($$4.m_123341_() - 1, 0, $$4.m_123343_() - 1);
        } else if (p_310584_ == Rotation.COUNTERCLOCKWISE_90) {
            BlockPos $$9 = p_311042_.m_7918_(0, 0, $$4.m_123341_() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + p_310584_);
        }
        StructureUtils.m_127857_($$5, p_312330_);
        StructureUtils.m_127849_($$5, p_312330_);
        return StructureUtils.m_127890_(p_311701_, $$10.m_7495_(), p_310584_, p_312330_);
    }

    private static void m_127857_(BoundingBox p_312219_, ServerLevel p_127859_) {
        p_312219_.m_306717_().forEach(p_308541_ -> p_127859_.m_8602_(p_308541_.f_45578_, p_308541_.f_45579_, true));
    }

    public static void m_127849_(BoundingBox p_127850_, ServerLevel p_127852_) {
        int $$2 = p_127850_.m_162396_() - 1;
        BoundingBox $$3 = new BoundingBox(p_127850_.m_162395_() - 2, p_127850_.m_162396_() - 3, p_127850_.m_162398_() - 3, p_127850_.m_162399_() + 3, p_127850_.m_162400_() + 20, p_127850_.m_162401_() + 3);
        BlockPos.m_121919_($$3).forEach(p_177748_ -> StructureUtils.m_127841_($$2, p_177748_, p_127852_));
        ((LevelTicks)p_127852_.m_183326_()).m_193234_($$3);
        p_127852_.m_8722_($$3);
        AABB $$4 = new AABB($$3.m_162395_(), $$3.m_162396_(), $$3.m_162398_(), $$3.m_162399_(), $$3.m_162400_(), $$3.m_162401_());
        List<Entity> $$5 = p_127852_.m_6443_(Entity.class, $$4, p_177750_ -> !(p_177750_ instanceof Player));
        $$5.forEach(Entity::m_146870_);
    }

    public static BlockPos m_305507_(BlockPos p_310098_, Vec3i p_312132_, Rotation p_309587_) {
        BlockPos $$3 = p_310098_.m_121955_(p_312132_).m_7918_(-1, -1, -1);
        return StructureTemplate.m_74593_($$3, Mirror.NONE, p_309587_, p_310098_);
    }

    public static BoundingBox m_177760_(BlockPos p_177761_, Vec3i p_177762_, Rotation p_177763_) {
        BlockPos $$3 = StructureUtils.m_305507_(p_177761_, p_177762_, p_177763_);
        BoundingBox $$4 = BoundingBox.m_162375_(p_177761_, $$3);
        int $$5 = Math.min($$4.m_162395_(), $$4.m_162399_());
        int $$6 = Math.min($$4.m_162398_(), $$4.m_162401_());
        return $$4.m_162367_(p_177761_.m_123341_() - $$5, 0, p_177761_.m_123343_() - $$6);
    }

    public static Optional<BlockPos> m_127853_(BlockPos p_127854_, int p_127855_, ServerLevel p_127856_) {
        return StructureUtils.m_127910_(p_127854_, p_127855_, p_127856_).stream().filter(p_177756_ -> StructureUtils.m_127867_(p_177756_, p_127854_, p_127856_)).findFirst();
    }

    @Nullable
    public static BlockPos m_127906_(BlockPos p_127907_, int p_127908_, ServerLevel p_127909_) {
        Comparator<BlockPos> $$3 = Comparator.comparingInt(p_177759_ -> p_177759_.m_123333_(p_127907_));
        Collection<BlockPos> $$4 = StructureUtils.m_127910_(p_127907_, p_127908_, p_127909_);
        Optional<BlockPos> $$5 = $$4.stream().min($$3);
        return $$5.orElse(null);
    }

    public static Collection<BlockPos> m_127910_(BlockPos p_127911_, int p_127912_, ServerLevel p_127913_) {
        ArrayList $$3 = Lists.newArrayList();
        BoundingBox $$4 = new BoundingBox(p_127911_).m_191961_(p_127912_);
        BlockPos.m_121919_($$4).forEach(p_308539_ -> {
            if (p_127913_.m_8055_((BlockPos)p_308539_).m_60713_(Blocks.f_50677_)) {
                $$3.add(p_308539_.m_7949_());
            }
        });
        return $$3;
    }

    private static StructureBlockEntity m_127890_(GameTestInfo p_309598_, BlockPos p_127892_, Rotation p_127893_, ServerLevel p_127894_) {
        p_127894_.m_46597_(p_127892_, Blocks.f_50677_.m_49966_());
        StructureBlockEntity $$4 = (StructureBlockEntity)p_127894_.m_7702_(p_127892_);
        $$4.m_59860_(StructureMode.LOAD);
        $$4.m_59883_(p_127893_);
        $$4.m_59876_(false);
        $$4.m_59874_(new ResourceLocation(p_309598_.m_127645_()));
        $$4.m_59887_(p_309598_.m_127633_());
        if (!$$4.m_305135_(p_127894_)) {
            throw new RuntimeException("Failed to load structure info for test: " + p_309598_.m_127633_() + ". Structure name: " + p_309598_.m_127645_());
        }
        return $$4;
    }

    private static void m_127841_(int p_127842_, BlockPos p_127843_, ServerLevel p_127844_) {
        BlockState $$4;
        if (p_127843_.m_123342_() < p_127842_) {
            BlockState $$3 = Blocks.f_50069_.m_49966_();
        } else {
            $$4 = Blocks.f_50016_.m_49966_();
        }
        BlockInput $$5 = new BlockInput($$4, Collections.emptySet(), null);
        $$5.m_114670_(p_127844_, p_127843_, 2);
        p_127844_.m_6289_(p_127843_, $$4.m_60734_());
    }

    private static boolean m_127867_(BlockPos p_127868_, BlockPos p_127869_, ServerLevel p_127870_) {
        StructureBlockEntity $$3 = (StructureBlockEntity)p_127870_.m_7702_(p_127868_);
        return StructureUtils.m_127904_($$3).m_71051_(p_127869_);
    }
}

