/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps f_128958_ = new NbtOps();
    private static final String f_244338_ = "";

    protected NbtOps() {
    }

    public Tag empty() {
        return EndTag.f_128534_;
    }

    public <U> U convertTo(DynamicOps<U> p_128980_, Tag p_128981_) {
        switch (p_128981_.m_7060_()) {
            case 0: {
                return (U)p_128980_.empty();
            }
            case 1: {
                return (U)p_128980_.createByte(((NumericTag)p_128981_).m_7063_());
            }
            case 2: {
                return (U)p_128980_.createShort(((NumericTag)p_128981_).m_7053_());
            }
            case 3: {
                return (U)p_128980_.createInt(((NumericTag)p_128981_).m_7047_());
            }
            case 4: {
                return (U)p_128980_.createLong(((NumericTag)p_128981_).m_7046_());
            }
            case 5: {
                return (U)p_128980_.createFloat(((NumericTag)p_128981_).m_7057_());
            }
            case 6: {
                return (U)p_128980_.createDouble(((NumericTag)p_128981_).m_7061_());
            }
            case 7: {
                return (U)p_128980_.createByteList(ByteBuffer.wrap(((ByteArrayTag)p_128981_).m_128227_()));
            }
            case 8: {
                return (U)p_128980_.createString(p_128981_.m_7916_());
            }
            case 9: {
                return (U)this.convertList(p_128980_, p_128981_);
            }
            case 10: {
                return (U)this.convertMap(p_128980_, p_128981_);
            }
            case 11: {
                return (U)p_128980_.createIntList(Arrays.stream(((IntArrayTag)p_128981_).m_128648_()));
            }
            case 12: {
                return (U)p_128980_.createLongList(Arrays.stream(((LongArrayTag)p_128981_).m_128851_()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + p_128981_);
    }

    public DataResult<Number> getNumberValue(Tag p_129030_) {
        if (p_129030_ instanceof NumericTag) {
            NumericTag $$1 = (NumericTag)p_129030_;
            return DataResult.success((Object)$$1.m_8103_());
        }
        return DataResult.error(() -> "Not a number");
    }

    public Tag createNumeric(Number p_128983_) {
        return DoubleTag.m_128500_(p_128983_.doubleValue());
    }

    public Tag createByte(byte p_128963_) {
        return ByteTag.m_128266_(p_128963_);
    }

    public Tag createShort(short p_129048_) {
        return ShortTag.m_129258_(p_129048_);
    }

    public Tag createInt(int p_128976_) {
        return IntTag.m_128679_(p_128976_);
    }

    public Tag createLong(long p_128978_) {
        return LongTag.m_128882_(p_128978_);
    }

    public Tag createFloat(float p_128974_) {
        return FloatTag.m_128566_(p_128974_);
    }

    public Tag createDouble(double p_128972_) {
        return DoubleTag.m_128500_(p_128972_);
    }

    public Tag createBoolean(boolean p_129050_) {
        return ByteTag.m_128273_(p_129050_);
    }

    public DataResult<String> getStringValue(Tag p_129061_) {
        if (p_129061_ instanceof StringTag) {
            StringTag $$1 = (StringTag)p_129061_;
            return DataResult.success((Object)$$1.m_7916_());
        }
        return DataResult.error(() -> "Not a string");
    }

    public Tag createString(String p_128985_) {
        return StringTag.m_129297_(p_128985_);
    }

    public DataResult<Tag> mergeToList(Tag p_129041_, Tag p_129042_) {
        return NbtOps.m_246675_(p_129041_).map(p_248053_ -> DataResult.success((Object)p_248053_.m_246081_(p_129042_).m_245493_())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + p_129041_, (Object)p_129041_));
    }

    public DataResult<Tag> mergeToList(Tag p_129038_, List<Tag> p_129039_) {
        return NbtOps.m_246675_(p_129038_).map(p_248048_ -> DataResult.success((Object)p_248048_.m_246277_(p_129039_).m_245493_())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + p_129038_, (Object)p_129038_));
    }

    public DataResult<Tag> mergeToMap(Tag p_129044_, Tag p_129045_, Tag p_129046_) {
        if (!(p_129044_ instanceof CompoundTag) && !(p_129044_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + p_129044_, (Object)p_129044_);
        }
        if (!(p_129045_ instanceof StringTag)) {
            return DataResult.error(() -> "key is not a string: " + p_129045_, (Object)p_129044_);
        }
        CompoundTag $$3 = new CompoundTag();
        if (p_129044_ instanceof CompoundTag) {
            CompoundTag $$4 = (CompoundTag)p_129044_;
            $$4.m_128431_().forEach(p_129068_ -> $$3.m_128365_((String)p_129068_, $$4.m_128423_((String)p_129068_)));
        }
        $$3.m_128365_(p_129045_.m_7916_(), p_129046_);
        return DataResult.success((Object)$$3);
    }

    public DataResult<Tag> mergeToMap(Tag p_129032_, MapLike<Tag> p_129033_) {
        if (!(p_129032_ instanceof CompoundTag) && !(p_129032_ instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + p_129032_, (Object)p_129032_);
        }
        CompoundTag $$2 = new CompoundTag();
        if (p_129032_ instanceof CompoundTag) {
            CompoundTag $$3 = (CompoundTag)p_129032_;
            $$3.m_128431_().forEach(p_129059_ -> $$2.m_128365_((String)p_129059_, $$3.m_128423_((String)p_129059_)));
        }
        ArrayList $$4 = Lists.newArrayList();
        p_129033_.entries().forEach(p_128994_ -> {
            Tag $$3 = (Tag)p_128994_.getFirst();
            if (!($$3 instanceof StringTag)) {
                $$4.add($$3);
                return;
            }
            $$2.m_128365_($$3.m_7916_(), (Tag)p_128994_.getSecond());
        });
        if (!$$4.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + $$4, (Object)$$2);
        }
        return DataResult.success((Object)$$2);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag p_129070_) {
        if (p_129070_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129070_;
            return DataResult.success($$1.m_128431_().stream().map(p_129021_ -> Pair.of((Object)this.createString((String)p_129021_), (Object)$$1.m_128423_((String)p_129021_))));
        }
        return DataResult.error(() -> "Not a map: " + p_129070_);
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag p_129103_) {
        if (p_129103_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_129103_;
            return DataResult.success(p_129024_ -> $$1.m_128431_().forEach(p_178006_ -> p_129024_.accept(this.createString((String)p_178006_), $$1.m_128423_((String)p_178006_))));
        }
        return DataResult.error(() -> "Not a map: " + p_129103_);
    }

    public DataResult<MapLike<Tag>> getMap(Tag p_129105_) {
        if (p_129105_ instanceof CompoundTag) {
            final CompoundTag $$1 = (CompoundTag)p_129105_;
            return DataResult.success((Object)new MapLike<Tag>(){

                @Nullable
                public Tag get(Tag p_129174_) {
                    return $$1.m_128423_(p_129174_.m_7916_());
                }

                @Nullable
                public Tag get(String p_129169_) {
                    return $$1.m_128423_(p_129169_);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return $$1.m_128431_().stream().map(p_129172_ -> Pair.of((Object)NbtOps.this.createString((String)p_129172_), (Object)$$1.m_128423_((String)p_129172_)));
                }

                public String toString() {
                    return "MapLike[" + $$1 + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((Tag)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + p_129105_);
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> p_129004_) {
        CompoundTag $$1 = new CompoundTag();
        p_129004_.forEach(p_129018_ -> $$1.m_128365_(((Tag)p_129018_.getFirst()).m_7916_(), (Tag)p_129018_.getSecond()));
        return $$1;
    }

    private static Tag m_246295_(CompoundTag p_251041_) {
        Tag $$1;
        if (p_251041_.m_128440_() == 1 && ($$1 = p_251041_.m_128423_(f_244338_)) != null) {
            return $$1;
        }
        return p_251041_;
    }

    public DataResult<Stream<Tag>> getStream(Tag p_129108_) {
        if (p_129108_ instanceof ListTag) {
            ListTag $$1 = (ListTag)p_129108_;
            if ($$1.m_7264_() == 10) {
                return DataResult.success($$1.stream().map(p_248049_ -> NbtOps.m_246295_((CompoundTag)p_248049_)));
            }
            return DataResult.success($$1.stream());
        }
        if (p_129108_ instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)p_129108_;
            return DataResult.success($$2.stream().map(p_129158_ -> p_129158_));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag p_129110_) {
        if (p_129110_ instanceof ListTag) {
            ListTag $$1 = (ListTag)p_129110_;
            if ($$1.m_7264_() == 10) {
                return DataResult.success(p_248055_ -> $$1.forEach(p_248051_ -> p_248055_.accept(NbtOps.m_246295_((CompoundTag)p_248051_))));
            }
            return DataResult.success($$1::forEach);
        }
        if (p_129110_ instanceof CollectionTag) {
            CollectionTag $$2 = (CollectionTag)p_129110_;
            return DataResult.success($$2::forEach);
        }
        return DataResult.error(() -> "Not a list: " + p_129110_);
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag p_129132_) {
        if (p_129132_ instanceof ByteArrayTag) {
            ByteArrayTag $$1 = (ByteArrayTag)p_129132_;
            return DataResult.success((Object)ByteBuffer.wrap($$1.m_128227_()));
        }
        return super.getByteBuffer((Object)p_129132_);
    }

    public Tag createByteList(ByteBuffer p_128990_) {
        ByteBuffer $$1 = p_128990_.duplicate().clear();
        byte[] $$2 = new byte[p_128990_.capacity()];
        $$1.get(0, $$2, 0, $$2.length);
        return new ByteArrayTag($$2);
    }

    public DataResult<IntStream> getIntStream(Tag p_129134_) {
        if (p_129134_ instanceof IntArrayTag) {
            IntArrayTag $$1 = (IntArrayTag)p_129134_;
            return DataResult.success((Object)Arrays.stream($$1.m_128648_()));
        }
        return super.getIntStream((Object)p_129134_);
    }

    public Tag createIntList(IntStream p_129000_) {
        return new IntArrayTag(p_129000_.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag p_129136_) {
        if (p_129136_ instanceof LongArrayTag) {
            LongArrayTag $$1 = (LongArrayTag)p_129136_;
            return DataResult.success((Object)Arrays.stream($$1.m_128851_()));
        }
        return super.getLongStream((Object)p_129136_);
    }

    public Tag createLongList(LongStream p_129002_) {
        return new LongArrayTag(p_129002_.toArray());
    }

    public Tag createList(Stream<Tag> p_129052_) {
        return InitialListCollector.f_243778_.m_246922_(p_129052_).m_245493_();
    }

    public Tag remove(Tag p_129035_, String p_129036_) {
        if (p_129035_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_129035_;
            CompoundTag $$3 = new CompoundTag();
            $$2.m_128431_().stream().filter(p_128988_ -> !Objects.equals(p_128988_, p_129036_)).forEach(p_129028_ -> $$3.m_128365_((String)p_129028_, $$2.m_128423_((String)p_129028_)));
            return $$3;
        }
        return p_129035_;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder();
    }

    private static Optional<ListCollector> m_246675_(Tag p_249503_) {
        if (p_249503_ instanceof EndTag) {
            return Optional.of(InitialListCollector.f_243778_);
        }
        if (p_249503_ instanceof CollectionTag) {
            CollectionTag $$1 = (CollectionTag)p_249503_;
            if ($$1.isEmpty()) {
                return Optional.of(InitialListCollector.f_243778_);
            }
            if ($$1 instanceof ListTag) {
                ListTag $$2 = (ListTag)$$1;
                return switch ($$2.m_7264_()) {
                    case 0 -> Optional.of(InitialListCollector.f_243778_);
                    case 10 -> Optional.of(new HeterogenousListCollector($$2));
                    default -> Optional.of(new HomogenousListCollector($$2));
                };
            }
            if ($$1 instanceof ByteArrayTag) {
                ByteArrayTag $$3 = (ByteArrayTag)$$1;
                return Optional.of(new ByteListCollector($$3.m_128227_()));
            }
            if ($$1 instanceof IntArrayTag) {
                IntArrayTag $$4 = (IntArrayTag)$$1;
                return Optional.of(new IntListCollector($$4.m_128648_()));
            }
            if ($$1 instanceof LongArrayTag) {
                LongArrayTag $$5 = (LongArrayTag)$$1;
                return Optional.of(new LongListCollector($$5.m_128851_()));
            }
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((Tag)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((Tag)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((Tag)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((Tag)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((Tag)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((Tag)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((Tag)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((Tag)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((Tag)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((Tag)object, (MapLike<Tag>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((Tag)object, (Tag)object2, (Tag)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((Tag)object, (List<Tag>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((Tag)object, (Tag)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((Tag)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((Tag)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (Tag)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    static class InitialListCollector
    implements ListCollector {
        public static final InitialListCollector f_243778_ = new InitialListCollector();

        private InitialListCollector() {
        }

        @Override
        public ListCollector m_246081_(Tag p_251635_) {
            if (p_251635_ instanceof CompoundTag) {
                CompoundTag $$1 = (CompoundTag)p_251635_;
                return new HeterogenousListCollector().m_246081_($$1);
            }
            if (p_251635_ instanceof ByteTag) {
                ByteTag $$2 = (ByteTag)p_251635_;
                return new ByteListCollector($$2.m_7063_());
            }
            if (p_251635_ instanceof IntTag) {
                IntTag $$3 = (IntTag)p_251635_;
                return new IntListCollector($$3.m_7047_());
            }
            if (p_251635_ instanceof LongTag) {
                LongTag $$4 = (LongTag)p_251635_;
                return new LongListCollector($$4.m_7046_());
            }
            return new HomogenousListCollector(p_251635_);
        }

        @Override
        public Tag m_245493_() {
            return new ListTag();
        }
    }

    static interface ListCollector {
        public ListCollector m_246081_(Tag var1);

        default public ListCollector m_246277_(Iterable<Tag> p_249781_) {
            ListCollector $$1 = this;
            for (Tag $$2 : p_249781_) {
                $$1 = $$1.m_246081_($$2);
            }
            return $$1;
        }

        default public ListCollector m_246922_(Stream<Tag> p_249876_) {
            return this.m_246277_(p_249876_::iterator);
        }

        public Tag m_245493_();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder() {
            super((DynamicOps)NbtOps.this);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String p_129186_, Tag p_129187_, CompoundTag p_129188_) {
            p_129188_.m_128365_(p_129186_, p_129187_);
            return p_129188_;
        }

        protected DataResult<Tag> build(CompoundTag p_129190_, Tag p_129191_) {
            if (p_129191_ == null || p_129191_ == EndTag.f_128534_) {
                return DataResult.success((Object)p_129190_);
            }
            if (p_129191_ instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)p_129191_;
                CompoundTag $$3 = new CompoundTag(Maps.newHashMap($$2.m_128450_()));
                for (Map.Entry<String, Tag> $$4 : p_129190_.m_128450_().entrySet()) {
                    $$3.m_128365_($$4.getKey(), $$4.getValue());
                }
                return DataResult.success((Object)$$3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + p_129191_, (Object)p_129191_);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (Tag)object, (CompoundTag)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundTag)object, (Tag)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class HeterogenousListCollector
    implements ListCollector {
        private final ListTag f_244100_ = new ListTag();

        public HeterogenousListCollector() {
        }

        public HeterogenousListCollector(Collection<Tag> p_249606_) {
            this.f_244100_.addAll(p_249606_);
        }

        public HeterogenousListCollector(IntArrayList p_250270_) {
            p_250270_.forEach(p_249166_ -> this.f_244100_.add(HeterogenousListCollector.m_247310_(IntTag.m_128679_(p_249166_))));
        }

        public HeterogenousListCollector(ByteArrayList p_248575_) {
            p_248575_.forEach(p_249160_ -> this.f_244100_.add(HeterogenousListCollector.m_247310_(ByteTag.m_128266_(p_249160_))));
        }

        public HeterogenousListCollector(LongArrayList p_249410_) {
            p_249410_.forEach(p_249754_ -> this.f_244100_.add(HeterogenousListCollector.m_247310_(LongTag.m_128882_(p_249754_))));
        }

        private static boolean m_246400_(CompoundTag p_252073_) {
            return p_252073_.m_128440_() == 1 && p_252073_.m_128441_(NbtOps.f_244338_);
        }

        private static Tag m_247665_(Tag p_252042_) {
            CompoundTag $$1;
            if (p_252042_ instanceof CompoundTag && !HeterogenousListCollector.m_246400_($$1 = (CompoundTag)p_252042_)) {
                return $$1;
            }
            return HeterogenousListCollector.m_247310_(p_252042_);
        }

        private static CompoundTag m_247310_(Tag p_251263_) {
            CompoundTag $$1 = new CompoundTag();
            $$1.m_128365_(NbtOps.f_244338_, p_251263_);
            return $$1;
        }

        @Override
        public ListCollector m_246081_(Tag p_249045_) {
            this.f_244100_.add(HeterogenousListCollector.m_247665_(p_249045_));
            return this;
        }

        @Override
        public Tag m_245493_() {
            return this.f_244100_;
        }
    }

    static class HomogenousListCollector
    implements ListCollector {
        private final ListTag f_244352_ = new ListTag();

        HomogenousListCollector(Tag p_249247_) {
            this.f_244352_.add(p_249247_);
        }

        HomogenousListCollector(ListTag p_249889_) {
            this.f_244352_.addAll(p_249889_);
        }

        @Override
        public ListCollector m_246081_(Tag p_248727_) {
            if (p_248727_.m_7060_() != this.f_244352_.m_7264_()) {
                return new HeterogenousListCollector().m_246277_(this.f_244352_).m_246081_(p_248727_);
            }
            this.f_244352_.add(p_248727_);
            return this;
        }

        @Override
        public Tag m_245493_() {
            return this.f_244352_;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList f_243771_ = new ByteArrayList();

        public ByteListCollector(byte p_249905_) {
            this.f_243771_.add(p_249905_);
        }

        public ByteListCollector(byte[] p_250457_) {
            this.f_243771_.addElements(0, p_250457_);
        }

        @Override
        public ListCollector m_246081_(Tag p_250723_) {
            if (p_250723_ instanceof ByteTag) {
                ByteTag $$1 = (ByteTag)p_250723_;
                this.f_243771_.add($$1.m_7063_());
                return this;
            }
            return new HeterogenousListCollector(this.f_243771_).m_246081_(p_250723_);
        }

        @Override
        public Tag m_245493_() {
            return new ByteArrayTag(this.f_243771_.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList f_244530_ = new IntArrayList();

        public IntListCollector(int p_250274_) {
            this.f_244530_.add(p_250274_);
        }

        public IntListCollector(int[] p_249489_) {
            this.f_244530_.addElements(0, p_249489_);
        }

        @Override
        public ListCollector m_246081_(Tag p_251372_) {
            if (p_251372_ instanceof IntTag) {
                IntTag $$1 = (IntTag)p_251372_;
                this.f_244530_.add($$1.m_7047_());
                return this;
            }
            return new HeterogenousListCollector(this.f_244530_).m_246081_(p_251372_);
        }

        @Override
        public Tag m_245493_() {
            return new IntArrayTag(this.f_244530_.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList f_244231_ = new LongArrayList();

        public LongListCollector(long p_249842_) {
            this.f_244231_.add(p_249842_);
        }

        public LongListCollector(long[] p_251409_) {
            this.f_244231_.addElements(0, p_251409_);
        }

        @Override
        public ListCollector m_246081_(Tag p_252167_) {
            if (p_252167_ instanceof LongTag) {
                LongTag $$1 = (LongTag)p_252167_;
                this.f_244231_.add($$1.m_7046_());
                return this;
            }
            return new HeterogenousListCollector(this.f_244231_).m_246081_(p_252167_);
        }

        @Override
        public Tag m_245493_() {
            return new LongArrayTag(this.f_244231_.toLongArray());
        }
    }
}

