/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ChunkPos;

public interface Component
extends Message,
FormattedText {
    public Style m_7383_();

    public ComponentContents m_214077_();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String m_130668_(int p_130669_) {
        StringBuilder $$1 = new StringBuilder();
        this.m_5651_(p_130673_ -> {
            int $$3 = p_130669_ - $$1.length();
            if ($$3 <= 0) {
                return f_130759_;
            }
            $$1.append(p_130673_.length() <= $$3 ? p_130673_ : p_130673_.substring(0, $$3));
            return Optional.empty();
        });
        return $$1.toString();
    }

    public List<Component> m_7360_();

    @Nullable
    default public String m_306448_() {
        ComponentContents componentContents = this.m_214077_();
        if (componentContents instanceof PlainTextContents) {
            PlainTextContents $$0 = (PlainTextContents)componentContents;
            if (this.m_7360_().isEmpty() && this.m_7383_().m_131179_()) {
                return $$0.m_305315_();
            }
        }
        return null;
    }

    default public MutableComponent m_6879_() {
        return MutableComponent.m_237204_(this.m_214077_());
    }

    default public MutableComponent m_6881_() {
        return new MutableComponent(this.m_214077_(), new ArrayList<Component>(this.m_7360_()), this.m_7383_());
    }

    public FormattedCharSequence m_7532_();

    @Override
    default public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> p_130679_, Style p_130680_) {
        Style $$2 = this.m_7383_().m_131146_(p_130680_);
        Optional<T> $$3 = this.m_214077_().m_213724_(p_130679_, $$2);
        if ($$3.isPresent()) {
            return $$3;
        }
        for (Component $$4 : this.m_7360_()) {
            Optional<T> $$5 = $$4.m_7451_(p_130679_, $$2);
            if (!$$5.isPresent()) continue;
            return $$5;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> p_130677_) {
        Optional<T> $$1 = this.m_214077_().m_213874_(p_130677_);
        if ($$1.isPresent()) {
            return $$1;
        }
        for (Component $$2 : this.m_7360_()) {
            Optional<T> $$3 = $$2.m_5651_(p_130677_);
            if (!$$3.isPresent()) continue;
            return $$3;
        }
        return Optional.empty();
    }

    default public List<Component> m_240407_() {
        return this.m_178405_(Style.f_131099_);
    }

    default public List<Component> m_178405_(Style p_178406_) {
        ArrayList $$1 = Lists.newArrayList();
        this.m_7451_((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                $$1.add(Component.m_237113_(p_178404_).m_130948_(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return $$1;
    }

    default public boolean m_240452_(Component p_240571_) {
        List<Component> $$2;
        if (this.equals(p_240571_)) {
            return true;
        }
        List<Component> $$1 = this.m_240407_();
        return Collections.indexOfSubList($$1, $$2 = p_240571_.m_178405_(this.m_7383_())) != -1;
    }

    public static Component m_130674_(@Nullable String p_130675_) {
        return p_130675_ != null ? Component.m_237113_(p_130675_) : CommonComponents.f_237098_;
    }

    public static MutableComponent m_237113_(String p_237114_) {
        return MutableComponent.m_237204_(PlainTextContents.m_307377_(p_237114_));
    }

    public static MutableComponent m_237115_(String p_237116_) {
        return MutableComponent.m_237204_(new TranslatableContents(p_237116_, null, TranslatableContents.f_237494_));
    }

    public static MutableComponent m_237110_(String p_237111_, Object ... p_237112_) {
        return MutableComponent.m_237204_(new TranslatableContents(p_237111_, null, p_237112_));
    }

    public static MutableComponent m_307043_(String p_312579_, Object ... p_312922_) {
        for (int $$2 = 0; $$2 < p_312922_.length; ++$$2) {
            Object $$3 = p_312922_[$$2];
            if (TranslatableContents.m_306839_($$3) || $$3 instanceof Component) continue;
            p_312922_[$$2] = String.valueOf($$3);
        }
        return Component.m_237110_(p_312579_, p_312922_);
    }

    public static MutableComponent m_264568_(String p_265747_, @Nullable String p_265287_) {
        return MutableComponent.m_237204_(new TranslatableContents(p_265747_, p_265287_, TranslatableContents.f_237494_));
    }

    public static MutableComponent m_264642_(String p_265449_, @Nullable String p_265281_, Object ... p_265785_) {
        return MutableComponent.m_237204_(new TranslatableContents(p_265449_, p_265281_, p_265785_));
    }

    public static MutableComponent m_237119_() {
        return MutableComponent.m_237204_(PlainTextContents.f_302486_);
    }

    public static MutableComponent m_237117_(String p_237118_) {
        return MutableComponent.m_237204_(new KeybindContents(p_237118_));
    }

    public static MutableComponent m_237105_(String p_237106_, boolean p_237107_, Optional<Component> p_237108_, DataSource p_237109_) {
        return MutableComponent.m_237204_(new NbtContents(p_237106_, p_237107_, p_237108_, p_237109_));
    }

    public static MutableComponent m_237099_(String p_237100_, String p_237101_) {
        return MutableComponent.m_237204_(new ScoreContents(p_237100_, p_237101_));
    }

    public static MutableComponent m_237102_(String p_237103_, Optional<Component> p_237104_) {
        return MutableComponent.m_237204_(new SelectorContents(p_237103_, p_237104_));
    }

    public static Component m_306983_(Date p_313239_) {
        return Component.m_237113_(p_313239_.toString());
    }

    public static Component m_304916_(Message p_312086_) {
        Component component;
        if (p_312086_ instanceof Component) {
            Component $$1 = (Component)p_312086_;
            component = $$1;
        } else {
            component = Component.m_237113_(p_312086_.getString());
        }
        return component;
    }

    public static Component m_306730_(UUID p_311149_) {
        return Component.m_237113_(p_311149_.toString());
    }

    public static Component m_305236_(ResourceLocation p_311439_) {
        return Component.m_237113_(p_311439_.toString());
    }

    public static Component m_307221_(ChunkPos p_312850_) {
        return Component.m_237113_(p_312850_.toString());
    }

    public static class SerializerAdapter
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        public MutableComponent deserialize(JsonElement p_311708_, Type p_310257_, JsonDeserializationContext p_310325_) throws JsonParseException {
            return Serializer.m_130719_(p_311708_);
        }

        public JsonElement serialize(Component p_309493_, Type p_310679_, JsonSerializationContext p_312693_) {
            return Serializer.m_130705_(p_309493_);
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((Component)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static class Serializer {
        private static final Gson f_130685_ = new GsonBuilder().disableHtmlEscaping().create();

        private Serializer() {
        }

        static MutableComponent m_130719_(JsonElement p_130720_) {
            return (MutableComponent)Util.m_260975_(ComponentSerialization.f_303288_.parse((DynamicOps)JsonOps.INSTANCE, (Object)p_130720_), JsonParseException::new);
        }

        static JsonElement m_130705_(Component p_130706_) {
            return (JsonElement)Util.m_260975_(ComponentSerialization.f_303288_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)p_130706_), JsonParseException::new);
        }

        public static String m_130703_(Component p_130704_) {
            return f_130685_.toJson(Serializer.m_130705_(p_130704_));
        }

        public static JsonElement m_130716_(Component p_130717_) {
            return Serializer.m_130705_(p_130717_);
        }

        @Nullable
        public static MutableComponent m_130701_(String p_130702_) {
            JsonElement $$1 = JsonParser.parseString((String)p_130702_);
            if ($$1 == null) {
                return null;
            }
            return Serializer.m_130719_($$1);
        }

        @Nullable
        public static MutableComponent m_130691_(@Nullable JsonElement p_130692_) {
            if (p_130692_ == null) {
                return null;
            }
            return Serializer.m_130719_(p_130692_);
        }

        @Nullable
        public static MutableComponent m_130714_(String p_130715_) {
            JsonReader $$1 = new JsonReader((Reader)new StringReader(p_130715_));
            $$1.setLenient(true);
            JsonElement $$2 = JsonParser.parseReader((JsonReader)$$1);
            if ($$2 == null) {
                return null;
            }
            return Serializer.m_130719_($$2);
        }
    }
}

