/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger f_243935_ = LogUtils.getLogger();
    public static final List<RegistryData<?>> f_243803_ = List.of(new RegistryData<DimensionType>(Registries.f_256787_, DimensionType.f_63843_), new RegistryData<Biome>(Registries.f_256952_, Biome.f_47429_), new RegistryData<ChatType>(Registries.f_256873_, ChatType.f_237005_), new RegistryData(Registries.f_257003_, ConfiguredWorldCarver.f_64846_), new RegistryData(Registries.f_256911_, ConfiguredFeature.f_65373_), new RegistryData<PlacedFeature>(Registries.f_256988_, PlacedFeature.f_191772_), new RegistryData<Structure>(Registries.f_256944_, Structure.f_226553_), new RegistryData<StructureSet>(Registries.f_256998_, StructureSet.f_210001_), new RegistryData<StructureProcessorList>(Registries.f_257011_, StructureProcessorType.f_74467_), new RegistryData<StructureTemplatePool>(Registries.f_256948_, StructureTemplatePool.f_210554_), new RegistryData<NoiseGeneratorSettings>(Registries.f_256932_, NoiseGeneratorSettings.f_64430_), new RegistryData<NormalNoise.NoiseParameters>(Registries.f_256865_, NormalNoise.NoiseParameters.f_192851_), new RegistryData<DensityFunction>(Registries.f_257040_, DensityFunction.f_208216_), new RegistryData<WorldPreset>(Registries.f_256729_, WorldPreset.f_226414_), new RegistryData<FlatLevelGeneratorPreset>(Registries.f_256724_, FlatLevelGeneratorPreset.f_226243_), new RegistryData<TrimPattern>(Registries.f_266063_, TrimPattern.f_266050_), new RegistryData<TrimMaterial>(Registries.f_266076_, TrimMaterial.f_266095_), new RegistryData<DamageType>(Registries.f_268580_, DamageType.f_268510_), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.f_273919_, MultiNoiseBiomeSourceParameterList.f_273907_));
    public static final List<RegistryData<?>> f_244547_ = List.of(new RegistryData<LevelStem>(Registries.f_256862_, LevelStem.f_63970_));

    public static RegistryAccess.Frozen m_247207_(ResourceManager p_252046_, RegistryAccess p_249916_, List<RegistryData<?>> p_250344_) {
        HashMap $$3 = new HashMap();
        List<Pair<WritableRegistry<?>, Loader>> $$4 = p_250344_.stream().map(p_250249_ -> p_250249_.m_245364_(Lifecycle.stable(), $$3)).toList();
        RegistryOps.RegistryInfoLookup $$5 = RegistryDataLoader.m_255261_(p_249916_, $$4);
        $$4.forEach(p_255508_ -> ((Loader)p_255508_.getSecond()).m_245441_(p_252046_, $$5));
        $$4.forEach(p_258223_ -> {
            Registry $$2 = (Registry)p_258223_.getFirst();
            try {
                $$2.m_203521_();
            }
            catch (Exception $$3) {
                $$3.put($$2.m_123023_(), $$3);
            }
        });
        if (!$$3.isEmpty()) {
            RegistryDataLoader.m_245896_($$3);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new RegistryAccess.ImmutableRegistryAccess($$4.stream().map(Pair::getFirst).toList()).m_203557_();
    }

    private static RegistryOps.RegistryInfoLookup m_255261_(RegistryAccess p_256568_, List<Pair<WritableRegistry<?>, Loader>> p_255821_) {
        final HashMap $$2 = new HashMap();
        p_256568_.m_206193_().forEach(p_255505_ -> $$2.put(p_255505_.f_206233_(), RegistryDataLoader.m_255016_(p_255505_.f_206234_())));
        p_255821_.forEach(p_258221_ -> $$2.put(((WritableRegistry)p_258221_.getFirst()).m_123023_(), RegistryDataLoader.m_255259_((WritableRegistry)p_258221_.getFirst())));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> m_254838_(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)$$2.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> m_255259_(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo(p_256020_.m_255303_(), p_256020_.m_203505_(), p_256020_.m_203658_());
    }

    private static <T> RegistryOps.RegistryInfo<T> m_255016_(Registry<T> p_256230_) {
        return new RegistryOps.RegistryInfo<T>(p_256230_.m_255303_(), p_256230_.m_255014_(), p_256230_.m_203658_());
    }

    private static void m_245896_(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter $$1 = new StringWriter();
        PrintWriter $$2 = new PrintWriter($$1);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> $$3 = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).m_211136_(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).m_135782_(), Map.Entry::getValue)));
        $$3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            $$2.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                $$2.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace($$2);
            });
        });
        $$2.flush();
        f_243935_.error("Registry loading errors:\n{}", (Object)$$1);
    }

    private static String m_246502_(ResourceLocation p_252033_) {
        return p_252033_.m_135815_();
    }

    static <E> void m_255048_(RegistryOps.RegistryInfoLookup p_256369_, ResourceManager p_256349_, ResourceKey<? extends Registry<E>> p_255792_, WritableRegistry<E> p_256211_, Decoder<E> p_256232_, Map<ResourceKey<?>, Exception> p_255884_) {
        String $$6 = RegistryDataLoader.m_246502_(p_255792_.m_135782_());
        FileToIdConverter $$7 = FileToIdConverter.m_246568_($$6);
        RegistryOps $$8 = RegistryOps.m_255060_(JsonOps.INSTANCE, p_256369_);
        for (Map.Entry<ResourceLocation, Resource> $$9 : $$7.m_247457_(p_256349_).entrySet()) {
            ResourceLocation $$10 = $$9.getKey();
            ResourceKey $$11 = ResourceKey.m_135785_(p_255792_, $$7.m_245273_($$10));
            Resource $$12 = $$9.getValue();
            try {
                BufferedReader $$13 = $$12.m_215508_();
                try {
                    JsonElement $$14 = JsonParser.parseReader((Reader)$$13);
                    DataResult $$15 = p_256232_.parse($$8, (Object)$$14);
                    Object $$16 = $$15.getOrThrow(false, p_248715_ -> {});
                    p_256211_.m_255290_($$11, $$16, $$12.m_247137_() ? Lifecycle.stable() : $$15.lifecycle());
                }
                finally {
                    if ($$13 == null) continue;
                    ((Reader)$$13).close();
                }
            }
            catch (Exception $$17) {
                p_255884_.put($$11, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", $$10, $$12.m_215506_()), $$17));
            }
        }
    }

    static interface Loader {
        public void m_245441_(ResourceManager var1, RegistryOps.RegistryInfoLookup var2);
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> f_243794_, Codec<T> f_244580_) {
        Pair<WritableRegistry<?>, Loader> m_245364_(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            MappedRegistry $$2 = new MappedRegistry(this.f_243794_, p_251662_);
            Loader $$3 = (p_255511_, p_255512_) -> RegistryDataLoader.m_255048_(p_255512_, p_255511_, this.f_243794_, $$2, this.f_244580_, p_251565_);
            return Pair.of($$2, (Object)$$3);
        }

        public void m_305182_(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> p_310351_) {
            p_310351_.accept(this.f_243794_, this.f_244580_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this);
        }

        @Override
        public final boolean equals(Object p_249596_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this, p_249596_);
        }
    }
}

