/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class Main {
    private static final Logger f_129670_ = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$14 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$15 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$44;
            Dynamic $$37;
            OptionSet $$17 = $$1.parse(p_129699_);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$18 = (Path)$$17.valueOf((OptionSpec)$$15);
            if ($$18 != null) {
                Main.m_269308_($$18);
            }
            CrashReport.m_127529_();
            if ($$17.has((OptionSpec)$$14)) {
                JvmProfiler.f_185340_.m_183425_(Environment.SERVER);
            }
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            Path $$19 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings $$20 = new DedicatedServerSettings($$19);
            $$20.m_139780_();
            Path $$21 = Paths.get("eula.txt", new String[0]);
            Eula $$22 = new Eula($$21);
            if ($$17.has((OptionSpec)$$3)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)$$19.toAbsolutePath(), (Object)$$21.toAbsolutePath());
                return;
            }
            if (!$$22.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$23 = new File((String)$$17.valueOf((OptionSpec)$$10));
            Services $$24 = Services.m_214344_(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$23);
            String $$25 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$11)).orElse($$20.m_139777_().f_139741_);
            LevelStorageSource $$26 = LevelStorageSource.m_78242_($$23.toPath());
            LevelStorageSource.LevelStorageAccess $$27 = $$26.m_289864_($$25);
            if ($$27.m_306456_()) {
                void $$36;
                try {
                    Dynamic<?> $$28 = $$27.m_307464_();
                    LevelSummary $$29 = $$27.m_78308_($$28);
                }
                catch (IOException | NbtException | ReportedNbtException $$30) {
                    LevelStorageSource.LevelDirectory $$31 = $$27.m_306248_();
                    f_129670_.warn("Failed to load world data from {}", (Object)$$31.m_230858_(), (Object)$$30);
                    f_129670_.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$32 = $$27.m_305112_();
                        LevelSummary $$33 = $$27.m_78308_($$32);
                    }
                    catch (IOException | NbtException | ReportedNbtException $$34) {
                        f_129670_.error("Failed to load world data from {}", (Object)$$31.m_230859_(), (Object)$$34);
                        f_129670_.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$31.m_230858_(), (Object)$$31.m_230859_());
                        return;
                    }
                    $$27.m_305486_();
                }
                if ($$36.m_193020_()) {
                    f_129670_.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$36.m_193021_()) {
                    f_129670_.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$37 = null;
            }
            Dynamic $$38 = $$37;
            boolean $$39 = $$17.has((OptionSpec)$$8);
            if ($$39) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository $$40 = ServerPacksSource.m_247728_($$27);
            try {
                WorldLoader.InitConfig $$41 = Main.m_245383_($$20.m_139777_(), $$38, $$39, $$40);
                WorldStem $$42 = (WorldStem)Util.m_214679_(arg_0 -> Main.m_244800_($$41, $$38, $$17, (OptionSpec)$$4, $$20, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$43) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$43);
                return;
            }
            RegistryAccess.Frozen $$45 = $$44.f_244542_().m_247579_();
            if ($$17.has((OptionSpec)$$6)) {
                Main.m_195488_($$27, DataFixers.m_14512_(), $$17.has((OptionSpec)$$7), () -> true, $$45.m_175515_(Registries.f_256862_));
            }
            WorldData $$46 = $$44.f_206895_();
            $$27.m_78287_($$45, $$46);
            final DedicatedServer $$47 = MinecraftServer.m_129872_(arg_0 -> Main.m_292145_($$27, $$40, (WorldStem)$$44, $$20, $$24, $$17, (OptionSpec)$$12, (OptionSpec)$$4, (OptionSpec)$$13, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$48 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$47.m_7570_(true);
                }
            };
            $$48.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook($$48);
        }
        catch (Exception $$49) {
            f_129670_.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$49);
        }
    }

    private static void m_269308_(Path p_270192_) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString(p_270192_, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static WorldLoader.InitConfig m_245383_(DedicatedServerProperties p_248563_, @Nullable Dynamic<?> p_310940_, boolean p_249093_, PackRepository p_251069_) {
        WorldDataConfiguration $$8;
        boolean $$7;
        if (p_310940_ != null) {
            WorldDataConfiguration $$4 = LevelStorageSource.m_245610_(p_310940_);
            boolean $$5 = false;
            WorldDataConfiguration $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new WorldDataConfiguration(p_248563_.f_243997_, FeatureFlags.f_244332_);
        }
        WorldLoader.PackConfig $$9 = new WorldLoader.PackConfig(p_251069_, $$8, p_249093_, $$7);
        return new WorldLoader.InitConfig($$9, Commands.CommandSelection.DEDICATED, p_248563_.f_139711_);
    }

    private static void m_195488_(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, Registry<LevelStem> p_250443_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader $$5 = new WorldUpgrader(p_195489_, p_195490_, p_250443_, p_195491_);
        Component $$6 = null;
        while (!$$5.m_18829_()) {
            int $$8;
            Component $$7 = $$5.m_18837_();
            if ($$6 != $$7) {
                $$6 = $$7;
                f_129670_.info($$5.m_18837_().getString());
            }
            if (($$8 = $$5.m_18834_()) > 0) {
                int $$9 = $$5.m_18835_() + $$5.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.m_14143_((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!p_195492_.getAsBoolean()) {
                $$5.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer m_292145_(LevelStorageSource.LevelStorageAccess p_296422_, PackRepository p_296423_, WorldStem p_296424_, DedicatedServerSettings p_296425_, Services p_296426_, OptionSet p_296427_, OptionSpec p_296428_, OptionSpec p_296429_, OptionSpec p_296430_, OptionSpec p_296431_, OptionSpec p_296432_, Thread p_296433_) {
        boolean $$13;
        DedicatedServer $$12 = new DedicatedServer(p_296433_, p_296422_, p_296423_, p_296424_, p_296425_, DataFixers.m_14512_(), p_296426_, LoggerChunkProgressListener::new);
        $$12.m_129801_((Integer)p_296427_.valueOf(p_296428_));
        $$12.m_129975_(p_296427_.has(p_296429_));
        $$12.m_129948_((String)p_296427_.valueOf(p_296430_));
        boolean bl = $$13 = !p_296427_.has(p_296431_) && !p_296427_.valuesOf(p_296432_).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.m_139667_();
        }
        return $$12;
    }

    private static /* synthetic */ CompletableFuture m_244800_(WorldLoader.InitConfig p_248080_, Dynamic p_309771_, OptionSet p_248082_, OptionSpec p_248083_, DedicatedServerSettings p_248084_, OptionSpec p_248085_, Executor p_248086_) {
        return WorldLoader.m_214362_(p_248080_, p_308589_ -> {
            WorldDimensions $$14;
            WorldOptions $$13;
            LevelSettings $$12;
            Registry<LevelStem> $$6 = p_308589_.f_243759_().m_175515_(Registries.f_256862_);
            if (p_309771_ != null) {
                LevelDataAndDimensions $$7 = LevelStorageSource.m_306102_(p_309771_, p_308589_.f_244127_(), $$6, p_308589_.f_244104_());
                return new WorldLoader.DataLoadOutput<WorldData>($$7.f_303671_(), $$7.f_303409_().m_245593_());
            }
            f_129670_.info("No existing world data, creating new world");
            if (p_248082_.has(p_248083_)) {
                LevelSettings $$8 = MinecraftServer.f_129743_;
                WorldOptions $$9 = WorldOptions.f_244225_;
                WorldDimensions $$10 = WorldPresets.m_246552_(p_308589_.f_244104_());
            } else {
                DedicatedServerProperties $$11 = p_248084_.m_139777_();
                $$12 = new LevelSettings($$11.f_139741_, $$11.f_139740_, $$11.f_139752_, $$11.f_139739_, false, new GameRules(), p_308589_.f_244127_());
                $$13 = p_248082_.has(p_248085_) ? $$11.f_243824_.m_247325_(true) : $$11.f_243824_;
                $$14 = $$11.m_246483_(p_308589_.f_244104_());
            }
            WorldDimensions.Complete $$15 = $$14.m_245300_($$6);
            Lifecycle $$16 = $$15.m_245945_().add(p_308589_.f_244104_().m_211816_());
            return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData($$12, $$13, $$15.f_244634_(), $$16), $$15.m_245593_());
        }, WorldStem::new, Util.m_183991_(), p_248086_);
    }
}

