/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.profiling.ProfileResults;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class DebugCommand {
    static final Logger f_136900_ = LogUtils.getLogger();
    private static final SimpleCommandExceptionType f_136901_ = new SimpleCommandExceptionType((Message)Component.m_237115_("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType f_136902_ = new SimpleCommandExceptionType((Message)Component.m_237115_("commands.debug.alreadyRunning"));
    static final SimpleCommandExceptionType f_303735_ = new SimpleCommandExceptionType((Message)Component.m_237115_("commands.debug.function.noRecursion"));
    static final SimpleCommandExceptionType f_302589_ = new SimpleCommandExceptionType((Message)Component.m_237115_("commands.debug.function.noReturnRun"));

    public static void m_136905_(CommandDispatcher<CommandSourceStack> p_136906_) {
        p_136906_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("debug").requires(p_180073_ -> p_180073_.m_6761_(3))).then(Commands.m_82127_("start").executes(p_180069_ -> DebugCommand.m_136909_((CommandSourceStack)p_180069_.getSource())))).then(Commands.m_82127_("stop").executes(p_136918_ -> DebugCommand.m_136915_((CommandSourceStack)p_136918_.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_("function").requires(p_180071_ -> p_180071_.m_6761_(3))).then(Commands.m_82129_("name", FunctionArgument.m_120907_()).suggests(FunctionCommand.f_137712_).executes((Command)new TraceCustomExecutor()))));
    }

    private static int m_136909_(CommandSourceStack p_136910_) throws CommandSyntaxException {
        MinecraftServer $$1 = p_136910_.m_81377_();
        if ($$1.m_177942_()) {
            throw f_136902_.create();
        }
        $$1.m_177943_();
        p_136910_.m_288197_(() -> Component.m_237115_("commands.debug.started"), true);
        return 0;
    }

    private static int m_136915_(CommandSourceStack p_136916_) throws CommandSyntaxException {
        MinecraftServer $$1 = p_136916_.m_81377_();
        if (!$$1.m_177942_()) {
            throw f_136901_.create();
        }
        ProfileResults $$2 = $$1.m_177944_();
        double $$3 = (double)$$2.m_18577_() / (double)TimeUtil.f_145016_;
        double $$4 = (double)$$2.m_7315_() / $$3;
        p_136916_.m_288197_(() -> Component.m_237110_("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", $$3), $$2.m_7315_(), String.format(Locale.ROOT, "%.2f", $$4)), true);
        return (int)$$4;
    }

    static class TraceCustomExecutor
    extends CustomCommandExecutor.WithErrorHandling<CommandSourceStack>
    implements CustomCommandExecutor.CommandAdapter<CommandSourceStack> {
        TraceCustomExecutor() {
        }

        @Override
        public void m_305065_(CommandSourceStack p_309819_, ContextChain<CommandSourceStack> p_311173_, ChainModifiers p_312111_, ExecutionControl<CommandSourceStack> p_311988_) throws CommandSyntaxException {
            if (p_312111_.m_305036_()) {
                throw f_302589_.create();
            }
            if (p_311988_.m_305414_() != null) {
                throw f_303735_.create();
            }
            CommandContext $$4 = p_311173_.getTopContext();
            Collection<CommandFunction<CommandSourceStack>> $$5 = FunctionArgument.m_120910_((CommandContext<CommandSourceStack>)$$4, "name");
            MinecraftServer $$6 = p_309819_.m_81377_();
            String $$7 = "debug-trace-" + Util.m_241986_() + ".txt";
            CommandDispatcher<CommandSourceStack> $$8 = p_309819_.m_81377_().m_129890_().m_136127_();
            int $$9 = 0;
            try {
                Path $$10 = $$6.m_129971_("debug").toPath();
                Files.createDirectories($$10, new FileAttribute[0]);
                final PrintWriter $$11 = new PrintWriter(Files.newBufferedWriter($$10.resolve($$7), StandardCharsets.UTF_8, new OpenOption[0]));
                Tracer $$12 = new Tracer($$11);
                p_311988_.m_304947_($$12);
                for (final CommandFunction<CommandSourceStack> $$13 : $$5) {
                    try {
                        CommandSourceStack $$14 = p_309819_.m_165484_($$12).m_81358_(2);
                        InstantiatedFunction<CommandSourceStack> $$15 = $$13.m_304684_(null, $$8, $$14);
                        p_311988_.m_306270_(new CallFunction<CommandSourceStack>($$15, CommandResultCallback.f_302577_, false){

                            @Override
                            public void m_304778_(CommandSourceStack p_310186_, ExecutionContext<CommandSourceStack> p_311250_, Frame p_311262_) {
                                $$11.println($$13.m_304900_());
                                super.m_304778_(p_310186_, p_311250_, p_311262_);
                            }

                            @Override
                            public /* synthetic */ void m_304778_(Object object, ExecutionContext executionContext, Frame frame) {
                                this.m_304778_((CommandSourceStack)object, (ExecutionContext<CommandSourceStack>)executionContext, frame);
                            }
                        }.m_307530_($$14));
                        $$9 += $$15.m_306124_().size();
                    }
                    catch (FunctionInstantiationException $$16) {
                        p_309819_.m_81352_($$16.m_294144_());
                    }
                }
            }
            catch (IOException | UncheckedIOException $$17) {
                f_136900_.warn("Tracing failed", (Throwable)$$17);
                p_309819_.m_81352_(Component.m_237115_("commands.debug.function.traceFailed"));
            }
            int $$18 = $$9;
            p_311988_.m_306270_((p_311688_, p_310332_) -> {
                if ($$5.size() == 1) {
                    p_309819_.m_288197_(() -> Component.m_237110_("commands.debug.function.success.single", $$18, Component.m_305236_(((CommandFunction)$$5.iterator().next()).m_304900_()), $$7), true);
                } else {
                    p_309819_.m_288197_(() -> Component.m_237110_("commands.debug.function.success.multiple", $$18, $$5.size(), $$7), true);
                }
            });
        }

        @Override
        public /* synthetic */ void m_305065_(ExecutionCommandSource executionCommandSource, ContextChain contextChain, ChainModifiers chainModifiers, ExecutionControl executionControl) throws CommandSyntaxException {
            this.m_305065_((CommandSourceStack)executionCommandSource, (ContextChain<CommandSourceStack>)contextChain, chainModifiers, (ExecutionControl<CommandSourceStack>)executionControl);
        }
    }

    static class Tracer
    implements CommandSource,
    TraceCallbacks {
        public static final int f_180074_ = 1;
        private final PrintWriter f_180075_;
        private int f_180076_;
        private boolean f_180077_;

        Tracer(PrintWriter p_180079_) {
            this.f_180075_ = p_180079_;
        }

        private void m_180081_(int p_180082_) {
            this.m_180097_(p_180082_);
            this.f_180076_ = p_180082_;
        }

        private void m_180097_(int p_180098_) {
            for (int $$1 = 0; $$1 < p_180098_ + 1; ++$$1) {
                this.f_180075_.write("    ");
            }
        }

        private void m_180103_() {
            if (this.f_180077_) {
                this.f_180075_.println();
                this.f_180077_ = false;
            }
        }

        @Override
        public void m_180083_(int p_180084_, String p_180085_) {
            this.m_180103_();
            this.m_180081_(p_180084_);
            this.f_180075_.print("[C] ");
            this.f_180075_.print(p_180085_);
            this.f_180077_ = true;
        }

        @Override
        public void m_180086_(int p_180087_, String p_180088_, int p_180089_) {
            if (this.f_180077_) {
                this.f_180075_.print(" -> ");
                this.f_180075_.println(p_180089_);
                this.f_180077_ = false;
            } else {
                this.m_180081_(p_180087_);
                this.f_180075_.print("[R = ");
                this.f_180075_.print(p_180089_);
                this.f_180075_.print("] ");
                this.f_180075_.println(p_180088_);
            }
        }

        @Override
        public void m_180090_(int p_180091_, ResourceLocation p_180092_, int p_180093_) {
            this.m_180103_();
            this.m_180081_(p_180091_);
            this.f_180075_.print("[F] ");
            this.f_180075_.print(p_180092_);
            this.f_180075_.print(" size=");
            this.f_180075_.println(p_180093_);
        }

        @Override
        public void m_180099_(String p_180101_) {
            this.m_180103_();
            this.m_180081_(this.f_180076_ + 1);
            this.f_180075_.print("[E] ");
            this.f_180075_.print(p_180101_);
        }

        @Override
        public void m_213846_(Component p_214427_) {
            this.m_180103_();
            this.m_180097_(this.f_180076_ + 1);
            this.f_180075_.print("[M] ");
            this.f_180075_.println(p_214427_.getString());
        }

        @Override
        public boolean m_6999_() {
            return true;
        }

        @Override
        public boolean m_7028_() {
            return true;
        }

        @Override
        public boolean m_6102_() {
            return false;
        }

        @Override
        public boolean m_142559_() {
            return true;
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((Writer)this.f_180075_);
        }
    }
}

