/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ProcessorMailbox;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger f_303188_ = LogUtils.getLogger();
    private static final int f_303802_ = 20;
    private final Path f_303578_;
    private final JsonEventLog<LogEntry> f_303172_;
    private final ProcessorMailbox<Runnable> f_302641_ = ProcessorMailbox.m_18751_(Util.m_306705_(), "download-queue");

    public DownloadQueue(Path p_311573_) throws IOException {
        this.f_303578_ = p_311573_;
        FileUtil.m_257659_(p_311573_);
        this.f_303172_ = JsonEventLog.m_260847_(LogEntry.f_302665_, p_311573_.resolve("log.json"));
        DownloadCacheCleaner.m_307501_(p_311573_, 20);
    }

    private BatchResult m_306535_(BatchConfig p_312964_, Map<UUID, DownloadRequest> p_311709_) {
        BatchResult $$2 = new BatchResult();
        p_311709_.forEach((p_311290_, p_311466_) -> {
            Path $$4 = this.f_303578_.resolve(p_311290_.toString());
            Path $$5 = null;
            try {
                $$5 = HttpUtil.m_305661_($$4, p_311466_.f_303187_, p_310272_.f_303230_, p_310272_.f_302484_, p_311466_.f_303050_, p_310272_.f_303205_, p_310272_.f_302686_, p_310272_.f_302265_);
                p_309928_.f_302807_.put((UUID)p_311290_, $$5);
            }
            catch (Exception $$6) {
                f_303188_.error("Failed to download {}", (Object)p_311466_.f_303187_, (Object)$$6);
                p_309928_.f_303809_.add((UUID)p_311290_);
            }
            try {
                this.f_303172_.m_260901_(new LogEntry((UUID)p_311290_, p_311466_.f_303187_.toString(), Instant.now(), Optional.ofNullable(p_311466_.f_303050_).map(HashCode::toString), $$5 != null ? this.m_306845_($$5) : Either.left((Object)"download_failed")));
            }
            catch (Exception $$7) {
                f_303188_.error("Failed to log download of {}", (Object)p_311466_.f_303187_, (Object)$$7);
            }
        });
        return $$2;
    }

    private Either<String, FileInfoEntry> m_306845_(Path p_310185_) {
        try {
            long $$1 = Files.size(p_310185_);
            Path $$2 = this.f_303578_.relativize(p_310185_);
            return Either.right((Object)new FileInfoEntry($$2.toString(), $$1));
        }
        catch (IOException $$3) {
            f_303188_.error("Failed to get file size of {}", (Object)p_310185_, (Object)$$3);
            return Either.left((Object)"no_access");
        }
    }

    public CompletableFuture<BatchResult> m_304862_(BatchConfig p_312532_, Map<UUID, DownloadRequest> p_312658_) {
        return CompletableFuture.supplyAsync(() -> this.m_306535_(p_312532_, p_312658_), this.f_302641_::m_6937_);
    }

    @Override
    public void close() throws IOException {
        this.f_302641_.close();
        this.f_303172_.close();
    }

    record LogEntry(UUID f_303431_, String f_302712_, Instant f_303846_, Optional<String> f_302640_, Either<String, FileInfoEntry> f_302525_) {
        public static final Codec<LogEntry> f_302665_ = RecordCodecBuilder.create(p_310865_ -> p_310865_.group((App)UUIDUtil.f_260719_.fieldOf("id").forGetter(LogEntry::f_303431_), (App)Codec.STRING.fieldOf("url").forGetter(LogEntry::f_302712_), (App)ExtraCodecs.f_216159_.fieldOf("time").forGetter(LogEntry::f_303846_), (App)Codec.STRING.optionalFieldOf("hash").forGetter(LogEntry::f_302640_), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)FileInfoEntry.f_302756_.fieldOf("file")).forGetter(LogEntry::f_302525_)).apply((Applicative)p_310865_, LogEntry::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LogEntry.class, "id;url;time;hash;errorOrFileInfo", "f_303431_", "f_302712_", "f_303846_", "f_302640_", "f_302525_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LogEntry.class, "id;url;time;hash;errorOrFileInfo", "f_303431_", "f_302712_", "f_303846_", "f_302640_", "f_302525_"}, this);
        }

        @Override
        public final boolean equals(Object p_312454_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LogEntry.class, "id;url;time;hash;errorOrFileInfo", "f_303431_", "f_302712_", "f_303846_", "f_302640_", "f_302525_"}, this, p_312454_);
        }
    }

    public record BatchResult(Map<UUID, Path> f_302807_, Set<UUID> f_303809_) {
        public BatchResult() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BatchResult.class, "downloaded;failed", "f_302807_", "f_303809_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BatchResult.class, "downloaded;failed", "f_302807_", "f_303809_"}, this);
        }

        @Override
        public final boolean equals(Object p_311433_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BatchResult.class, "downloaded;failed", "f_302807_", "f_303809_"}, this, p_311433_);
        }
    }

    public record BatchConfig(HashFunction f_302484_, int f_303205_, Map<String, String> f_303230_, Proxy f_302686_, HttpUtil.DownloadProgressListener f_302265_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BatchConfig.class, "hashFunction;maxSize;headers;proxy;listener", "f_302484_", "f_303205_", "f_303230_", "f_302686_", "f_302265_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BatchConfig.class, "hashFunction;maxSize;headers;proxy;listener", "f_302484_", "f_303205_", "f_303230_", "f_302686_", "f_302265_"}, this);
        }

        @Override
        public final boolean equals(Object p_311879_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BatchConfig.class, "hashFunction;maxSize;headers;proxy;listener", "f_302484_", "f_303205_", "f_303230_", "f_302686_", "f_302265_"}, this, p_311879_);
        }
    }

    record FileInfoEntry(String f_302319_, long f_302603_) {
        public static final Codec<FileInfoEntry> f_302756_ = RecordCodecBuilder.create(p_311514_ -> p_311514_.group((App)Codec.STRING.fieldOf("name").forGetter(FileInfoEntry::f_302319_), (App)Codec.LONG.fieldOf("size").forGetter(FileInfoEntry::f_302603_)).apply((Applicative)p_311514_, FileInfoEntry::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FileInfoEntry.class, "name;size", "f_302319_", "f_302603_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FileInfoEntry.class, "name;size", "f_302319_", "f_302603_"}, this);
        }

        @Override
        public final boolean equals(Object p_312525_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FileInfoEntry.class, "name;size", "f_302319_", "f_302603_"}, this, p_312525_);
        }
    }

    public record DownloadRequest(URL f_303187_, @Nullable HashCode f_303050_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DownloadRequest.class, "url;hash", "f_303187_", "f_303050_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DownloadRequest.class, "url;hash", "f_303187_", "f_303050_"}, this);
        }

        @Override
        public final boolean equals(Object p_312928_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DownloadRequest.class, "url;hash", "f_303187_", "f_303050_"}, this, p_312928_);
        }
    }
}

