/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Map;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class HttpUtil {
    private static final Logger f_13937_ = LogUtils.getLogger();

    private HttpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Path m_305661_(Path p_312337_, URL p_309490_, Map<String, String> p_311545_, HashFunction p_312368_, @Nullable HashCode p_309569_, int p_312993_, Proxy p_311636_, DownloadProgressListener p_310347_) {
        InputStream $$9;
        HttpURLConnection $$8;
        block21: {
            $$8 = null;
            $$9 = null;
            p_310347_.m_305410_();
            if (p_309569_ != null) {
                Path $$10 = HttpUtil.m_306073_(p_312337_, p_309569_);
                try {
                    if (HttpUtil.m_306783_($$10, p_312368_, p_309569_)) {
                        f_13937_.info("Returning cached file since actual hash matches requested");
                        p_310347_.m_304846_(true);
                        HttpUtil.m_305114_($$10);
                        return $$10;
                    }
                }
                catch (IOException $$11) {
                    f_13937_.warn("Failed to check cached file {}", (Object)$$10, (Object)$$11);
                }
                try {
                    f_13937_.warn("Existing file {} not found or had mismatched hash", (Object)$$10);
                    Files.deleteIfExists($$10);
                }
                catch (IOException $$12) {
                    p_310347_.m_304846_(false);
                    throw new UncheckedIOException("Failed to remove existing file " + $$10, $$12);
                }
            }
            Path $$13 = null;
            $$8 = (HttpURLConnection)p_309490_.openConnection(p_311636_);
            $$8.setInstanceFollowRedirects(true);
            p_311545_.forEach($$8::setRequestProperty);
            $$9 = $$8.getInputStream();
            long $$14 = $$8.getContentLengthLong();
            OptionalLong $$15 = $$14 != -1L ? OptionalLong.of($$14) : OptionalLong.empty();
            FileUtil.m_257659_(p_312337_);
            p_310347_.m_306050_($$15);
            if ($$15.isPresent() && $$15.getAsLong() > (long)p_312993_) {
                throw new IOException("Filesize is bigger than maximum allowed (file is " + $$15 + ", limit is " + p_312993_ + ")");
            }
            if ($$13 == null) break block21;
            HashCode $$16 = HttpUtil.m_306496_(p_312368_, p_312993_, p_310347_, $$9, $$13);
            if (!$$16.equals((Object)p_309569_)) {
                throw new IOException("Hash of downloaded file (" + $$16 + ") did not match requested (" + p_309569_ + ")");
            }
            p_310347_.m_304846_(true);
            Path path = $$13;
            IOUtils.closeQuietly((InputStream)$$9);
            return path;
        }
        Path $$17 = Files.createTempFile(p_312337_, "download", ".tmp", new FileAttribute[0]);
        HashCode $$18 = HttpUtil.m_306496_(p_312368_, p_312993_, p_310347_, $$9, $$17);
        Path $$19 = HttpUtil.m_306073_(p_312337_, $$18);
        if (!HttpUtil.m_306783_($$19, p_312368_, $$18)) {
            Files.move($$17, $$19, StandardCopyOption.REPLACE_EXISTING);
        } else {
            HttpUtil.m_305114_($$19);
        }
        p_310347_.m_304846_(true);
        Path path = $$19;
        Files.deleteIfExists($$17);
        IOUtils.closeQuietly((InputStream)$$9);
        return path;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Files.deleteIfExists($$17);
                        throw throwable;
                    }
                    catch (Throwable $$20) {
                        InputStream $$21;
                        if ($$8 != null && ($$21 = $$8.getErrorStream()) != null) {
                            try {
                                f_13937_.error("HTTP response error: {}", (Object)IOUtils.toString((InputStream)$$21, (Charset)StandardCharsets.UTF_8));
                            }
                            catch (Exception $$22) {
                                f_13937_.error("Failed to read response from server");
                            }
                        }
                        p_310347_.m_304846_(false);
                        throw new IllegalStateException("Failed to download file " + p_309490_, $$20);
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly($$9);
                    throw throwable2;
                }
            }
        }
    }

    private static void m_305114_(Path p_311353_) {
        try {
            Files.setLastModifiedTime(p_311353_, FileTime.from(Instant.now()));
        }
        catch (IOException $$1) {
            f_13937_.warn("Failed to update modification time of {}", (Object)p_311353_, (Object)$$1);
        }
    }

    private static HashCode m_307527_(Path p_310985_, HashFunction p_312320_) throws IOException {
        Hasher $$2 = p_312320_.newHasher();
        try (OutputStream $$3 = Funnels.asOutputStream((PrimitiveSink)$$2);
             InputStream $$4 = Files.newInputStream(p_310985_, new OpenOption[0]);){
            $$4.transferTo($$3);
        }
        return $$2.hash();
    }

    private static boolean m_306783_(Path p_309713_, HashFunction p_311423_, HashCode p_312149_) throws IOException {
        if (Files.exists(p_309713_, new LinkOption[0])) {
            HashCode $$3 = HttpUtil.m_307527_(p_309713_, p_311423_);
            if ($$3.equals((Object)p_312149_)) {
                return true;
            }
            f_13937_.warn("Mismatched hash of file {}, expected {} but found {}", new Object[]{p_309713_, p_312149_, $$3});
        }
        return false;
    }

    private static Path m_306073_(Path p_310769_, HashCode p_311855_) {
        return p_310769_.resolve(p_311855_.toString());
    }

    private static HashCode m_306496_(HashFunction p_312168_, int p_311506_, DownloadProgressListener p_311732_, InputStream p_312120_, Path p_310124_) throws IOException {
        try (OutputStream $$5 = Files.newOutputStream(p_310124_, StandardOpenOption.CREATE);){
            int $$9;
            Hasher $$6 = p_312168_.newHasher();
            byte[] $$7 = new byte[8196];
            long $$8 = 0L;
            while (($$9 = p_312120_.read($$7)) >= 0) {
                p_311732_.m_305341_($$8 += (long)$$9);
                if ($$8 > (long)p_311506_) {
                    throw new IOException("Filesize was bigger than maximum allowed (got >= " + $$8 + ", limit was " + p_311506_ + ")");
                }
                if (Thread.interrupted()) {
                    f_13937_.error("INTERRUPTED");
                    throw new IOException("Download interrupted");
                }
                $$5.write($$7, 0, $$9);
                $$6.putBytes($$7, 0, $$9);
            }
            HashCode hashCode = $$6.hash();
            return hashCode;
        }
    }

    public static int m_13939_() {
        int n;
        ServerSocket $$0 = new ServerSocket(0);
        try {
            n = $$0.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$0.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$1) {
                return 25564;
            }
        }
        $$0.close();
        return n;
    }

    public static boolean m_257796_(int p_259872_) {
        boolean bl;
        if (p_259872_ < 0 || p_259872_ > 65535) {
            return false;
        }
        ServerSocket $$1 = new ServerSocket(p_259872_);
        try {
            bl = $$1.getLocalPort() == p_259872_;
        }
        catch (Throwable throwable) {
            try {
                try {
                    $$1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException $$2) {
                return false;
            }
        }
        $$1.close();
        return bl;
    }

    public static interface DownloadProgressListener {
        public void m_305410_();

        public void m_306050_(OptionalLong var1);

        public void m_305341_(long var1);

        public void m_304846_(boolean var1);
    }
}

