/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.phys.Vec3;

public final class TrialSpawnerState
extends Enum<TrialSpawnerState>
implements StringRepresentable {
    public static final /* enum */ TrialSpawnerState INACTIVE = new TrialSpawnerState("inactive", 0, ParticleEmission.f_302687_, -1.0, false);
    public static final /* enum */ TrialSpawnerState WAITING_FOR_PLAYERS = new TrialSpawnerState("waiting_for_players", 4, ParticleEmission.f_302488_, 200.0, true);
    public static final /* enum */ TrialSpawnerState ACTIVE = new TrialSpawnerState("active", 8, ParticleEmission.f_302540_, 1000.0, true);
    public static final /* enum */ TrialSpawnerState WAITING_FOR_REWARD_EJECTION = new TrialSpawnerState("waiting_for_reward_ejection", 8, ParticleEmission.f_302488_, -1.0, false);
    public static final /* enum */ TrialSpawnerState EJECTING_REWARD = new TrialSpawnerState("ejecting_reward", 8, ParticleEmission.f_302488_, -1.0, false);
    public static final /* enum */ TrialSpawnerState COOLDOWN = new TrialSpawnerState("cooldown", 0, ParticleEmission.f_303781_, -1.0, false);
    private static final float f_303262_ = 40.0f;
    private static final int f_302549_;
    private final String f_303350_;
    private final int f_302810_;
    private final double f_303620_;
    private final ParticleEmission f_302969_;
    private final boolean f_303677_;
    private static final /* synthetic */ TrialSpawnerState[] $VALUES;

    public static TrialSpawnerState[] values() {
        return (TrialSpawnerState[])$VALUES.clone();
    }

    public static TrialSpawnerState valueOf(String p_313215_) {
        return Enum.valueOf(TrialSpawnerState.class, p_313215_);
    }

    private TrialSpawnerState(String p_309652_, int p_311553_, ParticleEmission p_309474_, double p_312481_, boolean p_310488_) {
        this.f_303350_ = p_309652_;
        this.f_302810_ = p_311553_;
        this.f_302969_ = p_309474_;
        this.f_303620_ = p_312481_;
        this.f_303677_ = p_310488_;
    }

    TrialSpawnerState m_308008_(BlockPos p_313024_, TrialSpawner p_310869_, ServerLevel p_313233_) {
        TrialSpawnerData $$3 = p_310869_.m_305472_();
        TrialSpawnerConfig $$4 = p_310869_.m_306177_();
        PlayerDetector $$5 = p_310869_.m_305791_();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case INACTIVE -> {
                if ($$3.m_307031_(p_310869_, p_313233_, WAITING_FOR_PLAYERS) == null) {
                    yield this;
                }
                yield WAITING_FOR_PLAYERS;
            }
            case WAITING_FOR_PLAYERS -> {
                if (!$$3.m_306286_()) {
                    yield INACTIVE;
                }
                $$3.m_304942_(p_313233_, p_313024_, $$5, $$4.f_302674_());
                if ($$3.f_303462_.isEmpty()) {
                    yield this;
                }
                yield ACTIVE;
            }
            case ACTIVE -> {
                if (!$$3.m_306286_()) {
                    yield INACTIVE;
                }
                int $$6 = $$3.m_305480_(p_313024_);
                $$3.m_304942_(p_313233_, p_313024_, $$5, $$4.f_302674_());
                if ($$3.m_305025_($$4, $$6)) {
                    if ($$3.m_307352_()) {
                        $$3.f_303712_ = p_313233_.m_46467_() + (long)$$4.f_302361_();
                        $$3.f_302930_ = 0;
                        $$3.f_302458_ = 0L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                } else if ($$3.m_305681_(p_313233_, $$4, $$6)) {
                    p_310869_.m_305361_(p_313233_, p_313024_).ifPresent(p_310382_ -> {
                        p_311122_.f_302440_.add((UUID)p_310382_);
                        ++p_311122_.f_302930_;
                        p_311122_.f_302458_ = p_313233_.m_46467_() + (long)$$4.f_303452_();
                        p_311122_.f_302396_.m_216829_(p_313233_.m_213780_()).ifPresent(p_310481_ -> {
                            p_309964_.f_303191_ = Optional.of((SpawnData)p_310481_.m_146310_());
                            p_310869_.m_306727_();
                        });
                    });
                }
                yield this;
            }
            case WAITING_FOR_REWARD_EJECTION -> {
                if ($$3.m_305761_(p_313233_, $$4, 40.0f)) {
                    p_313233_.m_247517_(null, p_313024_, SoundEvents.f_302837_, SoundSource.BLOCKS);
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case EJECTING_REWARD -> {
                if (!$$3.m_305594_(p_313233_, $$4, f_302549_)) {
                    yield this;
                }
                if ($$3.f_303462_.isEmpty()) {
                    p_313233_.m_247517_(null, p_313024_, SoundEvents.f_302735_, SoundSource.BLOCKS);
                    $$3.f_303012_ = Optional.empty();
                    yield COOLDOWN;
                }
                if ($$3.f_303012_.isEmpty()) {
                    $$3.f_303012_ = $$4.f_302816_().m_216820_(p_313233_.m_213780_());
                }
                $$3.f_303012_.ifPresent(p_310597_ -> p_310869_.m_306218_(p_313233_, p_313024_, (ResourceLocation)p_310597_));
                $$3.f_303462_.remove($$3.f_303462_.iterator().next());
                yield this;
            }
            case COOLDOWN -> {
                if ($$3.m_305171_(p_313233_)) {
                    $$3.f_303712_ = 0L;
                    yield WAITING_FOR_PLAYERS;
                }
                yield this;
            }
        };
    }

    public int m_304822_() {
        return this.f_302810_;
    }

    public double m_305120_() {
        return this.f_303620_;
    }

    public boolean m_307384_() {
        return this.f_303620_ >= 0.0;
    }

    public boolean m_306216_() {
        return this.f_303677_;
    }

    public void m_306816_(Level p_310333_, BlockPos p_312414_) {
        this.f_302969_.m_308004_(p_310333_, p_310333_.m_213780_(), p_312414_);
    }

    @Override
    public String m_7912_() {
        return this.f_303350_;
    }

    private static /* synthetic */ TrialSpawnerState[] m_305154_() {
        return new TrialSpawnerState[]{INACTIVE, WAITING_FOR_PLAYERS, ACTIVE, WAITING_FOR_REWARD_EJECTION, EJECTING_REWARD, COOLDOWN};
    }

    static {
        $VALUES = TrialSpawnerState.m_305154_();
        f_302549_ = Mth.m_14143_(30.0f);
    }

    static interface ParticleEmission {
        public static final ParticleEmission f_302687_ = (p_311158_, p_313095_, p_309870_) -> {};
        public static final ParticleEmission f_302488_ = (p_309392_, p_312550_, p_312505_) -> {
            if (p_312550_.m_188503_(2) == 0) {
                Vec3 $$3 = p_312505_.m_252807_().m_272010_(p_312550_, 0.9f);
                ParticleEmission.m_307767_(ParticleTypes.f_175834_, $$3, p_309392_);
            }
        };
        public static final ParticleEmission f_302540_ = (p_310259_, p_311563_, p_310144_) -> {
            Vec3 $$3 = p_310144_.m_252807_().m_272010_(p_311563_, 1.0f);
            ParticleEmission.m_307767_(ParticleTypes.f_123762_, $$3, p_310259_);
            ParticleEmission.m_307767_(ParticleTypes.f_123744_, $$3, p_310259_);
        };
        public static final ParticleEmission f_303781_ = (p_312500_, p_312202_, p_311828_) -> {
            Vec3 $$3 = p_311828_.m_252807_().m_272010_(p_312202_, 0.9f);
            if (p_312202_.m_188503_(3) == 0) {
                ParticleEmission.m_307767_(ParticleTypes.f_123762_, $$3, p_312500_);
            }
            if (p_312500_.m_46467_() % 20L == 0L) {
                Vec3 $$4 = p_311828_.m_252807_().m_82520_(0.0, 0.5, 0.0);
                int $$5 = p_312500_.m_213780_().m_188503_(4) + 20;
                for (int $$6 = 0; $$6 < $$5; ++$$6) {
                    ParticleEmission.m_307767_(ParticleTypes.f_123762_, $$4, p_312500_);
                }
            }
        };

        private static void m_307767_(SimpleParticleType p_311275_, Vec3 p_310309_, Level p_310163_) {
            p_310163_.m_7106_(p_311275_, p_310309_.m_7096_(), p_310309_.m_7098_(), p_310309_.m_7094_(), 0.0, 0.0, 0.0);
        }

        public void m_308004_(Level var1, RandomSource var2, BlockPos var3);
    }

    static class LightLevel {
        private static final int f_303256_ = 0;
        private static final int f_302741_ = 4;
        private static final int f_303097_ = 8;

        private LightLevel() {
        }
    }

    static class SpinningMob {
        private static final double f_303131_ = -1.0;
        private static final double f_303460_ = 200.0;
        private static final double f_302416_ = 1000.0;

        private SpinningMob() {
        }
    }
}

