/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ChunkStatus {
    public static final int f_187758_ = 8;
    private static final EnumSet<Heightmap.Types> f_62327_ = EnumSet.of(Heightmap.Types.OCEAN_FLOOR_WG, Heightmap.Types.WORLD_SURFACE_WG);
    public static final EnumSet<Heightmap.Types> f_62328_ = EnumSet.of(Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    private static final LoadingTask f_62329_ = (p_281194_, p_281195_, p_281196_, p_281197_, p_281198_, p_281199_) -> CompletableFuture.completedFuture(Either.left((Object)p_281199_));
    public static final ChunkStatus f_62314_ = ChunkStatus.m_62414_("empty", null, -1, f_62327_, ChunkType.PROTOCHUNK, (p_156307_, p_156308_, p_156309_, p_156310_, p_156311_) -> {});
    public static final ChunkStatus f_62315_ = ChunkStatus.m_280108_("structure_starts", f_62314_, 0, false, f_62327_, ChunkType.PROTOCHUNK, (p_309312_, p_309313_, p_309314_, p_309315_, p_309316_, p_309317_, p_309318_, p_309319_, p_309320_) -> {
        if (p_309314_.m_7654_().m_129910_().m_246337_().m_247749_()) {
            p_309315_.m_255037_(p_309314_.m_9598_(), p_309314_.m_7726_().m_255415_(), p_309314_.m_215010_(), p_309320_, p_309316_);
        }
        p_309314_.m_196557_(p_309320_);
        return CompletableFuture.completedFuture(Either.left((Object)p_309320_));
    }, (p_281209_, p_281210_, p_281211_, p_281212_, p_281213_, p_281214_) -> {
        p_281210_.m_196557_(p_281214_);
        return CompletableFuture.completedFuture(Either.left((Object)p_281214_));
    });
    public static final ChunkStatus f_62316_ = ChunkStatus.m_62414_("structure_references", f_62315_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_196843_, p_196844_, p_196845_, p_196846_, p_196847_) -> {
        WorldGenRegion $$5 = new WorldGenRegion(p_196844_, p_196846_, p_196843_, -1);
        p_196845_.m_223076_($$5, p_196844_.m_215010_().m_220468_($$5), p_196847_);
    });
    public static final ChunkStatus f_62317_ = ChunkStatus.m_62399_("biomes", f_62316_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_281200_, p_281201_, p_281202_, p_281203_, p_281204_, p_281205_, p_281206_, p_281207_, p_281208_) -> {
        WorldGenRegion $$9 = new WorldGenRegion(p_281202_, p_281207_, p_281200_, -1);
        return p_281203_.m_213908_(p_281201_, p_281202_.m_7726_().m_214994_(), Blender.m_190202_($$9), p_281202_.m_215010_().m_220468_($$9), p_281208_).thenApply(p_281193_ -> Either.left((Object)p_281193_));
    });
    public static final ChunkStatus f_62318_ = ChunkStatus.m_62399_("noise", f_62317_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_281161_, p_281162_, p_281163_, p_281164_, p_281165_, p_281166_, p_281167_, p_281168_, p_281169_) -> {
        WorldGenRegion $$9 = new WorldGenRegion(p_281163_, p_281168_, p_281161_, 0);
        return p_281164_.m_213974_(p_281162_, Blender.m_190202_($$9), p_281163_.m_7726_().m_214994_(), p_281163_.m_215010_().m_220468_($$9), p_281169_).thenApply(p_281218_ -> {
            ProtoChunk $$1;
            BelowZeroRetrogen $$2;
            if (p_281218_ instanceof ProtoChunk && ($$2 = ($$1 = (ProtoChunk)p_281218_).m_183376_()) != null) {
                BelowZeroRetrogen.m_188474_($$1);
                if ($$2.m_198220_()) {
                    $$2.m_198221_($$1);
                }
            }
            return Either.left((Object)p_281218_);
        });
    });
    public static final ChunkStatus f_62319_ = ChunkStatus.m_62414_("surface", f_62318_, 8, f_62327_, ChunkType.PROTOCHUNK, (p_156247_, p_156248_, p_156249_, p_156250_, p_156251_) -> {
        WorldGenRegion $$5 = new WorldGenRegion(p_156248_, p_156250_, p_156247_, 0);
        p_156249_.m_214194_($$5, p_156248_.m_215010_().m_220468_($$5), p_156248_.m_7726_().m_214994_(), p_156251_);
    });
    public static final ChunkStatus f_62320_ = ChunkStatus.m_62414_("carvers", f_62319_, 8, f_62328_, ChunkType.PROTOCHUNK, (p_309307_, p_309308_, p_309309_, p_309310_, p_309311_) -> {
        WorldGenRegion $$5 = new WorldGenRegion(p_309308_, p_309310_, p_309307_, 0);
        if (p_309311_ instanceof ProtoChunk) {
            ProtoChunk $$6 = (ProtoChunk)p_309311_;
            Blender.m_197034_($$5, $$6);
        }
        p_309309_.m_213679_($$5, p_309308_.m_7328_(), p_309308_.m_7726_().m_214994_(), p_309308_.m_7062_(), p_309308_.m_215010_().m_220468_($$5), p_309311_, GenerationStep.Carving.AIR);
    });
    public static final ChunkStatus f_62322_ = ChunkStatus.m_62414_("features", f_62320_, 8, f_62328_, ChunkType.PROTOCHUNK, (p_281188_, p_281189_, p_281190_, p_281191_, p_281192_) -> {
        Heightmap.m_64256_(p_281192_, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
        WorldGenRegion $$5 = new WorldGenRegion(p_281189_, p_281191_, p_281188_, 1);
        p_281190_.m_213609_($$5, p_281192_, p_281189_.m_215010_().m_220468_($$5));
        Blender.m_197031_($$5, p_281192_);
    });
    public static final ChunkStatus f_279614_ = ChunkStatus.m_280108_("initialize_light", f_62322_, 0, false, f_62328_, ChunkType.PROTOCHUNK, (p_281179_, p_281180_, p_281181_, p_281182_, p_281183_, p_281184_, p_281185_, p_281186_, p_281187_) -> ChunkStatus.m_280141_(p_281184_, p_281187_), (p_281155_, p_281156_, p_281157_, p_281158_, p_281159_, p_281160_) -> ChunkStatus.m_280141_(p_281158_, p_281160_));
    public static final ChunkStatus f_62323_ = ChunkStatus.m_280108_("light", f_279614_, 1, true, f_62328_, ChunkType.PROTOCHUNK, (p_284904_, p_284905_, p_284906_, p_284907_, p_284908_, p_284909_, p_284910_, p_284911_, p_284912_) -> ChunkStatus.m_284159_(p_284909_, p_284912_), (p_284898_, p_284899_, p_284900_, p_284901_, p_284902_, p_284903_) -> ChunkStatus.m_284159_(p_284901_, p_284903_));
    public static final ChunkStatus f_62324_ = ChunkStatus.m_62414_("spawn", f_62323_, 0, f_62328_, ChunkType.PROTOCHUNK, (p_196758_, p_196759_, p_196760_, p_196761_, p_196762_) -> {
        if (!p_196762_.m_187679_()) {
            p_196760_.m_6929_(new WorldGenRegion(p_196759_, p_196761_, p_196758_, -1));
        }
    });
    public static final ChunkStatus f_62326_ = ChunkStatus.m_280108_("full", f_62324_, 0, false, f_62328_, ChunkType.LEVELCHUNK, (p_223267_, p_223268_, p_223269_, p_223270_, p_223271_, p_223272_, p_223273_, p_223274_, p_223275_) -> (CompletableFuture)p_223273_.apply(p_223275_), (p_223260_, p_223261_, p_223262_, p_223263_, p_223264_, p_223265_) -> (CompletableFuture)p_223264_.apply(p_223265_));
    private static final List<ChunkStatus> f_62330_ = ImmutableList.of((Object)f_62326_, (Object)f_279614_, (Object)f_62320_, (Object)f_62317_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object)f_62315_, (Object[])new ChunkStatus[0]);
    private static final IntList f_62331_ = (IntList)Util.m_137469_(new IntArrayList(ChunkStatus.m_62349_().size()), p_283066_ -> {
        int $$1 = 0;
        for (int $$2 = ChunkStatus.m_62349_().size() - 1; $$2 >= 0; --$$2) {
            while ($$1 + 1 < f_62330_.size() && $$2 <= f_62330_.get($$1 + 1).m_62445_()) {
                ++$$1;
            }
            p_283066_.add(0, $$1);
        }
    });
    private final int f_62333_;
    private final ChunkStatus f_62334_;
    private final GenerationTask f_62335_;
    private final LoadingTask f_62336_;
    private final int f_62337_;
    private final boolean f_279602_;
    private final ChunkType f_62338_;
    private final EnumSet<Heightmap.Types> f_62339_;

    private static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_280141_(ThreadedLevelLightEngine p_282288_, ChunkAccess p_282906_) {
        p_282906_.m_284190_();
        ((ProtoChunk)p_282906_).m_63209_(p_282288_);
        boolean $$2 = ChunkStatus.m_284462_(p_282906_);
        return p_282288_.m_284138_(p_282906_, $$2).thenApply(Either::left);
    }

    private static CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_284159_(ThreadedLevelLightEngine p_285039_, ChunkAccess p_285316_) {
        boolean $$2 = ChunkStatus.m_284462_(p_285316_);
        return p_285039_.m_9353_(p_285316_, $$2).thenApply(Either::left);
    }

    private static ChunkStatus m_62414_(String p_62415_, @Nullable ChunkStatus p_62416_, int p_62417_, EnumSet<Heightmap.Types> p_62418_, ChunkType p_62419_, SimpleGenerationTask p_62420_) {
        return ChunkStatus.m_62399_(p_62415_, p_62416_, p_62417_, p_62418_, p_62419_, p_62420_);
    }

    private static ChunkStatus m_62399_(String p_62400_, @Nullable ChunkStatus p_62401_, int p_62402_, EnumSet<Heightmap.Types> p_62403_, ChunkType p_62404_, GenerationTask p_62405_) {
        return ChunkStatus.m_280108_(p_62400_, p_62401_, p_62402_, false, p_62403_, p_62404_, p_62405_, f_62329_);
    }

    private static ChunkStatus m_280108_(String p_282817_, @Nullable ChunkStatus p_282644_, int p_281535_, boolean p_282329_, EnumSet<Heightmap.Types> p_281310_, ChunkType p_281968_, GenerationTask p_283654_, LoadingTask p_282175_) {
        return Registry.m_122961_(BuiltInRegistries.f_256940_, p_282817_, new ChunkStatus(p_282644_, p_281535_, p_282329_, p_281310_, p_281968_, p_283654_, p_282175_));
    }

    public static List<ChunkStatus> m_62349_() {
        ChunkStatus $$1;
        ArrayList $$0 = Lists.newArrayList();
        for ($$1 = f_62326_; $$1.m_62482_() != $$1; $$1 = $$1.m_62482_()) {
            $$0.add($$1);
        }
        $$0.add($$1);
        Collections.reverse($$0);
        return $$0;
    }

    private static boolean m_284462_(ChunkAccess p_285378_) {
        return p_285378_.m_6415_().m_62427_(f_62323_) && p_285378_.m_6332_();
    }

    public static ChunkStatus m_156185_(int p_156186_) {
        if (p_156186_ >= f_62330_.size()) {
            return f_62314_;
        }
        if (p_156186_ < 0) {
            return f_62326_;
        }
        return f_62330_.get(p_156186_);
    }

    public static int m_62421_() {
        return f_62330_.size();
    }

    public static int m_62370_(ChunkStatus p_62371_) {
        return f_62331_.getInt(p_62371_.m_62445_());
    }

    ChunkStatus(@Nullable ChunkStatus p_289640_, int p_289655_, boolean p_289657_, EnumSet<Heightmap.Types> p_289662_, ChunkType p_289652_, GenerationTask p_289679_, LoadingTask p_289646_) {
        this.f_62334_ = p_289640_ == null ? this : p_289640_;
        this.f_62335_ = p_289679_;
        this.f_62336_ = p_289646_;
        this.f_62337_ = p_289655_;
        this.f_279602_ = p_289657_;
        this.f_62338_ = p_289652_;
        this.f_62339_ = p_289662_;
        this.f_62333_ = p_289640_ == null ? 0 : p_289640_.m_62445_() + 1;
    }

    public int m_62445_() {
        return this.f_62333_;
    }

    public ChunkStatus m_62482_() {
        return this.f_62334_;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_280308_(Executor p_283276_, ServerLevel p_281420_, ChunkGenerator p_281836_, StructureTemplateManager p_281305_, ThreadedLevelLightEngine p_282570_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_283114_, List<ChunkAccess> p_282723_) {
        ChunkAccess $$7 = p_282723_.get(p_282723_.size() / 2);
        ProfiledDuration $$8 = JvmProfiler.f_185340_.m_183559_($$7.m_7697_(), p_281420_.m_46472_(), this.toString());
        return this.f_62335_.m_214024_(this, p_283276_, p_281420_, p_281836_, p_281305_, p_282570_, p_283114_, p_282723_, $$7).thenApply(p_281217_ -> {
            p_281217_.ifLeft(p_290029_ -> {
                ProtoChunk $$1;
                if (p_290029_ instanceof ProtoChunk && !($$1 = (ProtoChunk)p_290029_).m_6415_().m_62427_(this)) {
                    $$1.m_7150_(this);
                }
            });
            if ($$8 != null) {
                $$8.m_185413_();
            }
            return p_281217_;
        });
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_223244_(ServerLevel p_223245_, StructureTemplateManager p_223246_, ThreadedLevelLightEngine p_223247_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_223248_, ChunkAccess p_223249_) {
        return this.f_62336_.m_223381_(this, p_223245_, p_223246_, p_223247_, p_223248_, p_223249_);
    }

    public int m_62488_() {
        return this.f_62337_;
    }

    public boolean m_280148_() {
        return this.f_279602_;
    }

    public ChunkType m_62494_() {
        return this.f_62338_;
    }

    public static ChunkStatus m_62397_(String p_62398_) {
        return BuiltInRegistries.f_256940_.m_7745_(ResourceLocation.m_135820_(p_62398_));
    }

    public EnumSet<Heightmap.Types> m_62500_() {
        return this.f_62339_;
    }

    public boolean m_62427_(ChunkStatus p_62428_) {
        return this.m_62445_() >= p_62428_.m_62445_();
    }

    public String toString() {
        return BuiltInRegistries.f_256940_.m_7981_(this).toString();
    }

    public static final class ChunkType
    extends Enum<ChunkType> {
        public static final /* enum */ ChunkType PROTOCHUNK = new ChunkType();
        public static final /* enum */ ChunkType LEVELCHUNK = new ChunkType();
        private static final /* synthetic */ ChunkType[] $VALUES;

        public static ChunkType[] values() {
            return (ChunkType[])$VALUES.clone();
        }

        public static ChunkType valueOf(String p_62520_) {
            return Enum.valueOf(ChunkType.class, p_62520_);
        }

        private static /* synthetic */ ChunkType[] m_156312_() {
            return new ChunkType[]{PROTOCHUNK, LEVELCHUNK};
        }

        static {
            $VALUES = ChunkType.m_156312_();
        }
    }

    static interface GenerationTask {
        public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_214024_(ChunkStatus var1, Executor var2, ServerLevel var3, ChunkGenerator var4, StructureTemplateManager var5, ThreadedLevelLightEngine var6, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> var7, List<ChunkAccess> var8, ChunkAccess var9);
    }

    static interface LoadingTask {
        public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_223381_(ChunkStatus var1, ServerLevel var2, StructureTemplateManager var3, ThreadedLevelLightEngine var4, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> var5, ChunkAccess var6);
    }

    static interface SimpleGenerationTask
    extends GenerationTask {
        @Override
        default public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_214024_(ChunkStatus p_281382_, Executor p_283285_, ServerLevel p_283408_, ChunkGenerator p_282263_, StructureTemplateManager p_282374_, ThreadedLevelLightEngine p_281701_, Function<ChunkAccess, CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>>> p_282473_, List<ChunkAccess> p_282316_, ChunkAccess p_281861_) {
            this.m_156322_(p_281382_, p_283408_, p_282263_, p_282316_, p_281861_);
            return CompletableFuture.completedFuture(Either.left((Object)p_281861_));
        }

        public void m_156322_(ChunkStatus var1, ServerLevel var2, ChunkGenerator var3, List<ChunkAccess> var4, ChunkAccess var5);
    }
}

