/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String f_202311_ = "Data";
    private static final PathMatcher f_289833_ = p_296993_ -> false;
    public static final String f_289824_ = "allowed_symlinks.txt";
    private static final int f_302867_ = 0x6400000;
    private final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;
    private final DirectoryValidator f_289816_;

    public LevelStorageSource(Path p_289985_, Path p_289978_, DirectoryValidator p_289922_, DataFixer p_289940_) {
        this.f_78196_ = p_289940_;
        try {
            FileUtil.m_257659_(p_289985_);
        }
        catch (IOException $$4) {
            throw new UncheckedIOException($$4);
        }
        this.f_78194_ = p_289985_;
        this.f_78195_ = p_289978_;
        this.f_289816_ = p_289922_;
    }

    public static DirectoryValidator m_289881_(Path p_289968_) {
        if (Files.exists(p_289968_, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader $$1 = Files.newBufferedReader(p_289968_);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.m_289888_($$1));
                    if ($$1 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if ($$1 != null) {
                            try {
                                $$1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception $$2) {
                        f_78191_.error("Failed to parse {}, disallowing all symbolic links", (Object)f_289824_, (Object)$$2);
                    }
                }
                $$1.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(f_289833_);
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        DirectoryValidator $$1 = LevelStorageSource.m_289881_(p_78243_.resolve(f_289824_));
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), $$1, DataFixers.m_14512_());
    }

    public static WorldDataConfiguration m_245610_(Dynamic<?> p_250884_) {
        return WorldDataConfiguration.f_244621_.parse(p_250884_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(WorldDataConfiguration.f_244649_);
    }

    public static WorldLoader.PackConfig m_305246_(Dynamic<?> p_312675_, PackRepository p_309764_, boolean p_310223_) {
        return new WorldLoader.PackConfig(p_309764_, LevelStorageSource.m_245610_(p_312675_), p_310223_, false);
    }

    public static LevelDataAndDimensions m_306102_(Dynamic<?> p_311362_, WorldDataConfiguration p_311014_, Registry<LevelStem> p_311619_, RegistryAccess.Frozen p_313214_) {
        Dynamic<?> $$4 = LevelStorageSource.m_304791_(p_311362_, p_313214_);
        Dynamic $$5 = $$4.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings $$6 = (WorldGenSettings)WorldGenSettings.f_64600_.parse($$5).getOrThrow(false, Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0)));
        LevelSettings $$7 = LevelSettings.m_46924_($$4, p_311014_);
        WorldDimensions.Complete $$8 = $$6.f_64605_().m_245300_(p_311619_);
        Lifecycle $$9 = $$8.m_245945_().add(p_313214_.m_211816_());
        PrimaryLevelData $$10 = PrimaryLevelData.m_78530_($$4, $$7, $$8.f_244634_(), $$6.f_243992_(), $$9);
        return new LevelDataAndDimensions($$10, $$8);
    }

    private static <T> Dynamic<T> m_304791_(Dynamic<T> p_310020_, RegistryAccess.Frozen p_310921_) {
        RegistryOps $$2 = RegistryOps.m_255058_(p_310020_.getOps(), p_310921_);
        return new Dynamic($$2, p_310020_.getValue());
    }

    public String m_164909_() {
        return "Anvil";
    }

    public LevelCandidates m_230833_() throws LevelStorageException {
        LevelCandidates levelCandidates;
        block9: {
            if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
                throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
            }
            Stream<Path> $$0 = Files.list(this.f_78194_);
            try {
                List<LevelDirectory> $$1 = $$0.filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.m_230858_(), new LinkOption[0]) || Files.isRegularFile(p_230835_.m_230859_(), new LinkOption[0])).toList();
                levelCandidates = new LevelCandidates($$1);
                if ($$0 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$0 != null) {
                        try {
                            $$0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$2) {
                    throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
                }
            }
            $$0.close();
        }
        return levelCandidates;
    }

    public CompletableFuture<List<LevelSummary>> m_230813_(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> $$1 = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.f_230840_.size());
        for (LevelDirectory $$2 : p_230814_.f_230840_) {
            $$1.add(CompletableFuture.supplyAsync(() -> {
                try {
                    boolean $$1 = DirectoryLock.m_13642_($$2.f_230850_());
                }
                catch (Exception $$2) {
                    f_78191_.warn("Failed to read {} lock", (Object)$$2.f_230850_(), (Object)$$2);
                    return null;
                }
                try {
                    void $$3;
                    return this.m_306052_($$2, (boolean)$$3);
                }
                catch (OutOfMemoryError $$4) {
                    MemoryReserve.m_182328_();
                    System.gc();
                    String $$5 = "Ran out of memory trying to read summary of world folder \"" + $$2.m_230853_() + "\"";
                    f_78191_.error(LogUtils.FATAL_MARKER, $$5);
                    OutOfMemoryError $$6 = new OutOfMemoryError("Ran out of memory reading level data");
                    $$6.initCause($$4);
                    CrashReport $$7 = CrashReport.m_127521_($$6, $$5);
                    CrashReportCategory $$8 = $$7.m_127514_("World details");
                    $$8.m_128159_("Folder Name", $$2.m_230853_());
                    try {
                        long $$9 = Files.size($$2.m_230858_());
                        $$8.m_128159_("level.dat size", $$9);
                    }
                    catch (IOException $$10) {
                        $$8.m_128162_("level.dat size", $$10);
                    }
                    throw new ReportedException($$7);
                }
            }, Util.m_183991_()));
        }
        return Util.m_214684_($$1).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int m_78265_() {
        return 19133;
    }

    static CompoundTag m_305304_(Path p_312857_) throws IOException {
        return NbtIo.m_128939_(p_312857_, NbtAccounter.m_301677_(0x6400000L));
    }

    static Dynamic<?> m_306158_(Path p_309458_, DataFixer p_312702_) throws IOException {
        CompoundTag $$2 = LevelStorageSource.m_305304_(p_309458_);
        CompoundTag $$3 = $$2.m_128469_(f_202311_);
        int $$4 = NbtUtils.m_264487_($$3, -1);
        Dynamic $$5 = DataFixTypes.LEVEL.m_264140_(p_312702_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$3), $$4);
        Dynamic $$6 = $$5.get("Player").orElseEmptyMap();
        Dynamic $$7 = DataFixTypes.PLAYER.m_264140_(p_312702_, $$6, $$4);
        $$5 = $$5.set("Player", $$7);
        Dynamic $$8 = $$5.get("WorldGenSettings").orElseEmptyMap();
        Dynamic $$9 = DataFixTypes.WORLD_GEN_SETTINGS.m_264140_(p_312702_, $$8, $$4);
        $$5 = $$5.set("WorldGenSettings", $$9);
        return $$5;
    }

    private LevelSummary m_306052_(LevelDirectory p_313112_, boolean p_312081_) {
        Path $$2 = p_313112_.m_230858_();
        if (Files.exists($$2, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> $$3;
                if (Files.isSymbolicLink($$2) && !($$3 = this.f_289816_.m_295373_($$2)).isEmpty()) {
                    f_78191_.warn("{}", (Object)ContentValidationException.m_289907_($$2, $$3));
                    return new LevelSummary.SymlinkLevelSummary(p_313112_.m_230853_(), p_313112_.m_230860_());
                }
                Tag $$4 = LevelStorageSource.m_230836_($$2);
                if ($$4 instanceof CompoundTag) {
                    CompoundTag $$5 = (CompoundTag)$$4;
                    CompoundTag $$6 = $$5.m_128469_(f_202311_);
                    int $$7 = NbtUtils.m_264487_($$6, -1);
                    Dynamic $$8 = DataFixTypes.LEVEL.m_264140_(this.f_78196_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$6), $$7);
                    return this.m_306201_($$8, p_313112_, p_312081_);
                }
                f_78191_.warn("Invalid root tag in {}", (Object)$$2);
            }
            catch (Exception $$9) {
                f_78191_.error("Exception reading {}", (Object)$$2, (Object)$$9);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(p_313112_.m_230853_(), p_313112_.m_230860_(), LevelStorageSource.m_307617_(p_313112_));
    }

    private static long m_307617_(LevelDirectory p_311230_) {
        Instant $$1 = LevelStorageSource.m_306357_(p_311230_.m_230858_());
        if ($$1 == null) {
            $$1 = LevelStorageSource.m_306357_(p_311230_.m_230859_());
        }
        return $$1 == null ? -1L : $$1.toEpochMilli();
    }

    @Nullable
    static Instant m_306357_(Path p_313101_) {
        try {
            return Files.getLastModifiedTime(p_313101_, new LinkOption[0]).toInstant();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    LevelSummary m_306201_(Dynamic<?> p_310955_, LevelDirectory p_309842_, boolean p_310644_) {
        LevelVersion $$3 = LevelVersion.m_78390_(p_310955_);
        int $$4 = $$3.m_78389_();
        if ($$4 == 19132 || $$4 == 19133) {
            boolean $$5 = $$4 != this.m_78265_();
            Path $$6 = p_309842_.m_230860_();
            WorldDataConfiguration $$7 = LevelStorageSource.m_245610_(p_310955_);
            LevelSettings $$8 = LevelSettings.m_46924_(p_310955_, $$7);
            FeatureFlagSet $$9 = LevelStorageSource.m_247076_(p_310955_);
            boolean $$10 = FeatureFlags.m_246811_($$9);
            return new LevelSummary($$8, $$3, p_309842_.m_230853_(), $$5, p_310644_, $$10, $$6);
        }
        throw new NbtFormatException("Unknown data version: " + Integer.toHexString($$4));
    }

    private static FeatureFlagSet m_247076_(Dynamic<?> p_249466_) {
        Set<ResourceLocation> $$1 = p_249466_.get("enabled_features").asStream().flatMap(p_248492_ -> p_248492_.asString().result().map(ResourceLocation::m_135820_).stream()).collect(Collectors.toSet());
        return FeatureFlags.f_244280_.m_247021_($$1, p_248503_ -> {});
    }

    @Nullable
    private static Tag m_230836_(Path p_230837_) throws IOException {
        SkipFields $$1 = new SkipFields(new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings"));
        NbtIo.m_202487_(p_230837_, $$1, NbtAccounter.m_301677_(0x6400000L));
        return $$1.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path $$1 = this.m_289874_(p_78241_);
            Files.createDirectory($$1, new FileAttribute[0]);
            Files.deleteIfExists($$1);
            return true;
        }
        catch (IOException $$2) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        try {
            return Files.isDirectory(this.m_289874_(p_78256_), new LinkOption[0]);
        }
        catch (InvalidPathException $$1) {
            return false;
        }
    }

    public Path m_289874_(String p_289974_) {
        return this.f_78194_.resolve(p_289974_);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_289864_(String p_289980_) throws IOException, ContentValidationException {
        Path $$1 = this.m_289874_(p_289980_);
        List<ForbiddenSymlinkInfo> $$2 = this.f_289816_.m_294444_($$1, true);
        if (!$$2.isEmpty()) {
            throw new ContentValidationException($$1, $$2);
        }
        return new LevelStorageAccess(p_289980_, $$1);
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        Path $$1 = this.m_289874_(p_78261_);
        return new LevelStorageAccess(p_78261_, $$1);
    }

    public DirectoryValidator m_289863_() {
        return this.f_289816_;
    }

    public record LevelCandidates(List<LevelDirectory> f_230840_) implements Iterable<LevelDirectory>
    {
        public boolean m_230843_() {
            return this.f_230840_.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.f_230840_.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final boolean equals(Object p_230846_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this, p_230846_);
        }
    }

    public record LevelDirectory(Path f_230850_) {
        public String m_230853_() {
            return this.f_230850_.getFileName().toString();
        }

        public Path m_230858_() {
            return this.m_230854_(LevelResource.f_78178_);
        }

        public Path m_230859_() {
            return this.m_230854_(LevelResource.f_230800_);
        }

        public Path m_230856_(LocalDateTime p_230857_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_corrupted_" + p_230857_.format(f_78192_));
        }

        public Path m_305605_(LocalDateTime p_310027_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_raw_" + p_310027_.format(f_78192_));
        }

        public Path m_230860_() {
            return this.m_230854_(LevelResource.f_230801_);
        }

        public Path m_230861_() {
            return this.m_230854_(LevelResource.f_230802_);
        }

        public Path m_230854_(LevelResource p_230855_) {
            return this.f_230850_.resolve(p_230855_.m_78187_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final boolean equals(Object p_230863_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this, p_230863_);
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        final LevelDirectory f_230867_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        LevelStorageAccess(String p_289967_, Path p_289988_) throws IOException {
            this.f_78272_ = p_289967_;
            this.f_230867_ = new LevelDirectory(p_289988_);
            this.f_78270_ = DirectoryLock.m_13640_(p_289988_);
        }

        public void m_306156_() {
            try {
                this.close();
            }
            catch (IOException $$0) {
                f_78191_.warn("Failed to unlock access to level {}", (Object)this.m_78277_(), (Object)$$0);
            }
        }

        public LevelStorageSource m_295711_() {
            return LevelStorageSource.this;
        }

        public LevelDirectory m_306248_() {
            return this.f_230867_;
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, this.f_230867_::m_230854_);
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, this.f_230867_.f_230850_());
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        public LevelSummary m_78308_(Dynamic<?> p_310283_) {
            this.m_78313_();
            return LevelStorageSource.this.m_306201_(p_310283_, this.f_230867_, false);
        }

        public Dynamic<?> m_307464_() throws IOException {
            return this.m_246049_(false);
        }

        public Dynamic<?> m_305112_() throws IOException {
            return this.m_246049_(true);
        }

        private Dynamic<?> m_246049_(boolean p_310699_) throws IOException {
            this.m_78313_();
            return LevelStorageSource.m_306158_(p_310699_ ? this.f_230867_.m_230859_() : this.f_230867_.m_230858_(), LevelStorageSource.this.f_78196_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            CompoundTag $$3 = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag $$4 = new CompoundTag();
            $$4.m_128365_(LevelStorageSource.f_202311_, $$3);
            this.m_305059_($$4);
        }

        private void m_305059_(CompoundTag p_312575_) {
            Path $$1 = this.f_230867_.f_230850_();
            try {
                Path $$2 = Files.createTempFile($$1, "level", ".dat", new FileAttribute[0]);
                NbtIo.m_128944_(p_312575_, $$2);
                Path $$3 = this.f_230867_.m_230859_();
                Path $$4 = this.f_230867_.m_230858_();
                Util.m_137505_($$4, $$2, $$3);
            }
            catch (Exception $$5) {
                f_78191_.error("Failed to save level {}", (Object)$$1, (Object)$$5);
            }
        }

        public Optional<Path> m_182514_() {
            if (!this.f_78270_.m_13639_()) {
                return Optional.empty();
            }
            return Optional.of(this.f_230867_.m_230860_());
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path $$0 = this.f_230867_.m_230861_();
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int $$1 = 1; $$1 <= 5; ++$$1) {
                f_78191_.info("Attempt {}...", (Object)$$1);
                try {
                    Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals($$0)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, @Nullable IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_230867_.f_230850_())) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists($$0);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, @Nullable IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException $$2) {
                    if ($$1 < 5) {
                        f_78191_.warn("Failed to delete {}", (Object)this.f_230867_.f_230850_(), (Object)$$2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw $$2;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_306294_(p_313219_ -> p_313219_.m_128359_("LevelName", p_78298_.trim()));
        }

        public void m_307222_(String p_309798_) throws IOException {
            this.m_306294_(p_312160_ -> {
                p_312160_.m_128359_("LevelName", p_309798_.trim());
                p_312160_.m_128473_("Player");
            });
        }

        private void m_306294_(Consumer<CompoundTag> p_310066_) throws IOException {
            this.m_78313_();
            CompoundTag $$1 = LevelStorageSource.m_305304_(this.f_230867_.m_230858_());
            p_310066_.accept($$1.m_128469_(LevelStorageSource.f_202311_));
            this.m_305059_($$1);
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String $$0 = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path $$1 = LevelStorageSource.this.m_78262_();
            try {
                FileUtil.m_257659_($$1);
            }
            catch (IOException $$2) {
                throw new RuntimeException($$2);
            }
            Path $$3 = $$1.resolve(FileUtil.m_133730_($$1, $$0, ".zip"));
            try (final ZipOutputStream $$4 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream($$3, new OpenOption[0])));){
                final Path $$5 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String $$2 = $$5.resolve(LevelStorageAccess.this.f_230867_.f_230850_().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry $$3 = new ZipEntry($$2);
                        $$4.putNextEntry($$3);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)$$4);
                        $$4.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size($$3);
        }

        public boolean m_306456_() {
            return Files.exists(this.f_230867_.m_230858_(), new LinkOption[0]) || Files.exists(this.f_230867_.m_230859_(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }

        public boolean m_305486_() {
            return Util.m_212224_(this.f_230867_.m_230858_(), this.f_230867_.m_230859_(), this.f_230867_.m_230856_(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant m_306206_(boolean p_311251_) {
            return LevelStorageSource.m_306357_(p_311251_ ? this.f_230867_.m_230859_() : this.f_230867_.m_230858_());
        }
    }
}

