/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger f_78426_ = LogUtils.getLogger();
    private final File f_78427_;
    protected final DataFixer f_78425_;

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.f_78425_ = p_78431_;
        this.f_78427_ = p_78430_.m_78283_(LevelResource.f_78176_).toFile();
        this.f_78427_.mkdirs();
    }

    public void m_78433_(Player p_78434_) {
        try {
            CompoundTag $$1 = p_78434_.m_20240_(new CompoundTag());
            Path $$2 = this.f_78427_.toPath();
            Path $$3 = Files.createTempFile($$2, p_78434_.m_20149_() + "-", ".dat", new FileAttribute[0]);
            NbtIo.m_128944_($$1, $$3);
            Path $$4 = $$2.resolve(p_78434_.m_20149_() + ".dat");
            Path $$5 = $$2.resolve(p_78434_.m_20149_() + ".dat_old");
            Util.m_137505_($$4, $$3, $$5);
        }
        catch (Exception $$6) {
            f_78426_.warn("Failed to save player data for {}", (Object)p_78434_.m_7755_().getString());
        }
    }

    @Nullable
    public CompoundTag m_78435_(Player p_78436_) {
        CompoundTag $$1 = null;
        try {
            File $$2 = new File(this.f_78427_, p_78436_.m_20149_() + ".dat");
            if ($$2.exists() && $$2.isFile()) {
                $$1 = NbtIo.m_128939_($$2.toPath(), NbtAccounter.m_301669_());
            }
        }
        catch (Exception $$3) {
            f_78426_.warn("Failed to load player data for {}", (Object)p_78436_.m_7755_().getString());
        }
        if ($$1 != null) {
            int $$4 = NbtUtils.m_264487_($$1, -1);
            $$1 = DataFixTypes.PLAYER.m_264218_(this.f_78425_, $$1, $$4);
            p_78436_.m_20258_($$1);
        }
        return $$1;
    }

    public String[] m_78432_() {
        String[] $$0 = this.f_78427_.list();
        if ($$0 == null) {
            $$0 = new String[]{};
        }
        for (int $$1 = 0; $$1 < $$0.length; ++$$1) {
            if (!$$0[$$1].endsWith(".dat")) continue;
            $$0[$$1] = $$0[$$1].substring(0, $$0[$$1].length() - 4);
        }
        return $$0;
    }
}

