/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.I18NParser;
import net.minecraftforge.fml.IBindingsProvider;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.loading.FMLLoader;

public class Bindings {
    private static final Bindings INSTANCE = new Bindings();
    private final IBindingsProvider provider;

    private Bindings() {
        ArrayList<IBindingsProvider> providers = new ArrayList<IBindingsProvider>(1);
        Iterator<IBindingsProvider> itr = ServiceLoader.load(FMLLoader.getGameLayer(), IBindingsProvider.class).iterator();
        while (itr.hasNext()) {
            try {
                providers.add(itr.next());
            }
            catch (ServiceConfigurationError sce) {
                sce.printStackTrace();
            }
        }
        if (providers.size() != 1) {
            throw new IllegalStateException("Could not find bindings provider: " + providers);
        }
        this.provider = (IBindingsProvider)providers.get(0);
    }

    public static Supplier<IEventBus> getForgeBus() {
        return Bindings.INSTANCE.provider.getForgeBusSupplier();
    }

    public static Supplier<I18NParser> getMessageParser() {
        return Bindings.INSTANCE.provider.getMessageParser();
    }

    public static Supplier<IConfigEvent.ConfigConfig> getConfigConfiguration() {
        return Bindings.INSTANCE.provider.getConfigConfiguration();
    }
}

