/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ClasspathLocator
extends AbstractModProvider
implements IModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Attributes.Name MOD_TYPE = new Attributes.Name("FMLModType");

    public String name() {
        return "classpath";
    }

    public List<IModLocator.ModFileOrException> scanMods() {
        ClassLoader cl = this.getClass().getClassLoader();
        Path minecraft = ClasspathLocator.getPathFromResource(cl, "net/minecraft/obfuscate/DontObfuscate.class");
        HashSet<Path> claimed = new HashSet<Path>();
        List<URL> tomls = this.getUrls(cl, "META-INF/mods.toml");
        for (URL uRL : tomls) {
            Path path = ClasspathLocator.getPath(uRL, "META-INF/mods.toml");
            if (path.equals(minecraft)) continue;
            claimed.add(path);
        }
        List<URL> manifests = this.getUrls(cl, "META-INF/MANIFEST.MF");
        for (URL url : manifests) {
            Path path = ClasspathLocator.getPath(url, "META-INF/MANIFEST.MF");
            if (claimed.contains(path)) continue;
            try {
                InputStream is = url.openStream();
                try {
                    Manifest mf = new Manifest(is);
                    String type = mf.getMainAttributes().getValue(MOD_TYPE);
                    if (type == null) continue;
                    claimed.add(path);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn(LogMarkers.SCAN, "Error reading manifest from: " + url, (Throwable)e);
            }
        }
        ArrayList<IModLocator.ModFileOrException> arrayList = new ArrayList<IModLocator.ModFileOrException>();
        for (Path path : claimed) {
            if (ModDirTransformerDiscoverer.isServiceProvider(path)) continue;
            arrayList.add(this.createMod(path));
        }
        return arrayList;
    }

    private List<URL> getUrls(ClassLoader cl, String resource) {
        try {
            ArrayList<URL> lst = Collections.list(cl.getResources(resource));
            if (LOGGER.isDebugEnabled(LogMarkers.SCAN)) {
                Collections.sort(lst, (a, b) -> a.toString().compareTo(b.toString()));
                LOGGER.debug(LogMarkers.SCAN, "Scanning Classloader: {} for {}", (Object)cl, (Object)resource);
                for (URL url : lst) {
                    LOGGER.debug(LogMarkers.SCAN, "\t{}", (Object)url);
                }
            }
            return lst;
        }
        catch (IOException e) {
            LOGGER.warn(LogMarkers.SCAN, "Error finding resources for: " + resource, (Throwable)e);
            return List.of();
        }
    }

    private static Path getPath(URL url, String resource) {
        String str = url.toString();
        int len = resource.length();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            len += 2;
        }
        str = str.substring(0, str.length() - len);
        Path path = Paths.get(URI.create(str));
        return path;
    }

    private static Path getPathFromResource(ClassLoader cl, String resource) {
        URL url = cl.getResource(resource);
        if (url == null) {
            return null;
        }
        return ClasspathLocator.getPath(url, resource);
    }
}

