/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.ITransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.IOException;
import java.lang.module.ModuleReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.targets.ForgeDevLaunchHandler;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;

public abstract class CommonLaunchHandler
implements ILaunchHandlerService {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected final LaunchType type;
    private final String prefix;
    protected static final LaunchType CLIENT = new LaunchType("client", "minecraft", "net.minecraft.client.main.Main", Dist.CLIENT, false);
    protected static final LaunchType DATA = new LaunchType("data", "minecraft", "net.minecraft.data.Main", Dist.CLIENT, true);
    protected static final LaunchType SERVER = new LaunchType("server", "minecraft", "net.minecraft.server.Main", Dist.DEDICATED_SERVER, false);
    protected static final LaunchType SERVER_GAMETEST = new LaunchType("server_gametest", "forge", "net.minecraftforge.gametest.GameTestMain", Dist.DEDICATED_SERVER, false);

    protected CommonLaunchHandler(LaunchType type, String prefix) {
        this.type = type;
        this.prefix = prefix;
    }

    public String name() {
        return this.prefix + this.type.name();
    }

    public Dist getDist() {
        return this.type.dist();
    }

    public boolean isData() {
        return this.type.data();
    }

    public boolean isProduction() {
        return false;
    }

    public abstract String getNaming();

    public abstract List<Path> getMinecraftPaths();

    public void configureTransformationClassLoader(ITransformingClassLoaderBuilder builder) {
    }

    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        URI uri;
        try (ModuleReader reader = layer.configuration().findModule("net.minecraftforge.fmlloader").orElseThrow().reference().open();){
            uri = reader.find("log4j2.xml").orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Configurator.reconfigure((Configuration)ConfigurationFactory.getInstance().getConfiguration(LoggerContext.getContext(), ConfigurationSource.fromUri((URI)uri)));
        return arguments;
    }

    public ServiceRunner launchService(String[] arguments, ModuleLayer gameLayer) {
        FMLLoader.beforeStart(gameLayer);
        return this.makeService(arguments, gameLayer);
    }

    protected ServiceRunner makeService(String[] arguments, ModuleLayer gameLayer) {
        return () -> this.runTarget(this.type.module(), this.type.main(), arguments, gameLayer);
    }

    protected void runTarget(String module, String target, String[] arguments, ModuleLayer layer) throws Throwable {
        Module mod = layer.findModule(module).orElse(null);
        if (mod == null) {
            throw new IllegalStateException("Could not find module " + module);
        }
        Class<?> cls = Class.forName(mod, target);
        if (cls == null) {
            throw new IllegalStateException("Could not find class " + target + " in module " + module);
        }
        Method mtd = cls.getMethod("main", String[].class);
        if (mtd == null) {
            throw new IllegalStateException("Class " + target + " in module " + module + " does not have a main(String[]) method");
        }
        mtd.invoke(null, new Object[]{arguments});
    }

    protected static Path getPathFromResource(String resource) {
        return CommonLaunchHandler.getPathFromResource(resource, ForgeDevLaunchHandler.class.getClassLoader());
    }

    protected static Path getPathFromResource(String resource, ClassLoader cl) {
        URL url = cl.getResource(resource);
        if (url == null) {
            throw new IllegalStateException("Could not find " + resource + " in classloader " + cl);
        }
        String str = url.toString();
        int len = resource.length();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            len += 2;
        }
        str = str.substring(0, str.length() - len);
        Path path = Paths.get(URI.create(str));
        return path;
    }

    protected record LaunchType(String name, String module, String main, Dist dist, boolean data) {
    }
}

