/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.obfuscate.DontObfuscate;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends biv<aia>
implements ahv,
dr,
AutoCloseable {
    private static final Logger l = LogUtils.getLogger();
    public static final String b = "vanilla";
    private static final float m = 0.8f;
    private static final int n = 100;
    private static final long o = 20L * avp.a / 20L;
    private static final int p = 20;
    private static final long q = 10L * avp.a;
    private static final int r = 100;
    private static final long s = 5L * avp.a;
    private static final long t = 10L * avp.b;
    private static final int u = 12;
    public static final int c = 11;
    private static final int v = 441;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int d = 29999984;
    public static final ctt e = new ctt("Demo World", ctm.a, false, bjy.c, false, new ctl(), cuj.c);
    public static final GameProfile f = new GameProfile(ac.d, "Anonymous Player");
    protected final egm.c g;
    protected final egp h;
    private final List<Runnable> z = Lists.newArrayList();
    private bid A = bic.a;
    private bgs B = this.A.f();
    private Consumer<bgr> C = $$0 -> this.aT();
    private Consumer<Path> D = $$0 -> {};
    private boolean E;
    @Nullable
    private c F;
    private boolean G;
    private final aob H;
    private final ann I;
    @Nullable
    private agh J;
    @Nullable
    private agh.a K;
    private final auv L = auv.a();
    private final DataFixer M;
    private String N;
    private int O = -1;
    private final io<ahp> P;
    private final Map<ahf<ctp>, and> Q = Maps.newLinkedHashMap();
    private aqv R;
    private volatile boolean S = true;
    private boolean T;
    private int U;
    private int V = 6000;
    protected final Proxy i;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    @Nullable
    private String aa;
    private int ab;
    private final long[] ac = new long[100];
    private long ad = 0L;
    @Nullable
    private KeyPair ae;
    @Nullable
    private GameProfile af;
    private boolean ag;
    private volatile boolean ah;
    private long ai;
    protected final ahz j;
    private long aj;
    private final Thread ak;
    private long al = ac.c();
    private long am;
    private boolean an;
    private final apt ao;
    private final ahx ap = new ahx(this);
    @Nullable
    private ege aq;
    private final aig ar = new aig();
    private final ahu as;
    private boolean at;
    private float au;
    private final Executor av;
    @Nullable
    private String aw;
    private a ax;
    private final edh ay;
    private final ahy az;
    protected final egs k;
    private volatile boolean aA;

    public static <S extends MinecraftServer> S a(Function<Thread, S> $$02) {
        AtomicReference<MinecraftServer> $$12 = new AtomicReference<MinecraftServer>();
        Thread $$2 = new Thread(() -> ((MinecraftServer)$$12.get()).w(), "Server thread");
        $$2.setUncaughtExceptionHandler(($$0, $$1) -> l.error("Uncaught exception in server thread", $$1));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            $$2.setPriority(8);
        }
        MinecraftServer $$3 = (MinecraftServer)$$02.apply($$2);
        $$12.set($$3);
        $$2.start();
        return (S)$$3;
    }

    public MinecraftServer(Thread $$02, egm.c $$1, apt $$2, aic $$3, Proxy $$4, DataFixer $$5, ahz $$6, ann $$7) {
        super("Server");
        this.P = $$3.c();
        this.k = $$3.d();
        if (!this.P.a().d(ke.aN).c(dmr.b)) {
            throw new IllegalStateException("Missing Overworld dimension data");
        }
        this.i = $$4;
        this.ao = $$2;
        this.ax = new a($$3.a(), $$3.b());
        this.j = $$6;
        if ($$6.f() != null) {
            $$6.f().a(this);
        }
        this.H = new aob(this);
        this.az = new ahy(this);
        this.I = $$7;
        this.g = $$1;
        this.h = $$1.e();
        this.M = $$5;
        this.as = new ahu(this, this.ax.b.a());
        ij<cwq> $$8 = this.P.a().d(ke.f).p().a(this.k.M());
        this.ay = new edh($$3.a(), $$1, $$5, $$8);
        this.ak = $$02;
        this.av = ac.f();
    }

    @Override
    private void a(egh $$0) {
        $$0.a(this.aH().b(), "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void u_() {
        if (!bgy.e.c()) {
            // empty if block
        }
        boolean $$0 = false;
        bhb $$1 = bgy.e.e();
        this.k.a(this.getServerModName(), this.M().a());
        anm $$2 = this.I.create(11);
        this.a($$2);
        this.r();
        this.b($$2);
        if ($$1 != null) {
            $$1.finish();
        }
        if ($$0) {
            try {
                bgy.e.b();
            }
            catch (Throwable $$3) {
                l.warn("Failed to stop JFR profiling", $$3);
            }
        }
    }

    protected void r() {
    }

    @Override
    protected void a(anm $$0) {
        egr $$1 = this.k.K();
        boolean $$2 = this.k.C();
        it<dmr> $$3 = this.P.a().d(ke.aN);
        dpo $$4 = this.k.A();
        long $$5 = $$4.b();
        long $$6 = cuq.a($$5);
        ImmutableList $$7 = ImmutableList.of((Object)new dpc(), (Object)new dpb(), (Object)new cer(), (Object)new bxk(), (Object)new cfc($$1));
        dmr $$8 = $$3.a(dmr.b);
        and $$9 = new and(this, this.av, this.g, $$1, ctp.h, $$8, $$0, $$2, $$6, (List<ctc>)$$7, true, null);
        this.Q.put(ctp.h, $$9);
        egh $$10 = $$9.u();
        this.a($$10);
        this.aq = new ege($$10);
        dky $$11 = $$9.D_();
        if (!$$1.p()) {
            try {
                MinecraftServer.a($$9, $$1, $$4.d(), $$2);
                $$1.c(true);
                if ($$2) {
                    this.a(this.k);
                }
            }
            catch (Throwable $$12) {
                o $$13 = o.a($$12, "Exception initializing level");
                try {
                    $$9.a($$13);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new y($$13);
            }
            $$1.c(true);
        }
        this.ae().a($$9);
        if (this.k.G() != null) {
            this.aL().a(this.k.G());
        }
        bkh $$14 = $$9.J();
        for (Map.Entry<ahf<dmr>, dmr> $$15 : $$3.g()) {
            ahf<dmr> $$16 = $$15.getKey();
            if ($$16 == dmr.b) continue;
            ahf<ctp> $$17 = ahf.a(ke.aM, $$16.a());
            egg $$18 = new egg(this.k, $$1);
            and $$19 = new and(this, this.av, this.g, $$18, $$17, $$15.getValue(), $$0, $$2, $$6, (List<ctc>)ImmutableList.of(), false, $$14);
            $$11.a(new dkw.a($$19.D_()));
            this.Q.put($$17, $$19);
        }
        $$11.a($$1.r());
    }

    private static void a(and $$02, egr $$1, boolean $$2, boolean $$32) {
        if ($$32) {
            $$1.a(hx.b.b(80), 0.0f);
            return;
        }
        anb $$4 = $$02.l();
        csw $$5 = new csw($$4.i().b().a());
        int $$6 = $$4.g().a($$02);
        if ($$6 < $$02.J_()) {
            hx $$7 = $$5.l();
            $$6 = $$02.a(doq.a.b, $$7.u() + 8, $$7.w() + 8);
        }
        $$1.a($$5.l().b(8, $$6, 8), 0.0f);
        int $$8 = 0;
        int $$9 = 0;
        int $$10 = 0;
        int $$11 = -1;
        int $$12 = 5;
        for (int $$13 = 0; $$13 < auo.h(11); ++$$13) {
            hx $$14;
            if ($$8 >= -5 && $$8 <= 5 && $$9 >= -5 && $$9 <= 5 && ($$14 = amy.a($$02, new csw($$5.e + $$8, $$5.f + $$9))) != null) {
                $$1.a($$14, 0.0f);
                break;
            }
            if ($$8 == $$9 || $$8 < 0 && $$8 == -$$9 || $$8 > 0 && $$8 == 1 - $$9) {
                int $$15 = $$10;
                $$10 = -$$11;
                $$11 = $$15;
            }
            $$8 += $$10;
            $$9 += $$11;
        }
        if ($$2) {
            $$02.I_().c(ke.aw).flatMap($$0 -> $$0.b(qk.m)).ifPresent($$3 -> ((drh)$$3.a()).a($$02, $$4.g(), $$0.z, new hx($$1.a(), $$1.b(), $$1.c())));
        }
    }

    @Override
    private void a(egs $$0) {
        $$0.a(bjy.a);
        $$0.d(true);
        egr $$1 = $$0.K();
        $$1.b(false);
        $$1.a(false);
        $$1.a(1000000000);
        $$1.b(6000L);
        $$1.a(ctm.d);
    }

    private void b(anm $$0) {
        and $$1 = this.F();
        l.info("Preparing start region for dimension {}", (Object)$$1.ae().a());
        hx $$2 = $$1.T();
        $$0.a(new csw($$2));
        anb $$3 = $$1.l();
        this.al = ac.c();
        $$3.a(ani.a, new csw($$2), 11, avs.a);
        while ($$3.b() != 441) {
            this.al = ac.c() + t;
            this.w_();
        }
        this.al = ac.c() + t;
        this.w_();
        for (and $$4 : this.Q.values()) {
            ctk $$5 = $$4.u().b(ctk.a(), "chunks");
            if ($$5 == null) continue;
            LongIterator $$6 = $$5.b().iterator();
            while ($$6.hasNext()) {
                long $$7 = $$6.nextLong();
                csw $$8 = new csw($$7);
                $$4.l().a($$8, true);
            }
        }
        this.al = ac.c() + t;
        this.w_();
        $$0.b();
        this.by();
    }

    public ctm v_() {
        return this.k.m();
    }

    public boolean h() {
        return this.k.n();
    }

    public abstract int i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean $$0, boolean $$1, boolean $$2) {
        boolean $$3 = false;
        for (and $$4 : this.H()) {
            if (!$$0) {
                l.info("Saving chunks for level '{}'/{}", (Object)$$4, (Object)$$4.ae().a());
            }
            $$4.a(null, $$1, $$4.e && !$$2);
            $$3 = true;
        }
        and $$5 = this.F();
        egr $$6 = this.k.K();
        $$6.a($$5.D_().t());
        this.k.a(this.aL().c());
        this.g.a(this.aZ(), this.k, this.ae().r());
        if ($$1) {
            for (and $$7 : this.H()) {
                l.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)$$7.l().a.n());
            }
            l.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return $$3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean $$0, boolean $$1, boolean $$2) {
        try {
            this.aA = true;
            this.ae().h();
            boolean bl2 = this.a($$0, $$1, $$2);
            return bl2;
        }
        finally {
            this.aA = false;
        }
    }

    @Override
    public void close() {
        this.t();
    }

    public void t() {
        if (this.A.e()) {
            this.aV();
        }
        l.info("Stopping server");
        this.af().b();
        this.aA = true;
        if (this.R != null) {
            l.info("Saving players");
            this.R.h();
            this.R.s();
        }
        l.info("Saving worlds");
        for (and $$02 : this.H()) {
            if ($$02 == null) continue;
            $$02.e = false;
        }
        while (this.Q.values().stream().anyMatch($$0 -> $$0.l().a.f())) {
            this.al = ac.c() + avp.b;
            for (and $$1 : this.H()) {
                $$1.l().o();
                $$1.l().a(() -> true, false);
            }
            this.w_();
        }
        this.a(false, true, false);
        for (and $$2 : this.H()) {
            if ($$2 == null) continue;
            try {
                $$2.close();
            }
            catch (IOException $$3) {
                l.error("Exception closing the level", (Throwable)$$3);
            }
        }
        this.aA = false;
        this.ax.close();
        try {
            this.g.close();
        }
        catch (IOException $$4) {
            l.error("Failed to unlock level {}", (Object)this.g.d(), (Object)$$4);
        }
    }

    public String u() {
        return this.N;
    }

    public void a_(String $$0) {
        this.N = $$0;
    }

    public boolean v() {
        return this.S;
    }

    @Override
    public void a(boolean $$0) {
        this.S = false;
        if ($$0) {
            try {
                this.ak.join();
            }
            catch (InterruptedException $$1) {
                l.error("Error while shutting down", (Throwable)$$1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void w() {
        block28: {
            try {
                if (this.e()) {
                    this.al = ac.c();
                    this.K = this.bm().orElse(null);
                    this.J = this.bo();
                    while (this.S) {
                        boolean $$4;
                        long $$1;
                        if (!this.A() && this.az.a() && this.az.d()) {
                            long $$0 = 0L;
                            this.ai = this.al = ac.c();
                        } else {
                            $$1 = this.az.h();
                            long $$2 = ac.c() - this.al;
                            if ($$2 > o + 20L * $$1 && this.al - this.ai >= q + 100L * $$1) {
                                long $$3 = $$2 / $$1;
                                l.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)($$2 / avp.b), (Object)$$3);
                                this.al += $$3 * $$1;
                                this.ai = this.al;
                            }
                        }
                        boolean bl2 = $$4 = $$1 == 0L;
                        if (this.G) {
                            this.G = false;
                            this.F = new c(ac.c(), this.U);
                        }
                        this.al += $$1;
                        this.bz();
                        this.B.a("tick");
                        this.a($$4 ? () -> false : this::bk);
                        this.B.b("nextTickWait");
                        this.an = true;
                        this.am = Math.max(ac.c() + $$1, this.al);
                        this.w_();
                        if ($$4) {
                            this.az.e();
                        }
                        this.B.c();
                        this.bA();
                        this.ah = true;
                        bgy.e.a(this.au);
                    }
                    break block28;
                }
                throw new IllegalStateException("Failed to initialize server");
            }
            catch (Throwable $$6) {
                l.error("Encountered an unexpected exception", $$6);
                o $$7 = MinecraftServer.a($$6);
                this.b($$7.g());
                File $$8 = new File(new File(this.z(), "crash-reports"), "crash-" + ac.e() + "-server.txt");
                if ($$7.a($$8)) {
                    l.error("This crash report has been saved to: {}", (Object)$$8.getAbsolutePath());
                } else {
                    l.error("We were unable to save this crash report to disk.");
                }
                this.a($$7);
            }
            finally {
                try {
                    this.T = true;
                    this.t();
                }
                catch (Throwable $$5) {
                    l.error("Exception stopping the server", $$5);
                }
                finally {
                    if (this.j.f() != null) {
                        this.j.f().a();
                    }
                    this.g();
                }
            }
        }
    }

    private static o a(Throwable $$0) {
        o $$5;
        y $$1 = null;
        for (Throwable $$2 = $$0; $$2 != null; $$2 = $$2.getCause()) {
            y $$3;
            if (!($$2 instanceof y)) continue;
            $$1 = $$3 = (y)$$2;
        }
        if ($$1 != null) {
            o $$4 = $$1.a();
            if ($$1 != $$0) {
                $$4.a("Wrapped in").a("Wrapping exception", $$0);
            }
        } else {
            $$5 = new o("Exception in server tick loop", $$0);
        }
        return $$5;
    }

    private boolean bk() {
        return this.bw() || ac.c() < (this.an ? this.am : this.al);
    }

    protected void w_() {
        this.bu();
        this.c(() -> !this.bk());
    }

    protected aia a(Runnable $$0) {
        return new aia(this.U, $$0);
    }

    protected boolean a(aia $$0) {
        return $$0.a() + 3 < this.U || this.bk();
    }

    @Override
    public boolean x() {
        boolean $$0;
        this.an = $$0 = this.bl();
        return $$0;
    }

    private boolean bl() {
        if (super.x()) {
            return true;
        }
        if (this.az.a() || this.bk()) {
            for (and $$0 : this.H()) {
                if (!$$0.l().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(aia $$0) {
        this.aR().d("runTask");
        super.d($$0);
    }

    private Optional<agh.a> bm() {
        Optional<Path> $$02 = Optional.of(this.c("server-icon.png").toPath()).filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])).or(() -> this.g.h().filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])));
        return $$02.flatMap($$0 -> {
            try {
                BufferedImage $$1 = ImageIO.read($$0.toFile());
                Preconditions.checkState(($$1.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState(($$1.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream $$2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)$$1, "PNG", $$2);
                return Optional.of(new agh.a($$2.toByteArray()));
            }
            catch (Exception $$3) {
                l.error("Couldn't load server icon", (Throwable)$$3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> y() {
        return this.g.h();
    }

    public File z() {
        return new File(".");
    }

    @Override
    public void a(o $$0) {
    }

    public void g() {
    }

    public boolean A() {
        return false;
    }

    @Override
    public void a(BooleanSupplier $$0) {
        long $$1 = ac.c();
        ++this.U;
        this.az.m();
        this.b($$0);
        if ($$1 - this.aj >= s) {
            this.aj = $$1;
            this.J = this.bo();
        }
        --this.V;
        if (this.V <= 0) {
            this.V = this.bn();
            l.debug("Autosave started");
            this.B.a("save");
            this.b(true, false, false);
            this.B.c();
            l.debug("Autosave finished");
        }
        this.B.a("tallying");
        long $$2 = ac.c() - $$1;
        int $$3 = this.U % 100;
        this.ad -= this.ac[$$3];
        this.ad += $$2;
        this.ac[$$3] = $$2;
        this.au = this.au * 0.8f + (float)$$2 / (float)avp.b * 0.19999999f;
        long $$4 = ac.c();
        this.a($$4 - $$1);
        this.B.c();
    }

    private int bn() {
        float $$2;
        if (this.az.a()) {
            long $$0 = this.aP() + 1L;
            float $$1 = (float)avp.a / (float)$$0;
        } else {
            $$2 = this.az.f();
        }
        int $$3 = 300;
        return Math.max(100, (int)($$2 * 300.0f));
    }

    public void B() {
        int $$0 = this.bn();
        if ($$0 < this.V) {
            this.V = $$0;
        }
    }

    @Override
    protected void a(long $$0) {
    }

    private agh bo() {
        agh.b $$0 = this.bx();
        return new agh(vf.a(this.aa), Optional.of($$0), Optional.of(agh.c.a()), Optional.ofNullable(this.K), this.ay());
    }

    private agh.b bx() {
        List<ane> $$0 = this.R.t();
        int $$1 = this.K();
        if (this.al()) {
            return new agh.b($$1, $$0.size(), List.of());
        }
        int $$2 = Math.min($$0.size(), 12);
        ObjectArrayList $$3 = new ObjectArrayList($$2);
        int $$4 = auo.a(this.L, 0, $$0.size() - $$2);
        for (int $$5 = 0; $$5 < $$2; ++$$5) {
            ane $$6 = $$0.get($$4 + $$5);
            $$3.add((Object)($$6.Z() ? $$6.fR() : f));
        }
        ac.c($$3, this.L);
        return new agh.b($$1, $$0.size(), (List<GameProfile>)$$3);
    }

    public void b(BooleanSupplier $$02) {
        this.ae().t().forEach($$0 -> $$0.c.g());
        this.B.a("commandFunctions");
        this.aC().b();
        this.B.b("levels");
        for (and $$1 : this.H()) {
            this.B.a(() -> $$1 + " " + $$1.ae().a());
            if (this.U % 20 == 0) {
                this.B.a("timeSync");
                this.b($$1);
                this.B.c();
            }
            this.B.a("tick");
            try {
                $$1.a($$02);
            }
            catch (Throwable $$2) {
                o $$3 = o.a($$2, "Exception ticking world");
                $$1.a($$3);
                throw new y($$3);
            }
            this.B.c();
            this.B.c();
        }
        this.B.b("connection");
        this.af().c();
        this.B.b("players");
        this.R.d();
        if (aa.aW && this.az.i()) {
            ru.a.b();
        }
        this.B.b("server gui refresh");
        for (int $$4 = 0; $$4 < this.z.size(); ++$$4) {
            this.z.get($$4).run();
        }
        this.B.b("send chunks");
        for (ane $$5 : this.R.t()) {
            $$5.c.f.a($$5);
            $$5.c.h();
        }
        this.B.c();
    }

    private void b(and $$0) {
        this.R.a(new aco($$0.X(), $$0.Y(), $$0.Z().b(ctl.l)), $$0.ae());
    }

    public void C() {
        this.B.a("timeSync");
        for (and $$0 : this.H()) {
            this.b($$0);
        }
        this.B.c();
    }

    public boolean D() {
        return true;
    }

    public void b(Runnable $$0) {
        this.z.add($$0);
    }

    protected void b(String $$0) {
        this.aw = $$0;
    }

    public boolean E() {
        return !this.ak.isAlive();
    }

    public File c(String $$0) {
        return new File(this.z(), $$0);
    }

    public final and F() {
        return this.Q.get(ctp.h);
    }

    @Nullable
    public and a(ahf<ctp> $$0) {
        return this.Q.get($$0);
    }

    public Set<ahf<ctp>> G() {
        return this.Q.keySet();
    }

    public Iterable<and> H() {
        return this.Q.values();
    }

    @Override
    public String I() {
        return aa.b().c();
    }

    @Override
    public int J() {
        return this.R.m();
    }

    @Override
    public int K() {
        return this.R.n();
    }

    public String[] L() {
        return this.R.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return b;
    }

    public ab b(ab $$0) {
        $$0.a("Server Running", () -> Boolean.toString(this.S));
        if (this.R != null) {
            $$0.a("Player Count", () -> this.R.m() + " / " + this.R.n() + "; " + this.R.t());
        }
        $$0.a("Data Packs", () -> this.ao.f().stream().map($$0 -> $$0.f() + ($$0.c().a() ? "" : " (incompatible)")).collect(Collectors.joining(", ")));
        $$0.a("Enabled Feature Flags", () -> chu.e.b(this.k.M()).stream().map(ahg::toString).collect(Collectors.joining(", ")));
        $$0.a("World Generation", () -> this.k.D().toString());
        if (this.aw != null) {
            $$0.a("Server Id", () -> this.aw);
        }
        return this.a($$0);
    }

    public abstract ab a(ab var1);

    public aun M() {
        return aun.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(vf $$0) {
        l.info($$0.getString());
    }

    public KeyPair N() {
        return this.ae;
    }

    public int O() {
        return this.O;
    }

    @Override
    public void a(int $$0) {
        this.O = $$0;
    }

    @Nullable
    public GameProfile P() {
        return this.af;
    }

    public void b(@Nullable GameProfile $$0) {
        this.af = $$0;
    }

    public boolean Q() {
        return this.af != null;
    }

    protected void R() {
        l.info("Generating keypair");
        try {
            this.ae = atm.b();
        }
        catch (atn $$0) {
            throw new IllegalStateException("Failed to generate key pair", $$0);
        }
    }

    public void a(bjy $$0, boolean $$1) {
        if (!$$1 && this.k.t()) {
            return;
        }
        this.k.a(this.k.n() ? bjy.d : $$0);
        this.by();
        this.ae().t().forEach(this::c);
    }

    public int b(int $$0) {
        return $$0;
    }

    private void by() {
        for (and $$0 : this.H()) {
            $$0.b(this.S(), this.Y());
        }
    }

    public void b(boolean $$0) {
        this.k.d($$0);
        this.ae().t().forEach(this::c);
    }

    private void c(ane $$0) {
        egi $$1 = $$0.dM().B_();
        $$0.c.b(new zm($$1.s(), $$1.t()));
    }

    public boolean S() {
        return this.k.s() != bjy.a;
    }

    public boolean T() {
        return this.ag;
    }

    public void c(boolean $$0) {
        this.ag = $$0;
    }

    public Optional<b> U() {
        return Optional.empty();
    }

    public boolean V() {
        return this.U().filter(b::d).isPresent();
    }

    public abstract boolean l();

    public abstract int m();

    public boolean W() {
        return this.W;
    }

    @Override
    public void d(boolean $$0) {
        this.W = $$0;
    }

    public boolean X() {
        return this.X;
    }

    public void e(boolean $$0) {
        this.X = $$0;
    }

    public boolean Y() {
        return true;
    }

    public boolean Z() {
        return true;
    }

    public abstract boolean n();

    public boolean aa() {
        return this.Y;
    }

    public void f(boolean $$0) {
        this.Y = $$0;
    }

    public boolean ab() {
        return this.Z;
    }

    public void g(boolean $$0) {
        this.Z = $$0;
    }

    public abstract boolean o();

    @Override
    public String ac() {
        return this.aa;
    }

    @Override
    public void d(String $$0) {
        this.aa = $$0;
    }

    public boolean ad() {
        return this.T;
    }

    public aqv ae() {
        return this.R;
    }

    @Override
    public void a(aqv $$0) {
        this.R = $$0;
    }

    public abstract boolean p();

    @Override
    public void a(ctm $$0) {
        this.k.a($$0);
    }

    public aob af() {
        return this.H;
    }

    public boolean ag() {
        return this.ah;
    }

    public boolean ah() {
        return false;
    }

    public boolean a(@Nullable ctm $$0, boolean $$1, int $$2) {
        return false;
    }

    public int ai() {
        return this.U;
    }

    public int aj() {
        return 16;
    }

    public boolean a(and $$0, hx $$1, cfi $$2) {
        return false;
    }

    public boolean ak() {
        return true;
    }

    public boolean al() {
        return false;
    }

    public Proxy am() {
        return this.i;
    }

    public int an() {
        return this.ab;
    }

    public void c(int $$0) {
        this.ab = $$0;
    }

    public MinecraftSessionService ao() {
        return this.j.c();
    }

    @Nullable
    public avc ap() {
        return this.j.a();
    }

    public GameProfileRepository aq() {
        return this.j.e();
    }

    @Nullable
    public aqr ar() {
        return this.j.f();
    }

    @Nullable
    public agh as() {
        return this.J;
    }

    public void at() {
        this.aj = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ad();
    }

    @Override
    public void c(Runnable $$0) {
        if (this.ad()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.c($$0);
    }

    @Override
    public Thread aw() {
        return this.ak;
    }

    public int ax() {
        return 256;
    }

    public boolean ay() {
        return false;
    }

    public long az() {
        return this.al;
    }

    public DataFixer aA() {
        return this.M;
    }

    public int a(@Nullable and $$0) {
        if ($$0 != null) {
            return $$0.Z().c(ctl.s);
        }
        return 10;
    }

    public ahs aB() {
        return this.ax.b.e();
    }

    public ahu aC() {
        return this.as;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> $$0) {
        iu.b $$13 = this.P.b(ahp.d);
        CompletionStage $$2 = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)$$0.stream().map(this.ao::c).filter(Objects::nonNull).map(apq::e).collect(ImmutableList.toImmutableList()), this).thenCompose($$12 -> {
            aqb $$22 = new aqb(aox.b, (List<aow>)$$12);
            return ((CompletableFuture)ahq.a($$22, $$13, this.k.M(), this.l() ? dt.a.b : dt.a.c, this.j(), this.av, this).whenComplete(($$1, $$2) -> {
                if ($$2 != null) {
                    $$22.close();
                }
            })).thenApply($$1 -> new a($$22, (ahq)$$1));
        })).thenAcceptAsync($$1 -> {
            this.ax.close();
            this.ax = $$1;
            this.ao.a($$0);
            cuj $$2 = new cuj(MinecraftServer.a(this.ao), this.k.M());
            this.k.a($$2);
            this.ax.b.a(this.aZ());
            this.ae().h();
            this.ae().u();
            this.as.a(this.ax.b.a());
            this.ay.a(this.ax.a);
        }, (Executor)this);
        if (this.bq()) {
            this.c(((CompletableFuture)$$2)::isDone);
        }
        return $$2;
    }

    public static cuj a(apt $$0, ctd $$1, boolean $$2, chs $$3) {
        $$0.a();
        if ($$2) {
            $$0.a(Collections.singleton(b));
            return cuj.c;
        }
        LinkedHashSet $$4 = Sets.newLinkedHashSet();
        for (String $$5 : $$1.a()) {
            if ($$0.d($$5)) {
                $$4.add($$5);
                continue;
            }
            l.warn("Missing data pack {}", (Object)$$5);
        }
        for (apq $$6 : $$0.c()) {
            String $$7 = $$6.f();
            if ($$1.b().contains($$7)) continue;
            chs $$8 = $$6.d();
            boolean $$9 = $$4.contains($$7);
            if (!$$9 && $$6.j().a()) {
                if ($$8.a($$3)) {
                    l.info("Found new data pack {}, loading it automatically", (Object)$$7);
                    $$4.add($$7);
                } else {
                    l.info("Found new data pack {}, but can't load it due to missing features {}", (Object)$$7, (Object)chu.a($$3, $$8));
                }
            }
            if (!$$9 || $$8.a($$3)) continue;
            l.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)$$7, (Object)chu.a($$3, $$8));
            $$4.remove($$7);
        }
        if ($$4.isEmpty()) {
            l.info("No datapacks selected, forcing vanilla");
            $$4.add(b);
        }
        $$0.a($$4);
        ctd $$10 = MinecraftServer.a($$0);
        chs $$11 = $$0.e();
        return new cuj($$10, $$11);
    }

    private static ctd a(apt $$0) {
        Collection<String> $$12 = $$0.d();
        ImmutableList $$2 = ImmutableList.copyOf($$12);
        List $$3 = (List)$$0.b().stream().filter($$1 -> !$$12.contains($$1)).collect(ImmutableList.toImmutableList());
        return new ctd((List<String>)$$2, $$3);
    }

    @Override
    public void a(ds $$0) {
        if (!this.aM()) {
            return;
        }
        aqv $$1 = $$0.l().ae();
        ard $$2 = $$1.i();
        ArrayList $$3 = Lists.newArrayList($$1.t());
        for (ane $$4 : $$3) {
            if ($$2.a($$4.fR())) continue;
            $$4.c.b(vf.c("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public apt aD() {
        return this.ao;
    }

    public dt aE() {
        return this.ax.b.d();
    }

    public ds aF() {
        and $$0 = this.F();
        return new ds(this, $$0 == null ? elt.b : elt.a($$0.T()), els.a, $$0, 4, "Server", vf.b("Server"), this, null);
    }

    @Override
    public boolean l_() {
        return true;
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public abstract boolean W_();

    public cqf aG() {
        return this.ax.b.c();
    }

    public ahx aH() {
        return this.ap;
    }

    public ege aI() {
        if (this.aq == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.aq;
    }

    public egz aJ() {
        return this.ax.b.b();
    }

    public ctl aK() {
        return this.F().Z();
    }

    public aig aL() {
        return this.ar;
    }

    public boolean aM() {
        return this.at;
    }

    public void h(boolean $$0) {
        this.at = $$0;
    }

    public float aN() {
        return this.au;
    }

    public ahy aO() {
        return this.az;
    }

    public long aP() {
        return this.ad / (long)Math.min(100, Math.max(this.U, 1));
    }

    public long[] aQ() {
        return this.ac;
    }

    public int c(GameProfile $$0) {
        if (this.ae().f($$0)) {
            aqx $$1 = (aqx)this.ae().k().b($$0);
            if ($$1 != null) {
                return $$1.a();
            }
            if (this.a($$0)) {
                return 4;
            }
            if (this.Q()) {
                return this.ae().v() ? 4 : 0;
            }
            return this.i();
        }
        return 0;
    }

    public bgs aR() {
        return this.B;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path $$0) throws IOException {
    }

    private void b(Path $$0) {
        Path $$1 = $$0.resolve("levels");
        try {
            for (Map.Entry<ahf<ctp>, and> $$2 : this.Q.entrySet()) {
                ahg $$3 = $$2.getKey().a();
                Path $$4 = $$1.resolve($$3.b()).resolve($$3.a());
                Files.createDirectories($$4, new FileAttribute[0]);
                $$2.getValue().a($$4);
            }
            this.d($$0.resolve("gamerules.txt"));
            this.e($$0.resolve("classpath.txt"));
            this.c($$0.resolve("stats.txt"));
            this.f($$0.resolve("threads.txt"));
            this.a($$0.resolve("server.properties.txt"));
            this.g($$0.resolve("modules.txt"));
        }
        catch (IOException $$5) {
            l.warn("Failed to save debug report", (Throwable)$$5);
        }
    }

    private void c(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            $$1.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.br()));
            $$1.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aN())));
            $$1.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ac)));
            $$1.write(String.format(Locale.ROOT, "queue: %s\n", ac.f()));
        }
    }

    @Override
    private void d(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            final ArrayList $$2 = Lists.newArrayList();
            final ctl $$3 = this.aK();
            ctl.a(new ctl.c(){

                @Override
                public <T extends ctl.g<T>> void a(ctl.e<T> $$0, ctl.f<T> $$1) {
                    $$2.add(String.format(Locale.ROOT, "%s=%s\n", $$0.a(), $$3.a($$0)));
                }
            });
            for (String $$4 : $$2) {
                $$1.write($$4);
            }
        }
    }

    private void e(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            String $$2 = System.getProperty("java.class.path");
            String $$3 = System.getProperty("path.separator");
            for (String $$4 : Splitter.on((String)$$3).split((CharSequence)$$2)) {
                $$1.write($$4);
                $$1.write("\n");
            }
        }
    }

    private void f(Path $$0) throws IOException {
        ThreadMXBean $$1 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] $$2 = $$1.dumpAllThreads(true, true);
        Arrays.sort($$2, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter $$3 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            for (ThreadInfo $$4 : $$2) {
                $$3.write($$4.toString());
                ((Writer)$$3).write(10);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void g(Path $$02) throws IOException {
        BufferedWriter $$1 = Files.newBufferedWriter($$02, new OpenOption[0]);
        try {
            void $$4;
            try {
                ArrayList $$2 = Lists.newArrayList(aup.a());
            }
            catch (Throwable $$3) {
                l.warn("Failed to list native modules", $$3);
                if ($$1 != null) {
                    ((Writer)$$1).close();
                }
                return;
            }
            $$4.sort(Comparator.comparing($$0 -> $$0.a));
            for (aup.a $$5 : $$4) {
                $$1.write($$5.toString());
                ((Writer)$$1).write(10);
            }
        }
        finally {
            if ($$1 != null) {
                try {
                    ((Writer)$$1).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void bz() {
        if (this.E) {
            this.A = bib.a(new bif(ac.b, this.l()), ac.b, ac.g(), new bih("server"), this.C, $$0 -> {
                this.h(() -> this.b($$0.resolve("server")));
                this.D.accept((Path)$$0);
            });
            this.E = false;
        }
        this.B = bgv.a(this.A.f(), bgv.a("Server"));
        this.A.c();
        this.B.a();
    }

    private void bA() {
        this.B.b();
        this.A.d();
    }

    public boolean aS() {
        return this.A.e();
    }

    public void a(Consumer<bgr> $$0, Consumer<Path> $$12) {
        this.C = $$1 -> {
            this.aT();
            $$0.accept((bgr)$$1);
        };
        this.D = $$12;
        this.E = true;
    }

    public void aT() {
        this.A = bic.a;
    }

    public void aU() {
        this.A.a();
    }

    public void aV() {
        this.A.b();
        this.B = this.A.f();
    }

    public Path a(egk $$0) {
        return this.g.a($$0);
    }

    public boolean aW() {
        return true;
    }

    public edh aX() {
        return this.ay;
    }

    public egs aY() {
        return this.k;
    }

    public iu.b aZ() {
        return this.P.a();
    }

    public io<ahp> ba() {
        return this.P;
    }

    public aoh a(ane $$0) {
        return aoh.a;
    }

    public anf b(ane $$0) {
        return this.T() ? new amu($$0) : new anf($$0);
    }

    @Nullable
    public ctm bb() {
        return null;
    }

    public aqi bc() {
        return this.ax.a;
    }

    public boolean bd() {
        return this.aA;
    }

    public boolean be() {
        return this.G || this.F != null;
    }

    public void bf() {
        this.G = true;
    }

    public bgr bg() {
        if (this.F == null) {
            return bgn.a;
        }
        bgr $$0 = this.F.a(ac.c(), this.U);
        this.F = null;
        return $$0;
    }

    public int bh() {
        return 1000000;
    }

    public void a(vf $$0, vb.a $$1, @Nullable String $$2) {
        String $$3 = $$1.a($$0).getString();
        if ($$2 != null) {
            l.info("[{}] {}", (Object)$$2, (Object)$$3);
        } else {
            l.info("{}", (Object)$$3);
        }
    }

    public va bi() {
        return va.a;
    }

    public boolean bj() {
        return true;
    }

    @Override
    public /* synthetic */ void d(Runnable runnable) {
        this.b((aia)runnable);
    }

    @Override
    public /* synthetic */ boolean e(Runnable runnable) {
        return this.a((aia)runnable);
    }

    @Override
    public /* synthetic */ Runnable f(Runnable runnable) {
        return this.a(runnable);
    }

    static final class a
    extends Record
    implements AutoCloseable {
        final apy a;
        final ahq b;

        a(apy $$0, ahq $$1) {
            this.a = $$0;
            this.b = $$1;
        }

        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resourceManager;managers", "a", "b"}, this, $$0);
        }

        public apy a() {
            return this.a;
        }

        public ahq b() {
            return this.b;
        }
    }

    static class c {
        final long a;
        final int b;

        c(long $$0, int $$1) {
            this.a = $$0;
            this.b = $$1;
        }

        bgr a(final long $$0, final int $$1) {
            return new bgr(){

                @Override
                public List<bgu> a(String $$02) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path $$02) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return $$0;
                }

                @Override
                public int d() {
                    return $$1;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record b(UUID a, String b, String c, boolean d, @Nullable vf e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, $$0);
        }
    }
}

