/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConditionalAdvancement {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final ResourceLocation DOESNT_MATTER = new ResourceLocation("doesnt", "matter");
        private List<Pair> advancements = new ArrayList<Pair>();
        private ICondition condition;

        public Builder condition(ICondition value) {
            this.condition = value;
            return this;
        }

        public Builder advancement(Consumer<Consumer<Advancement.Builder>> callable) {
            callable.accept(this::advancement);
            return this;
        }

        public Builder advancement(Advancement.Builder builder) {
            return this.advancement(builder.m_138403_(DOESNT_MATTER).f_290952_());
        }

        public Builder advancement(AdvancementHolder holder) {
            return this.advancement(holder.f_290952_());
        }

        private Builder advancement(Advancement value) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a advancement with no conditions.");
            }
            if (value == null) {
                throw new IllegalStateException("Can not add a null advancement");
            }
            this.advancements.add(new Pair(this.condition, value));
            this.condition = null;
            return this;
        }

        public JsonObject build() {
            JsonObject json = new JsonObject();
            JsonArray array = new JsonArray();
            json.add("advancements", (JsonElement)array);
            for (Pair pair : this.advancements) {
                JsonObject holder = (JsonObject)Util.m_260975_((DataResult)Advancement.f_303179_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pair.adv()), IllegalStateException::new);
                if (holder.has("forge:condition")) {
                    throw new IllegalStateException("Recipe already serialized conditions!");
                }
                ForgeHooks.writeCondition(pair.condition(), holder);
                array.add((JsonElement)holder);
            }
            return json;
        }
    }

    private record Pair(ICondition condition, Advancement adv) {
    }
}

