/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PartialNBTIngredient
extends AbstractIngredient {
    private final List<Item> items;
    private final CompoundTag nbt;
    private final NbtPredicate predicate;
    public static final Codec<PartialNBTIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ForgeRegistries.ITEMS.getCodec().listOf().fieldOf("items").forGetter(i -> i.items), (App)TagParser.f_290338_.fieldOf("nbt").forGetter(i -> i.nbt)).apply((Applicative)builder, PartialNBTIngredient::new));
    public static final IIngredientSerializer<PartialNBTIngredient> SERIALIZER = new IIngredientSerializer<PartialNBTIngredient>(){

        @Override
        public Codec<? extends PartialNBTIngredient> codec() {
            return CODEC;
        }

        @Override
        public PartialNBTIngredient read(FriendlyByteBuf buffer) {
            List items = buffer.m_236845_(b -> (Item)b.readRegistryIdUnsafe(ForgeRegistries.ITEMS));
            CompoundTag nbt = buffer.m_130260_();
            return new PartialNBTIngredient(items, Objects.requireNonNull(nbt));
        }

        @Override
        public void write(FriendlyByteBuf buffer, PartialNBTIngredient value) {
            buffer.m_236828_(value.items, (b, item) -> b.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, item));
            buffer.m_130079_((Tag)value.nbt);
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private PartialNBTIngredient(List<Item> items, CompoundTag nbt) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            stack.m_41751_(nbt.m_6426_());
            return new Ingredient.ItemValue(stack);
        }));
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PartialNBTIngredient with no items");
        }
        this.items = Collections.unmodifiableList(items);
        this.nbt = nbt;
        this.predicate = new NbtPredicate(nbt);
    }

    public static PartialNBTIngredient of(CompoundTag nbt, ItemLike ... items) {
        return new PartialNBTIngredient(Arrays.stream(items).map(ItemLike::m_5456_).toList(), nbt);
    }

    public static PartialNBTIngredient of(ItemLike item, CompoundTag nbt) {
        return new PartialNBTIngredient(List.of(item.m_5456_()), nbt);
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.m_41720_()) && this.predicate.m_57483_((Tag)input.getShareTag());
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }

    public static class Builder {
        private List<ItemLike> items = new ArrayList<ItemLike>();
        private CompoundTag nbt;

        public Builder nbt(CompoundTag value) {
            if (this.nbt != null) {
                throw new IllegalStateException("NBT Tag already set");
            }
            this.nbt = value;
            return this;
        }

        public Builder item(ItemLike item) {
            this.items.add(item);
            return this;
        }

        public Builder items(ItemLike ... values) {
            for (ItemLike item : values) {
                this.items.add(item);
            }
            return this;
        }

        public PartialNBTIngredient build() {
            if (this.nbt == null) {
                throw new IllegalStateException("NBT Data not set");
            }
            if (this.items.isEmpty()) {
                throw new IllegalStateException("No items added");
            }
            return PartialNBTIngredient.of(this.nbt, (ItemLike[])this.items.stream().toArray(ItemLike[]::new));
        }
    }
}

