/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.network;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;

public class CustomPayloadEvent
extends Event {
    private final ResourceLocation channel;
    private final FriendlyByteBuf payload;
    private final Context source;
    private final int loginIndex;

    public CustomPayloadEvent(ResourceLocation channel, FriendlyByteBuf payload, Context source, int loginIndex) {
        this.channel = channel;
        this.payload = payload;
        this.source = source;
        this.loginIndex = loginIndex;
    }

    public CustomPayloadEvent(ICustomPacket<?> payload, Context source) {
        this(payload.getName(), payload.getInternalData(), source, payload.getIndex());
    }

    public ResourceLocation getChannel() {
        return this.channel;
    }

    public FriendlyByteBuf getPayload() {
        return this.payload;
    }

    public int getLoginIndex() {
        return this.loginIndex;
    }

    public Context getSource() {
        return this.source;
    }

    public static class Context {
        private final Connection connection;
        private final NetworkDirection networkDirection;
        private boolean packetHandled;

        public Context(Connection connection, NetworkDirection networkDirection) {
            this.connection = connection;
            this.networkDirection = networkDirection;
        }

        public boolean isClientSide() {
            return this.getConnection().m_178313_() == PacketFlow.CLIENTBOUND;
        }

        public boolean isServerSide() {
            return !this.isClientSide();
        }

        public NetworkDirection getDirection() {
            return this.networkDirection;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public <T> Attribute<T> attr(AttributeKey<T> key) {
            return this.connection.channel().attr(key);
        }

        public void setPacketHandled(boolean packetHandled) {
            this.packetHandled = packetHandled;
        }

        public boolean getPacketHandled() {
            return this.packetHandled;
        }

        public CompletableFuture<Void> enqueueWork(Runnable runnable) {
            BlockableEventLoop<? super TickTask> executor = LogicalSidedProvider.WORKQUEUE.get(this.getDirection().getReceptionSide());
            if (!executor.m_18695_()) {
                return executor.m_18689_(runnable);
            }
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }

        @Nullable
        public ServerPlayer getSender() {
            PacketListener netHandler = this.connection.m_129538_();
            if (netHandler instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl handler = (ServerGamePacketListenerImpl)netHandler;
                return handler.f_9743_;
            }
            return null;
        }
    }
}

