/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.base.Function;
import io.izzel.arclight.common.bridge.core.util.DamageSourceBridge;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.DistValidate;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_8111;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Item;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftEventFactory.class}, remap=false)
public abstract class CraftEventFactoryMixin {
    @Shadow
    private static EntityDamageEvent callEntityDamageEvent(class_1297 damager, class_1297 damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        return null;
    }

    @ModifyVariable(method={"handleEntityDamageEvent*"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    private static class_1282 arclight$captureSource(class_1282 source, class_1297 entity) {
        class_1297 damageEventEntity = ArclightCaptures.getDamageEventEntity();
        class_2338 damageEventBlock = ArclightCaptures.getDamageEventBlock();
        if (damageEventEntity != null && ((DamageSourceBridge)source).bridge$getCausingEntity() == null && source.method_49708(class_8111.field_42336)) {
            source = ((DamageSourceBridge)source).bridge$customCausingEntity(damageEventEntity);
        }
        if (damageEventBlock != null && ((DamageSourceBridge)source).bridge$directBlock() == null && (source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42339))) {
            source = ((DamageSourceBridge)source).bridge$directBlock(CraftBlock.at((class_1936)entity.method_5770(), damageEventBlock));
        }
        return source;
    }

    @Inject(method={"handleEntityDamageEvent*"}, cancellable=true, at={@At(value="NEW", target="java/lang/IllegalStateException")})
    private static void arclight$unhandledDamage(class_1297 entity, class_1282 source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled, CallbackInfoReturnable<EntityDamageEvent> cir) {
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        EntityDamageEvent event = CraftEventFactoryMixin.callEntityDamageEvent(((DamageSourceBridge)source).bridge$getCausingEntity(), entity, EntityDamageEvent.DamageCause.CUSTOM, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        cir.setReturnValue((Object)event);
    }

    @Overwrite
    public static boolean handleBlockSpreadEvent(class_1936 world, class_2338 source, class_2338 target, class_2680 block, int flag) {
        if (!(world instanceof class_1937) || !DistValidate.isValid(world)) {
            world.method_8652(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent(state.getBlock(), CraftBlock.at(world, source), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static boolean handleBlockGrowEvent(class_1937 world, class_2338 pos, class_2680 newData, int flag) {
        if (!DistValidate.isValid((class_1936)world)) {
            world.method_8652(pos, newData, flag);
            return true;
        }
        Block block = world.bridge$getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, int flag, @Nullable class_1297 entity) {
        if (!DistValidate.isValid((class_1936)world)) {
            world.method_8652(pos, block, flag);
            return true;
        }
        CraftBlockState blockState = CraftBlockStates.getBlockState((class_1936)world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent(blockState.getBlock(), blockState) : new EntityBlockFormEvent(entity.bridge$getBukkitEntity(), blockState.getBlock(), blockState);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static BlockFadeEvent callBlockFadeEvent(class_1936 world, class_2338 pos, class_2680 newBlock) {
        if (!(world instanceof class_1937) || !DistValidate.isValid(world)) {
            return new BlockFadeEvent(CraftBlock.at(world, pos), null);
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    @Overwrite
    public static BlockPhysicsEvent callBlockPhysicsEvent(class_1936 world, class_2338 blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent(block, block.getBlockData());
        if (world instanceof class_1937 && DistValidate.isValid(world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Overwrite
    public static boolean callEntityChangeBlockEvent(class_1297 entity, class_2338 position, class_2680 newBlock, boolean cancelled) {
        CraftBlock block = CraftBlock.at((class_1936)entity.method_37908(), position);
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity.bridge$getBukkitEntity(), block, CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        if (DistValidate.isValid((class_1936)entity.method_37908())) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return !event.isCancelled();
    }

    @Overwrite
    public static BlockRedstoneEvent callRedstoneChange(class_1937 world, class_2338 pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(CraftBlock.at((class_1936)world, pos), oldCurrent, newCurrent);
        if (DistValidate.isValid((class_1936)world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Overwrite
    public static NotePlayEvent callNotePlayEvent(class_1937 world, class_2338 pos, class_2766 instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(CraftBlock.at((class_1936)world, pos), Instrument.getByType((byte)instrument.ordinal()), new Note(note));
        if (DistValidate.isValid((class_1936)world)) {
            Bukkit.getPluginManager().callEvent(event);
        }
        return event;
    }

    @Inject(method={"callItemSpawnEvent"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$noAirDrops(class_1542 itemEntity, CallbackInfoReturnable<ItemSpawnEvent> cir) {
        if (itemEntity.method_6983().method_7960()) {
            Item entity = (Item)((Object)itemEntity.bridge$getBukkitEntity());
            ItemSpawnEvent event = new ItemSpawnEvent(entity);
            event.setCancelled(true);
            cir.setReturnValue((Object)event);
        }
    }
}

