/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.izzel.arclight.common.bridge.core.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.core.network.common.ServerCommonPacketListenerBridge;
import io.izzel.arclight.common.bridge.core.network.login.ServerLoginNetHandlerBridge;
import io.izzel.arclight.common.bridge.core.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.core.server.management.PlayerListBridge;
import io.izzel.arclight.common.mod.util.VelocitySupport;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.class_1255;
import net.minecraft.class_140;
import net.minecraft.class_156;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2600;
import net.minecraft.class_2899;
import net.minecraft.class_2905;
import net.minecraft.class_2913;
import net.minecraft.class_2915;
import net.minecraft.class_2917;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3324;
import net.minecraft.class_3515;
import net.minecraft.class_3544;
import net.minecraft.class_4844;
import net.minecraft.class_5525;
import net.minecraft.class_8593;
import net.minecraft.class_8610;
import net.minecraft.class_8792;
import net.minecraft.class_9091;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetHandlerMixin
implements ServerLoginNetHandlerBridge,
CraftPlayer.TransferCookieConnection {
    @Shadow
    private class_3248.class_3249 field_14163;
    @Shadow
    @Final
    private MinecraftServer field_14162;
    @Shadow
    @Final
    public class_2535 field_14158;
    @Shadow
    @Final
    private static AtomicInteger field_14157;
    @Shadow
    @Final
    private static Logger field_14166;
    @Shadow
    @Final
    private byte[] field_14167;
    @Shadow
    @Nullable
    private String field_45028;
    @Shadow
    @Nullable
    private GameProfile field_45029;
    @Shadow
    @Final
    private boolean field_48275;
    private static final Pattern PROP_PATTERN;
    private class_3222 player;
    @Unique
    protected int arclight$velocityLoginId = -1;

    @Shadow
    public abstract void method_14380(class_2561 var1);

    @Shadow
    public abstract String method_14383();

    @Shadow
    abstract void method_52417(GameProfile var1);

    @Shadow
    protected abstract boolean method_52416(GameProfile var1);

    @Override
    public int bridge$getVelocityLoginId() {
        return this.arclight$velocityLoginId;
    }

    @Override
    public void bridge$disconnect(String s) {
        this.method_14380((class_2561)class_2561.method_43470((String)s));
    }

    public void disconnect(String s) {
        this.bridge$disconnect(s);
    }

    @Overwrite
    public void method_12641(class_2915 packetIn) {
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14170 ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)class_3544.method_57179((String)packetIn.comp_765()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.field_45028 = packetIn.comp_765();
        GameProfile gameprofile = this.field_14162.method_43824();
        if (gameprofile != null && this.field_45028.equalsIgnoreCase(gameprofile.getName())) {
            this.method_52417(gameprofile);
        } else if (this.field_14162.method_3828() && !this.field_14158.method_10756()) {
            this.field_14163 = class_3248.class_3249.field_14175;
            this.field_14158.method_10743((class_2596)new class_2905("", this.field_14162.method_3716().getPublic().getEncoded(), this.field_14167, true));
        } else {
            if (VelocitySupport.isEnabled()) {
                this.arclight$velocityLoginId = ThreadLocalRandom.current().nextInt();
                class_2899 packet = new class_2899(this.arclight$velocityLoginId, VelocitySupport.createPacket());
                this.field_14158.method_10743((class_2596)packet);
                return;
            }
            Thread thread = this.bridge$newHandleThread("User Authenticator #" + field_14157.incrementAndGet(), () -> {
                try {
                    GameProfile gameProfile = ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.field_14158, this.field_45028);
                    this.bridge$preLogin(gameProfile);
                }
                catch (Exception ex) {
                    this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                    field_14166.warn("Exception verifying {} ", (Object)this.field_45028, (Object)ex);
                }
            });
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(field_14166));
            thread.start();
        }
    }

    private static GameProfile arclight$createOfflineProfile(class_2535 connection, String name) {
        UUID uuid = ((NetworkManagerBridge)connection).bridge$getSpoofedUUID() != null ? ((NetworkManagerBridge)connection).bridge$getSpoofedUUID() : class_4844.method_43344((String)name);
        GameProfile gameProfile = new GameProfile(uuid, name);
        if (((NetworkManagerBridge)connection).bridge$getSpoofedProfile() != null) {
            for (Property property : ((NetworkManagerBridge)connection).bridge$getSpoofedProfile()) {
                if (!PROP_PATTERN.matcher(property.name()).matches()) continue;
                gameProfile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return gameProfile;
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;"))
    private class_2561 arclight$canLogin(class_3324 instance, SocketAddress socketAddress, GameProfile gameProfile) {
        if (this.player == null) {
            this.player = ((PlayerListBridge)instance).bridge$canPlayerLogin(socketAddress, gameProfile, (class_3248)this);
        }
        return null;
    }

    @Inject(method={"verifyLoginAndFinishConnectionSetup"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/players/PlayerList;canPlayerLogin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/network/chat/Component;")})
    private void arclight$returnIfFail(GameProfile p_299507_, CallbackInfo ci) {
        if (this.player == null) {
            ci.cancel();
        } else if (((CraftPlayer)this.player.bridge$getBukkitEntity()).isAwaitingCookies()) {
            ci.cancel();
        }
    }

    @Redirect(method={"verifyLoginAndFinishConnectionSetup"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;disconnectAllPlayersWithProfile(Lcom/mojang/authlib/GameProfile;)Z"))
    private boolean arclight$skipKick(class_3324 instance, GameProfile gameProfile) {
        return this.method_52416(Objects.requireNonNull(this.field_45029));
    }

    @Inject(method={"handleLoginAcknowledgement"}, at={@At(value="HEAD")})
    private void arclight$mainThreadConfiguration(class_8593 serverboundLoginAcknowledgedPacket, CallbackInfo ci) {
        class_2600.method_11074((class_2596)serverboundLoginAcknowledgedPacket, (class_2547)((class_3248)this), (class_1255)this.field_14162);
    }

    @Inject(method={"handleLoginAcknowledgement"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;setupInboundProtocol(Lnet/minecraft/network/ProtocolInfo;Lnet/minecraft/network/PacketListener;)V")})
    private void arclight$setPlayer(class_8593 p_298815_, CallbackInfo ci, class_8792 cookie, class_8610 listener) {
        ((ServerCommonPacketListenerBridge)listener).bridge$setPlayer(this.player);
    }

    @Inject(method={"handleCookieResponse"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$cookieResponse(class_9091 packet, CallbackInfo ci) {
        class_2600.method_11074((class_2596)packet, (class_2547)((class_3248)this), (class_1255)this.field_14162);
        if (this.player != null && ((CraftPlayer)this.player.bridge$getBukkitEntity()).handleCookieResponse(packet)) {
            ci.cancel();
        }
    }

    @Overwrite
    public void method_12642(class_2917 packetIn) {
        String s;
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14175 ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.field_14162.method_3716().getPrivate();
            if (!packetIn.method_43643(this.field_14167, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packetIn.method_12654(privatekey);
            Cipher cipher = class_3515.method_15235((int)2, (Key)secretKey);
            Cipher cipher1 = class_3515.method_15235((int)1, (Key)secretKey);
            s = new BigInteger(class_3515.method_15240((String)"", (PublicKey)this.field_14162.method_3716().getPublic(), (SecretKey)secretKey)).toString(16);
            this.field_14163 = class_3248.class_3249.field_14169;
            this.field_14158.method_10746(cipher, cipher1);
        }
        catch (class_5525 cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        Thread thread = this.bridge$newHandleThread("User Authenticator #" + field_14157.incrementAndGet(), () -> {
            String name = Objects.requireNonNull(this.field_45028, "Player name not initialized");
            try {
                SocketAddress socketaddress = this.field_14158.method_10755();
                InetAddress address = this.field_14162.method_3775() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
                ProfileResult profileResult = this.field_14162.method_3844().hasJoinedServer(name, s, address);
                if (profileResult != null) {
                    GameProfile gameProfile = profileResult.profile();
                    if (!this.field_14158.method_10758()) {
                        return;
                    }
                    this.bridge$preLogin(gameProfile);
                } else if (this.field_14162.method_3724()) {
                    field_14166.warn("Failed to verify username but will let them in anyway!");
                    this.method_52417(ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.field_14158, name));
                } else {
                    this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                    field_14166.error("Username '{}' tried to join with an invalid session", (Object)name);
                }
            }
            catch (AuthenticationException e) {
                if (this.field_14162.method_3724()) {
                    field_14166.warn("Authentication servers are down but will let them in anyway!");
                    this.method_52417(ServerLoginNetHandlerMixin.arclight$createOfflineProfile(this.field_14158, name));
                } else {
                    this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.authservers_down"));
                    field_14166.error("Couldn't verify username because servers are unavailable");
                }
            }
            catch (Exception e) {
                this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                field_14166.error("Exception verifying " + name, (Throwable)e);
            }
        });
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(field_14166));
        thread.start();
    }

    @Override
    @Unique
    public void bridge$preLogin(GameProfile gameProfile) throws Exception {
        if (this.arclight$velocityLoginId == -1 && VelocitySupport.isEnabled()) {
            this.disconnect("This server requires you to connect with Velocity.");
            return;
        }
        String playerName = gameProfile.getName();
        InetAddress address = ((InetSocketAddress)this.field_14158.method_10755()).getAddress();
        UUID uniqueId = gameProfile.getId();
        final CraftServer craftServer = (CraftServer)Bukkit.getServer();
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        craftServer.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            class SyncPreLogin
            extends Waitable<PlayerPreLoginEvent.Result> {
                SyncPreLogin() {
                }

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    craftServer.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            }
            SyncPreLogin waitable = new SyncPreLogin();
            ((MinecraftServerBridge)this.field_14162).bridge$queuedProcess(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        field_14166.info("UUID of player {} is {}", (Object)gameProfile.getName(), (Object)gameProfile.getId());
        this.method_52417(gameProfile);
    }

    @Inject(method={"handleCustomQueryPacket"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$modernForwardReply(class_2913 packet, CallbackInfo ci) {
        if (VelocitySupport.isEnabled() && packet.comp_1569() == this.bridge$getVelocityLoginId()) {
            class_2540 payload = this.bridge$getDiscardedQueryAnswerData(packet);
            if (payload == null) {
                this.bridge$disconnect("This server requires you to connect with Velocity.");
                ci.cancel();
                return;
            }
            class_2540 buf = (class_2540)payload.method_43827(r -> {
                int i = r.readableBytes();
                if (i >= 0 && i <= 0x100000) {
                    return new class_2540(r.readBytes(i));
                }
                throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
            });
            if (buf == null) {
                this.bridge$disconnect("This server requires you to connect with Velocity.");
                ci.cancel();
                return;
            }
            if (!VelocitySupport.checkIntegrity(buf)) {
                this.bridge$disconnect("Unable to verify player details");
                ci.cancel();
                return;
            }
            int version = buf.method_10816();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.field_14158.method_10755();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.field_14158.field_11645 = new InetSocketAddress(VelocitySupport.readAddress(buf), port);
            this.field_45029 = VelocitySupport.createProfile(buf);
            class_156.method_18349().execute(() -> {
                try {
                    this.bridge$preLogin(this.field_45029);
                }
                catch (Exception ex) {
                    this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                    field_14166.warn("Exception verifying {} ", (Object)this.field_45029.getName(), (Object)ex);
                }
            });
            this.bridge$platform$onCustomQuery(packet);
            ci.cancel();
        }
    }

    @Override
    public boolean isTransferred() {
        return this.field_48275;
    }

    @Override
    public class_2539 getProtocol() {
        return class_2539.field_20593;
    }

    @Override
    public void sendPacket(class_2596<?> packet) {
        this.field_14158.method_10743(packet);
    }

    static {
        PROP_PATTERN = Pattern.compile("\\w{0,16}");
    }
}

