/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.level;

import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.server.ChunkHolderBridge;
import io.izzel.arclight.common.bridge.core.world.server.ChunkMapBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.core.world.server.TicketManagerBridge;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_2794;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3194;
import net.minecraft.class_3204;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3898;
import net.minecraft.class_5217;
import net.minecraft.class_8563;
import org.bukkit.entity.SpawnCategory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_3215.class})
public abstract class ServerChunkCacheMixin
implements ServerChunkProviderBridge {
    @Shadow
    @Final
    class_3227 field_13921;
    @Shadow
    @Final
    public class_3898 field_17254;
    @Shadow
    @Final
    public class_3218 field_13945;
    @Shadow
    @Final
    private class_3204 field_17252;

    @Shadow
    public abstract void method_17298(boolean var1);

    @Shadow
    protected abstract void method_20587();

    @Shadow
    @Nullable
    protected abstract class_3193 method_14131(long var1);

    @Override
    @Invoker(value="runDistanceManagerUpdates")
    public abstract boolean bridge$tickDistanceManager();

    @Override
    @Accessor(value="lightEngine")
    public abstract class_3227 bridge$getLightManager();

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        class_3193 chunk = ((ChunkMapBridge)this.field_17254).bridge$chunkHolderAt(class_1923.method_8331((int)chunkX, (int)chunkZ));
        return chunk != null && ((ChunkHolderBridge)chunk).bridge$getFullChunk() != null;
    }

    public class_2818 getChunkUnchecked(int chunkX, int chunkZ) {
        class_3193 chunk = ((ChunkMapBridge)this.field_17254).bridge$chunkHolderAt(class_1923.method_8331((int)chunkX, (int)chunkZ));
        if (chunk == null) {
            return null;
        }
        return ((ChunkHolderBridge)chunk).bridge$getFullChunkUnchecked();
    }

    @Override
    public boolean bridge$isChunkLoaded(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    @Override
    public void bridge$setChunkGenerator(class_2794 chunkGenerator) {
        ((ChunkMapBridge)this.field_17254).bridge$setChunkGenerator(chunkGenerator);
    }

    @Override
    public void bridge$setViewDistance(int viewDistance) {
        ((ChunkMapBridge)this.field_17254).bridge$setViewDistance(viewDistance);
    }

    @ModifyVariable(method={"getChunkFutureMainThread"}, index=4, at=@At(value="HEAD"))
    private boolean arclight$skipIfUnloading(boolean flag, int chunkX, int chunkZ) {
        if (flag) {
            class_3193 chunkholder = this.method_14131(class_1923.method_8331((int)chunkX, (int)chunkZ));
            if (chunkholder != null) {
                class_3194 chunkStatus = class_8563.method_51830((int)((ChunkHolderBridge)chunkholder).bridge$getOldTicketLevel());
                class_3194 currentStatus = class_8563.method_51830((int)chunkholder.method_14005());
                return !chunkStatus.method_14014(class_3194.field_44855) || currentStatus.method_14014(class_3194.field_44855);
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z"))
    private boolean arclight$noPlayer(class_1928 gameRules, class_1928.class_4313<class_1928.class_4310> key) {
        return gameRules.method_8355(key) && !this.field_13945.method_18456().isEmpty();
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelData;getGameTime()J"))
    private long arclight$ticksPer(class_5217 worldInfo) {
        long gameTime = worldInfo.method_188();
        long ticksPer = ((WorldBridge)this.field_13945).bridge$ticksPerSpawnCategory().getLong((Object)SpawnCategory.ANIMAL);
        return ticksPer != 0L && gameTime % ticksPer == 0L ? 0L : 1L;
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.method_17298(true);
        }
        this.field_13921.close();
        this.field_17254.close();
    }

    public void purgeUnload() {
        this.field_13945.method_16107().method_15396("purge");
        ((TicketManagerBridge)this.field_17252).bridge$tick();
        this.bridge$tickDistanceManager();
        this.field_13945.method_16107().method_15405("unload");
        ((ChunkMapBridge)this.field_17254).bridge$tick(() -> true);
        this.field_13945.method_16107().method_15407();
        this.method_20587();
    }

    @Override
    public void bridge$close(boolean save) throws IOException {
        this.close(save);
    }

    @Override
    public void bridge$purgeUnload() {
        this.purgeUnload();
    }

    @Redirect(method={"chunkAbsent"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ChunkHolder;getTicketLevel()I"))
    public int arclight$useOldTicketLevel(class_3193 chunkHolder) {
        return ((ChunkHolderBridge)chunkHolder).bridge$getOldTicketLevel();
    }
}

