/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.level;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.core.world.ExplosionBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerWorldBridge;
import io.izzel.arclight.common.bridge.core.world.storage.DerivedWorldInfoBridge;
import io.izzel.arclight.common.bridge.core.world.storage.LevelStorageSourceBridge;
import io.izzel.arclight.common.bridge.core.world.storage.MapDataBridge;
import io.izzel.arclight.common.bridge.core.world.storage.WorldInfoBridge;
import io.izzel.arclight.common.mixin.core.world.level.LevelMixin;
import io.izzel.arclight.common.mod.mixins.annotation.CreateConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.ShadowConstructor;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.world.LevelPersistentData;
import io.izzel.arclight.common.mod.server.world.WorldSymlink;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.DelegateWorldInfo;
import io.izzel.arclight.common.mod.util.DistValidate;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_26;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_27;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3536;
import net.minecraft.class_3949;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5579;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8565;
import net.minecraft.class_9209;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R1.util.WorldUUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin
extends LevelMixin
implements ServerWorldBridge {
    @Shadow
    @Final
    private List<class_3222> field_18261;
    @Shadow
    @Final
    private class_3215 field_24624;
    @Shadow
    @Final
    public static class_2338 field_25144;
    @Shadow
    @Final
    public class_5268 field_24456;
    @Shadow
    @Final
    private class_5579<class_1297> field_26935;
    public class_31 K;
    public class_32.class_5143 convertable;
    public UUID uuid;
    public class_5321<class_5363> typeKey;
    private transient boolean arclight$force;
    private transient LightningStrikeEvent.Cause arclight$cause;
    private transient CreatureSpawnEvent.SpawnReason arclight$reason;
    private transient boolean arclight$timeSkipCancelled;

    @Shadow
    public abstract boolean method_8649(class_1297 var1);

    @Shadow
    public abstract boolean method_18768(class_1297 var1);

    @Shadow
    public abstract <T extends class_2394> int method_14199(T var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    @Shadow
    protected abstract boolean method_14191(class_3222 var1, boolean var2, double var3, double var5, double var7, class_2596<?> var9);

    @Override
    @Shadow
    @Nonnull
    public abstract MinecraftServer method_8503();

    @Shadow
    public abstract class_3215 method_14178();

    @Shadow
    protected abstract void method_23660();

    @Shadow
    public abstract class_26 method_17983();

    @Shadow
    protected abstract void method_18771(class_3222 var1);

    @Override
    public class_5321<class_5363> getTypeKey() {
        return this.typeKey;
    }

    @ShadowConstructor
    public void arclight$constructor(MinecraftServer minecraftServer, Executor backgroundExecutor, class_32.class_5143 levelSave, class_5268 worldInfo, class_5321<class_1937> dimension, class_5363 levelStem, class_3949 statusListener, boolean isDebug, long seed, List<class_5304> specialSpawners, boolean shouldBeTicking, class_8565 seq) {
        throw new RuntimeException();
    }

    @CreateConstructor
    public void arclight$constructor(MinecraftServer minecraftServer, Executor backgroundExecutor, class_32.class_5143 levelSave, class_31 worldInfo, class_5321<class_1937> dimension, class_5363 levelStem, class_3949 statusListener, boolean isDebug, long seed, List<class_5304> specialSpawners, boolean shouldBeTicking, class_8565 seq, World.Environment env, ChunkGenerator gen, BiomeProvider biomeProvider) {
        this.arclight$constructor(minecraftServer, backgroundExecutor, levelSave, (class_5268)worldInfo, dimension, levelStem, statusListener, isDebug, seed, specialSpawners, shouldBeTicking, seq);
        this.generator = gen;
        this.environment = env;
        this.biomeProvider = biomeProvider;
        if (gen != null) {
            CustomChunkGenerator generator = new CustomChunkGenerator((class_3218)this, this.field_24624.method_12129(), gen);
            ((ServerChunkProviderBridge)this.field_24624).bridge$setChunkGenerator(generator);
        }
        this.bridge$getWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(MinecraftServer minecraftServer, Executor backgroundExecutor, class_32.class_5143 levelSave, class_5268 worldInfo, class_5321<class_1937> dimension, class_5363 levelStem, class_3949 statusListener, boolean isDebug, long seed, List<class_5304> specialSpawners, boolean shouldBeTicking, class_8565 seq, CallbackInfo ci) {
        this.pvpMode = minecraftServer.method_3852();
        this.convertable = levelSave;
        class_5321<class_5363> typeKey = ((LevelStorageSourceBridge.LevelStorageAccessBridge)levelSave).bridge$getTypeKey();
        if (typeKey != null) {
            this.typeKey = typeKey;
        } else {
            class_2378 dimensions = this.method_8503().method_30611().method_30530(class_7924.field_41224);
            Optional key = dimensions.method_29113((Object)levelStem);
            if (key.isPresent()) {
                this.typeKey = (class_5321)key.get();
            } else {
                ArclightServer.LOGGER.warn("Assign {} to unknown level stem {}", (Object)dimension.method_29177(), (Object)levelStem);
                this.typeKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)dimension.method_29177());
            }
        }
        if (worldInfo instanceof class_31) {
            this.K = (class_31)worldInfo;
        } else if (worldInfo instanceof class_27) {
            this.K = DelegateWorldInfo.wrap((class_27)worldInfo);
            ((DerivedWorldInfoBridge)worldInfo).bridge$setDimType(this.getTypeKey());
            if (ArclightConfig.spec().getCompat().isSymlinkWorld()) {
                WorldSymlink.create((class_27)worldInfo, levelSave.method_27424(this.method_27983()).toFile());
            }
        }
        this.spigotConfig = new SpigotWorldConfig(worldInfo.method_150());
        this.uuid = WorldUUID.getUUID(levelSave.method_27424(this.method_27983()).toFile());
        ((ServerChunkProviderBridge)this.field_24624).bridge$setViewDistance(this.spigotConfig.viewDistance);
        ((WorldInfoBridge)this.K).bridge$setWorld((class_3218)this);
        LevelPersistentData data = (LevelPersistentData)this.method_17983().method_17924(LevelPersistentData.factory(), "bukkit_pdc");
        this.bridge$getWorld().readBukkitValues((class_2520)data.getTag());
    }

    @Inject(method={"saveLevelData"}, at={@At(value="RETURN")})
    private void arclight$savePdc(CallbackInfo ci) {
        LevelPersistentData data = (LevelPersistentData)this.method_17983().method_17924(LevelPersistentData.factory(), "bukkit_pdc");
        data.save(this.world);
    }

    @Inject(method={"gameEvent"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$gameEventEvent(class_6880<class_5712> holder, class_243 pos, class_5712.class_7397 context, CallbackInfo ci) {
        class_1297 entity = context.comp_713();
        int i = ((class_5712)holder.comp_349()).comp_2193();
        GenericGameEvent event = new GenericGameEvent(GameEvent.getByKey(CraftNamespacedKey.fromMinecraft(class_7923.field_41171.method_10221((Object)((class_5712)holder.comp_349())))), new Location(this.getWorld(), pos.method_10216(), pos.method_10214(), pos.method_10215()), entity == null ? null : entity.bridge$getBukkitEntity(), i, !Bukkit.isPrimaryThread());
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    public class_2818 getChunkIfLoaded(int x, int z) {
        return this.field_24624.method_12126(x, z, false);
    }

    public <T extends class_2394> int sendParticles(class_3222 sender, T t0, double d0, double d1, double d2, int i, double d3, double d4, double d5, double d6, boolean force) {
        class_2675 packet = new class_2675(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i);
        int j = 0;
        for (class_3222 entity : this.field_18261) {
            if (sender != null && !((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)sender).bridge$getBukkitEntity()) || !this.method_14191(entity, force, d0, d1, d2, (class_2596<?>)packet)) continue;
            ++j;
        }
        return j;
    }

    @Override
    public class_32.class_5143 bridge$getConvertable() {
        return this.convertable;
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private void arclight$tickPortal(class_1297 entityIn, CallbackInfo ci) {
        ((EntityBridge)entityIn).bridge$postTick();
    }

    @Inject(method={"tickPassenger"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/Entity;rideTick()V")})
    private void arclight$tickPortalPassenger(class_1297 ridingEntity, class_1297 passengerEntity, CallbackInfo ci) {
        ((EntityBridge)passengerEntity).bridge$postTick();
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/server/level/ServerLevel;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    public void arclight$thunder(class_2818 chunkIn, int randomTickSpeed, CallbackInfo ci) {
        this.bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.LIGHTNING);
    }

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/server/level/ServerLevel;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean arclight$thunder(class_3218 serverWorld, class_1297 entityIn) {
        return this.strikeLightning(entityIn, LightningStrikeEvent.Cause.WEATHER);
    }

    public boolean strikeLightning(class_1297 entity) {
        return this.strikeLightning(entity, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(class_1297 entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning;
        if (this.arclight$cause != null) {
            cause = this.arclight$cause;
            this.arclight$cause = null;
        }
        if (DistValidate.isValid(this) && (lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)((Object)((EntityBridge)entity).bridge$getBukkitEntity()), cause)).isCancelled()) {
            return false;
        }
        return this.method_8649(entity);
    }

    @Redirect(method={"tickPrecipitation"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    public boolean arclight$snowForm(class_3218 serverWorld, class_2338 pos, class_2680 state) {
        return CraftEventFactory.handleBlockFormEvent((class_1937)serverWorld, pos, state, null);
    }

    @Inject(method={"save"}, at={@At(value="JUMP", ordinal=0, opcode=198)})
    private void arclight$worldSaveEvent(class_3536 progress, boolean flush, boolean skipSave, CallbackInfo ci) {
        if (DistValidate.isValid(this)) {
            Bukkit.getPluginManager().callEvent(new WorldSaveEvent(this.bridge$getWorld()));
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    private void arclight$saveLevelDat(class_3536 progress, boolean flush, boolean skipSave, CallbackInfo ci) {
        class_5268 class_52682 = this.field_24456;
        if (class_52682 instanceof class_31) {
            class_31 worldInfo = (class_31)class_52682;
            worldInfo.method_27415(this.method_8621().method_27355());
            worldInfo.method_221(this.method_8503().method_3837().method_12974((class_7225.class_7874)this.method_30349()));
            this.convertable.method_27426((class_5455)this.method_8503().method_30611(), (class_5219)worldInfo, this.method_8503().method_3760().method_14567());
        }
    }

    @Inject(method={"unload"}, at={@At(value="HEAD")})
    public void arclight$closeOnChunkUnloading(class_2818 chunkIn, CallbackInfo ci) {
        for (class_2586 tileentity : chunkIn.method_12214().values()) {
            if (!(tileentity instanceof class_1263)) continue;
            for (HumanEntity h : Lists.newArrayList(((IInventoryBridge)tileentity).getViewers())) {
                if (!(h instanceof CraftHumanEntity)) continue;
                ((CraftHumanEntity)h).getHandle().method_7346();
            }
        }
    }

    @Redirect(method={"sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/server/level/ServerPlayer;ZDDDLnet/minecraft/network/protocol/Packet;)Z"))
    public boolean arclight$particleVisible(class_3218 serverWorld, class_3222 player, boolean longDistance, double posX, double posY, double posZ, class_2596<?> packet) {
        return this.method_14191(player, this.arclight$force, posX, posY, posZ, packet);
    }

    public <T extends class_2394> int sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        this.arclight$force = force;
        return this.method_14199(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed);
    }

    @Override
    public <T extends class_2394> int bridge$sendParticles(T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, boolean force) {
        return this.sendParticles(type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed, force);
    }

    @Override
    public void bridge$pushStrikeLightningCause(LightningStrikeEvent.Cause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public void bridge$strikeLightning(class_1538 entity, LightningStrikeEvent.Cause cause) {
        this.strikeLightning((class_1297)entity, cause);
    }

    @Inject(method={"addEntity"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;addNewEntity(Lnet/minecraft/world/level/entity/EntityAccess;)Z")})
    private void arclight$addEntityEvent(class_1297 entityIn, CallbackInfoReturnable<Boolean> cir) {
        CreatureSpawnEvent.SpawnReason reason = this.arclight$reason == null ? CreatureSpawnEvent.SpawnReason.DEFAULT : this.arclight$reason;
        this.arclight$reason = null;
        if (DistValidate.isValid(this) && !CraftEventFactory.doEntityAddEventCalling((class_1937)((class_3218)this), entityIn, reason)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"addEntity"}, at={@At(value="RETURN")})
    public void arclight$resetReason(class_1297 entityIn, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$reason = null;
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        this.arclight$reason = reason;
    }

    @Override
    public CreatureSpawnEvent.SpawnReason bridge$getAddEntityReason() {
        return this.arclight$reason;
    }

    public boolean addFreshEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.method_8649(entity);
    }

    @Override
    public boolean bridge$addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addFreshEntity(entity, reason);
    }

    public boolean addWithUUID(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.bridge$pushAddEntityReason(reason);
        return this.method_18768(entity);
    }

    public void addDuringTeleport(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.method_18771(player);
        } else {
            this.addFreshEntity(entity, reason);
        }
    }

    @Override
    public boolean bridge$addEntitySerialized(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addWithUUID(entity, reason);
    }

    public boolean tryAddFreshEntityWithPassengers(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.method_24204().map(class_1297::method_5667).anyMatch(arg_0 -> this.field_26935.method_31827(arg_0))) {
            return false;
        }
        return this.bridge$addAllEntities(entity, reason);
    }

    @Override
    public boolean bridge$addAllEntitiesSafely(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.tryAddFreshEntityWithPassengers(entity, reason);
    }

    @Decorate(method={"explode"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Explosion;interactsWithBlocks()Z"))
    private void arclight$doExplosion(@Local(ordinal=-1) class_1927 explosion) throws Throwable {
        if (((ExplosionBridge)explosion).bridge$wasCancelled()) {
            DecorationOps.cancel().invoke(explosion);
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Inject(method={"getMapData"}, at={@At(value="RETURN")})
    private void arclight$mapSetId(class_9209 id, CallbackInfoReturnable<class_22> cir) {
        class_22 data = (class_22)cir.getReturnValue();
        if (data != null) {
            ((MapDataBridge)data).bridge$setId(id);
        }
    }

    @Inject(method={"setMapData"}, at={@At(value="HEAD")})
    private void arclight$mapSetId(class_9209 id, class_22 data, CallbackInfo ci) {
        ((MapDataBridge)data).bridge$setId(id);
        MapInitializeEvent event = new MapInitializeEvent(((MapDataBridge)data).bridge$getMapView());
        Bukkit.getServer().getPluginManager().callEvent(event);
    }

    @Inject(method={"blockUpdated"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;updateNeighborsAt(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;)V")})
    private void arclight$returnIfPopulate(class_2338 pos, class_2248 block, CallbackInfo ci) {
        if (this.populating) {
            ci.cancel();
        }
    }

    @Override
    public class_2586 getBlockEntity(class_2338 pos, boolean validate) {
        return this.method_8321(pos);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V"))
    private void arclight$timeSkip(class_3218 world, long time) {
        TimeSkipEvent event = new TimeSkipEvent(this.bridge$getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, time - time % 24000L - this.method_8532());
        Bukkit.getPluginManager().callEvent(event);
        this.arclight$timeSkipCancelled = event.isCancelled();
        if (!event.isCancelled()) {
            world.method_29199(this.method_8532() + event.getSkipAmount());
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;wakeUpAllPlayers()V"))
    private void arclight$notWakeIfCancelled(class_3218 world) {
        if (!this.arclight$timeSkipCancelled) {
            this.method_23660();
        }
        this.arclight$timeSkipCancelled = false;
    }

    @Override
    public class_3218 bridge$getMinecraftWorld() {
        return (class_3218)this;
    }

    @ModifyVariable(method={"tickBlock"}, ordinal=0, argsOnly=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"))
    private class_2338 arclight$captureTickingBlock(class_2338 pos) {
        ArclightCaptures.captureTickingBlock((class_3218)this, pos);
        return pos;
    }

    @ModifyVariable(method={"tickBlock"}, ordinal=0, argsOnly=true, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"))
    private class_2338 arclight$resetTickingBlock(class_2338 pos) {
        ArclightCaptures.resetTickingBlock();
        return pos;
    }

    @ModifyVariable(method={"tickChunk"}, ordinal=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;randomTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"))
    private class_2338 arclight$captureRandomTick(class_2338 pos) {
        ArclightCaptures.captureTickingBlock((class_3218)this, pos);
        return pos;
    }

    @ModifyVariable(method={"tickChunk"}, ordinal=0, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/block/state/BlockState;randomTick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"))
    private class_2338 arclight$resetRandomTick(class_2338 pos) {
        ArclightCaptures.resetTickingBlock();
        return pos;
    }

    @ModifyVariable(method={"tickNonPassenger"}, argsOnly=true, ordinal=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V"))
    private class_1297 arclight$captureTickingEntity(class_1297 entity) {
        ArclightCaptures.captureTickingEntity(entity);
        return entity;
    }

    @ModifyVariable(method={"tickNonPassenger"}, argsOnly=true, ordinal=0, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/Entity;tick()V"))
    private class_1297 arclight$resetTickingEntity(class_1297 entity) {
        ArclightCaptures.resetTickingEntity();
        return entity;
    }

    @ModifyVariable(method={"tickPassenger"}, argsOnly=true, ordinal=1, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;rideTick()V"))
    private class_1297 arclight$captureTickingPassenger(class_1297 entity) {
        ArclightCaptures.captureTickingEntity(entity);
        return entity;
    }

    @ModifyVariable(method={"tickPassenger"}, argsOnly=true, ordinal=1, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/Entity;rideTick()V"))
    private class_1297 arclight$resetTickingPassenger(class_1297 entity) {
        ArclightCaptures.resetTickingEntity();
        return entity;
    }
}

