/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.server.management;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.core.network.datasync.SynchedEntityDataBridge;
import io.izzel.arclight.common.bridge.core.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.core.server.management.PlayerListBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Eject;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2663;
import net.minecraft.class_2668;
import net.minecraft.class_29;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3248;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import net.minecraft.class_3324;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_3442;
import net.minecraft.class_4273;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6682;
import net.minecraft.class_7659;
import net.minecraft.class_7780;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public abstract class PlayerListMixin
implements PlayerListBridge {
    @Shadow
    @Final
    public class_29 field_14358;
    @Shadow
    @Final
    private class_3335 field_14344;
    @Shadow
    @Final
    private static SimpleDateFormat field_14356;
    @Shadow
    @Final
    private class_3317 field_14345;
    @Shadow
    @Final
    public List<class_3222> field_14351;
    @Shadow
    public int field_14347;
    @Shadow
    @Final
    private MinecraftServer field_14360;
    @Shadow
    @Final
    private Map<UUID, class_3222> field_14354;
    private CraftServer cserver;
    private transient Location arclight$loc;
    private transient PlayerRespawnEvent.RespawnReason arclight$respawnReason;

    @Override
    @Accessor(value="players")
    @Mutable
    public abstract void bridge$setPlayers(List<class_3222> var1);

    @Override
    @Accessor(value="players")
    public abstract List<class_3222> bridge$getPlayers();

    @Shadow
    public abstract boolean method_14587(GameProfile var1);

    @Shadow
    public abstract boolean method_14609(GameProfile var1);

    @Shadow
    protected abstract void method_14577(class_3222 var1);

    @Shadow
    public abstract class_3335 method_14563();

    @Shadow
    public abstract class_3317 method_14585();

    @Shadow
    public abstract void method_14606(class_3222 var1, class_3218 var2);

    @Shadow
    public abstract void method_14576(class_3222 var1);

    @Shadow
    public abstract void method_14594(class_3222 var1);

    @Shadow
    @Nullable
    public abstract class_3222 method_14602(UUID var1);

    @Shadow
    public abstract void method_43514(class_2561 var1, boolean var2);

    @Shadow
    public abstract void method_60598(class_3222 var1);

    @Shadow
    public abstract class_3222 method_14556(class_3222 var1, boolean var2, class_1297.class_5529 var3);

    @Override
    public CraftServer bridge$getCraftServer() {
        return this.cserver;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$loadServer(MinecraftServer minecraftServer, class_7780<class_7659> p_251844_, class_29 p_203844_, int p_203845_, CallbackInfo ci) {
        this.cserver = ArclightServer.createOrLoad((class_3176)minecraftServer, (class_3324)this);
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/server/level/ServerLevel;"))
    private class_3218 arclight$spawnLocationEvent(MinecraftServer minecraftServer, class_5321<class_1937> dimension, class_2535 netManager, class_3222 playerIn) {
        CraftPlayer player = ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity();
        PlayerSpawnLocationEvent event = new PlayerSpawnLocationEvent(player, player.getLocation());
        this.cserver.getPluginManager().callEvent(event);
        Location loc = event.getSpawnLocation();
        class_3218 world = ((CraftWorld)loc.getWorld()).getHandle();
        playerIn.method_51468(world);
        playerIn.method_5641(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        return world;
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/players/PlayerList;viewDistance:I"))
    private int arclight$spigotViewDistance(class_3324 playerList, class_2535 netManager, class_3222 playerIn) {
        return ((WorldBridge)playerIn.method_51469()).bridge$spigotConfig().viewDistance;
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="FIELD", target="Lnet/minecraft/server/players/PlayerList;simulationDistance:I"))
    private int arclight$spigotSimDistance(class_3324 instance, class_2535 netManager, class_3222 playerIn) {
        return ((WorldBridge)playerIn.method_51469()).bridge$spigotConfig().simulationDistance;
    }

    @Eject(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"))
    private void arclight$playerJoin(class_3324 playerList, class_2561 component, boolean flag, CallbackInfo ci, class_2535 netManager, class_3222 playerIn) {
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity(), CraftChatMessage.fromComponent(component));
        this.field_14351.add(playerIn);
        this.field_14354.put(playerIn.method_5667(), playerIn);
        this.cserver.getPluginManager().callEvent(playerJoinEvent);
        this.field_14351.remove(playerIn);
        if (!playerIn.field_13987.method_48106()) {
            ci.cancel();
            return;
        }
        String joinMessage = playerJoinEvent.getJoinMessage();
        if (joinMessage != null && joinMessage.length() > 0) {
            for (class_2561 line : CraftChatMessage.fromString(joinMessage)) {
                this.field_14360.method_3760().method_43514(line, flag);
            }
        }
    }

    @Redirect(method={"placeNewPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addNewPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private void arclight$addNewPlayer(class_3218 instance, class_3222 player) {
        if (player.method_37908() == instance && !instance.method_18456().contains(player)) {
            instance.method_18213(player);
        }
    }

    @ModifyVariable(method={"placeNewPlayer"}, ordinal=1, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/level/ServerLevel;addNewPlayer(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private class_3218 arclight$handleWorldChanges(class_3218 value, class_2535 connection, class_3222 player) {
        return player.method_51469();
    }

    @Inject(method={"save"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnIfNotPersist(class_3222 playerIn, CallbackInfo ci) {
        if (!((ServerPlayerEntityBridge)playerIn).bridge$isPersist()) {
            ci.cancel();
        }
    }

    @Inject(method={"remove"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;save(Lnet/minecraft/server/level/ServerPlayer;)V")})
    private void arclight$playerQuitPre(class_3222 playerIn, CallbackInfo ci) {
        if (playerIn.field_7498 != playerIn.field_7512) {
            ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().closeInventory();
        }
        String quitMessage = ArclightCaptures.getQuitMessage();
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity(), (String)(quitMessage != null ? quitMessage : "\u00a7e" + playerIn.method_5820() + " left the game"));
        this.cserver.getPluginManager().callEvent(playerQuitEvent);
        ((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        ArclightCaptures.captureQuitMessage(playerQuitEvent.getQuitMessage());
        this.cserver.getScoreboardManager().removePlayer(((ServerPlayerEntityBridge)playerIn).bridge$getBukkitEntity());
    }

    @Override
    public class_3222 bridge$canPlayerLogin(SocketAddress socketAddress, GameProfile gameProfile, class_3248 handler) {
        UUID uuid = gameProfile.getId();
        ArrayList list = Lists.newArrayList();
        for (class_3222 entityplayer : this.field_14351) {
            if (!entityplayer.method_5667().equals(uuid)) continue;
            list.add(entityplayer);
        }
        for (class_3222 entityplayer : list) {
            this.method_14577(entityplayer);
            entityplayer.field_13987.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.duplicate_login"));
        }
        class_3222 entity = new class_3222(this.field_14360, this.field_14360.method_3847(class_1937.field_25179), gameProfile, class_8791.method_53821());
        ((ServerPlayerEntityBridge)entity).bridge$setTransferCookieConnection((CraftPlayer.TransferCookieConnection)handler);
        CraftPlayer player = ((ServerPlayerEntityBridge)entity).bridge$getBukkitEntity();
        String hostname = handler == null ? "" : ((NetworkManagerBridge)handler.field_14158).bridge$getHostname();
        InetAddress realAddress = handler == null ? ((InetSocketAddress)socketAddress).getAddress() : ((InetSocketAddress)handler.field_14158.field_11651.remoteAddress()).getAddress();
        PlayerLoginEvent event = new PlayerLoginEvent(player, hostname, ((InetSocketAddress)socketAddress).getAddress(), realAddress);
        if (this.method_14563().method_14650(gameProfile) && !((class_3336)this.method_14563().method_14640((Object)gameProfile)).method_14627()) {
            class_3336 gameprofilebanentry = (class_3336)this.field_14344.method_14640((Object)gameProfile);
            class_5250 chatmessage = class_2561.method_43469((String)"multiplayer.disconnect.banned.reason", (Object[])new Object[]{gameprofilebanentry.method_14503()});
            if (gameprofilebanentry.method_14502() != null) {
                chatmessage.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.disconnect.banned.expiration", (Object[])new Object[]{field_14356.format(gameprofilebanentry.method_14502())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((class_2561)chatmessage));
        } else if (!this.method_14587(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.method_14585().method_14527(socketAddress) && !this.method_14585().method_14528(socketAddress).method_14627()) {
            class_3320 ipbanentry = this.field_14345.method_14528(socketAddress);
            class_5250 chatmessage = class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.reason", (Object[])new Object[]{ipbanentry.method_14503()});
            if (ipbanentry.method_14502() != null) {
                chatmessage.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.disconnect.banned_ip.expiration", (Object[])new Object[]{field_14356.format(ipbanentry.method_14502())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent((class_2561)chatmessage));
        } else if (this.field_14351.size() >= this.field_14347 && !this.method_14609(gameProfile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent(event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            if (handler != null) {
                handler.method_14380(CraftChatMessage.fromStringOrNull(event.getKickMessage()));
            }
            return null;
        }
        return entity;
    }

    public class_3222 respawn(class_3222 entityplayer, boolean flag, class_1297.class_5529 entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public class_3222 respawn(class_3222 playerIn, boolean flag, class_1297.class_5529 removalReason, PlayerRespawnEvent.RespawnReason respawnReason, Location location) {
        this.arclight$respawnReason = respawnReason;
        this.arclight$loc = location;
        return this.method_14556(playerIn, flag, removalReason);
    }

    @Override
    public void bridge$pushRespawnCause(PlayerRespawnEvent.RespawnReason respawnReason) {
        if (respawnReason != null) {
            this.arclight$respawnReason = respawnReason;
        }
    }

    @Inject(method={"respawn"}, at={@At(value="HEAD")})
    private void arclight$stopRiding(class_3222 serverPlayer, boolean bl, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir) {
        serverPlayer.method_5848();
    }

    @Decorate(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;findRespawnPositionAndUseSpawnBlock(ZLnet/minecraft/world/level/portal/DimensionTransition$PostDimensionTransition;)Lnet/minecraft/world/level/portal/DimensionTransition;"))
    private class_5454 arclight$respawnPoint(class_3222 instance, boolean bl, class_5454.class_9823 postDimensionTransition) throws Throwable {
        class_5454 dimensiontransition;
        PlayerRespawnEvent.RespawnReason respawnReason;
        Location location = this.arclight$loc;
        PlayerRespawnEvent.RespawnReason respawnReason2 = respawnReason = this.arclight$respawnReason == null ? PlayerRespawnEvent.RespawnReason.DEATH : this.arclight$respawnReason;
        if (location == null) {
            ((ServerPlayerEntityBridge)instance).bridge$pushRespawnReason(respawnReason);
            dimensiontransition = DecorationOps.callsite().invoke(instance, bl, postDimensionTransition);
        } else {
            dimensiontransition = new class_5454(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), class_243.field_1353, location.getYaw(), location.getPitch(), class_5454.field_52245);
        }
        if (dimensiontransition == null) {
            return DecorationOps.cancel().invoke(instance);
        }
        return dimensiontransition;
    }

    @Decorate(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"))
    private void arclight$restoreInv(class_3222 newPlayer, class_3222 oldPlayer, boolean bl, class_3222 serverPlayer, boolean conqueredEnd) throws Throwable {
        DecorationOps.callsite().invoke(newPlayer, oldPlayer, bl);
        if (!conqueredEnd) {
            newPlayer.method_31548().method_7377(oldPlayer.method_31548());
            newPlayer.field_7520 = oldPlayer.field_7520;
            newPlayer.field_7495 = oldPlayer.field_7495;
            newPlayer.field_7510 = oldPlayer.field_7510;
            newPlayer.method_7320(oldPlayer.method_7272());
        }
    }

    @Redirect(method={"respawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;teleport(DDDFF)V"))
    private void arclight$respawnPackets(class_3244 instance, double d, double e, double f, float g, float h) {
        class_3222 player = instance.field_14140;
        player.field_13987.method_14364((class_2596)new class_4273(((WorldBridge)player.method_51469()).bridge$spigotConfig().viewDistance));
        player.field_13987.method_14364((class_2596)new class_6682(((WorldBridge)player.method_51469()).bridge$spigotConfig().simulationDistance));
        ((ServerPlayNetHandlerBridge)player.field_13987).bridge$teleport(new Location(player.method_51469().bridge$getWorld(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455()));
    }

    @Inject(method={"respawn"}, at={@At(value="RETURN")})
    private void arclight$postRespawn(class_3222 serverPlayer, boolean bl, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir) {
        Location location = this.arclight$loc;
        this.arclight$loc = null;
        this.arclight$respawnReason = null;
        class_3218 fromWorld = serverPlayer.method_51469();
        class_3222 newPlayer = (class_3222)cir.getReturnValue();
        this.method_14594(newPlayer);
        newPlayer.method_7355();
        newPlayer.method_18783(fromWorld);
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)((ServerPlayerEntityBridge)newPlayer).bridge$getBukkitEntity(), fromWorld.bridge$getWorld());
            Bukkit.getPluginManager().callEvent(event);
        }
        if (((ServerPlayNetHandlerBridge)newPlayer.field_13987).bridge$isDisconnected()) {
            this.method_14577(newPlayer);
        }
    }

    public void broadcastAll(class_2596<?> packet, class_1657 entityhuman) {
        for (class_3222 entityplayer : this.field_14351) {
            if (entityhuman instanceof class_3222 && !((ServerPlayerEntityBridge)entityplayer).bridge$getBukkitEntity().canSee(((ServerPlayerEntityBridge)entityhuman).bridge$getBukkitEntity())) continue;
            entityplayer.field_13987.method_14364(packet);
        }
    }

    public void broadcastAll(class_2596<?> packet, class_1937 world) {
        for (int i = 0; i < world.method_18456().size(); ++i) {
            ((class_3222)world.method_18456().get((int)i)).field_13987.method_14364(packet);
        }
    }

    @Inject(method={"sendPlayerPermissionLevel(Lnet/minecraft/server/level/ServerPlayer;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCommands()Lnet/minecraft/commands/Commands;")})
    private void arclight$calculatePerms(class_3222 player, int permLevel, CallbackInfo ci) {
        ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity().recalculatePermissions();
    }

    @Redirect(method={"sendAllPlayerInfo"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;resetSentInfo()V"))
    private void arclight$useScaledHealth(class_3222 playerEntity) {
        ((ServerPlayerEntityBridge)playerEntity).bridge$getBukkitEntity().updateScaledHealth();
        ((SynchedEntityDataBridge)playerEntity.method_5841()).bridge$refresh(playerEntity);
        int i = playerEntity.method_37908().method_8450().method_8355(class_1928.field_19401) ? 22 : 23;
        playerEntity.field_13987.method_14364((class_2596)new class_2663((class_1297)playerEntity, (byte)i));
        float immediateRespawn = playerEntity.method_37908().method_8450().method_8355(class_1928.field_20638) ? 1.0f : 0.0f;
        playerEntity.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25656, immediateRespawn));
    }

    public void broadcastMessage(class_2561[] components) {
        for (class_2561 component : components) {
            this.method_43514(component, false);
        }
    }

    @Override
    public void bridge$sendMessage(class_2561[] components) {
        this.broadcastMessage(components);
    }

    public class_3442 getPlayerStats(class_3222 entityhuman) {
        class_3442 serverstatisticmanager = entityhuman.method_14248();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.method_5667(), entityhuman.method_5477().getString()) : serverstatisticmanager;
    }

    public class_3442 getPlayerStats(UUID uuid, String displayName) {
        class_3222 entityhuman = this.method_14602(uuid);
        class_3442 serverstatisticmanager = entityhuman == null ? null : entityhuman.method_14248();
        class_3442 serverStatisticsManager = serverstatisticmanager;
        if (serverstatisticmanager == null) {
            File file2;
            File file = this.field_14360.method_27050(class_5218.field_24181).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && (file2 = new File(file, displayName + ".json")).exists() && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new class_3442(this.field_14360, file1);
        }
        return serverstatisticmanager;
    }

    @Inject(method={"remove"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;stopRiding()V")})
    private void arclight$removeMount(class_3222 serverPlayer, CallbackInfo ci) {
        serverPlayer.method_5668().method_31748().forEach(entity -> ((EntityBridge)entity).bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.PLAYER_QUIT));
    }
}

