/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.decoration;

import com.google.common.collect.Lists;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.world.entity.LivingEntityMixin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3218;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1531.class})
public abstract class ArmorStandMixin
extends LivingEntityMixin {
    @Shadow
    private boolean field_7111;
    @Shadow
    @Final
    private class_2371<class_1799> field_7114;
    @Shadow
    @Final
    private class_2371<class_1799> field_7108;

    @Override
    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Override
    public float getBukkitYaw() {
        return this.method_36454();
    }

    @Inject(method={"hurt"}, cancellable=true, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V")})
    public void arclight$damageDropOut(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((class_1297)((class_1531)this), source, amount)) {
            cir.setReturnValue((Object)false);
        } else {
            this.arclight$callEntityDeath(source);
        }
    }

    @Inject(method={"hurt"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/tags/DamageTypeTags;IS_EXPLOSION:Lnet/minecraft/tags/TagKey;")})
    public void arclight$damageNormal(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent((class_1297)((class_1531)this), source, amount, true, this.field_7111)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"hurt"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/decoration/ArmorStand;invisible:Z"))
    private boolean arclight$softenCondition(class_1531 entity) {
        return false;
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V")})
    private void arclight$damageDeath0(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$callEntityDeath(source);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V")})
    private void arclight$damageDeath1(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$callEntityDeath(source);
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", ordinal=2, target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V")})
    private void arclight$damageDeath2(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.arclight$callEntityDeath(source);
    }

    @Inject(method={"causeDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;kill()V")})
    private void arclight$deathEvent2(class_3218 serverLevel, class_1282 damageSource, float f, CallbackInfo ci) {
        this.arclight$callEntityDeath(damageSource);
    }

    @Redirect(method={"brokenByAnything"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/ArmorStand;dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V"))
    private void arclight$dropLater(class_1531 instance, class_3218 serverLevel, class_1282 damageSource) {
    }

    @Redirect(method={"brokenByAnything"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;popResource(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V"))
    private void arclight$captureDropsDeath(class_1937 worldIn, class_2338 pos, class_1799 stack) {
        this.arclight$tryCaptureDrops(worldIn, pos, stack);
    }

    @Inject(method={"brokenByAnything"}, at={@At(value="RETURN")})
    private void arclight$spawnLast(class_3218 serverLevel, class_1282 damageSource, CallbackInfo ci) {
        this.method_16080(serverLevel, damageSource);
    }

    @Override
    protected boolean method_6054() {
        return true;
    }

    private void arclight$tryCaptureDrops(class_1937 worldIn, class_2338 pos, class_1799 stack) {
        if (!worldIn.field_9236 && !stack.method_7960() && worldIn.method_8450().method_8355(class_1928.field_19392) && !((WorldBridge)worldIn).bridge$forge$restoringBlockSnapshots()) {
            class_1542 itementity = new class_1542(worldIn, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
            if (!this.bridge$common$isCapturingDrops()) {
                this.bridge$common$startCaptureDrops();
            }
            this.bridge$common$captureDrop(itementity);
        }
    }

    private void arclight$callEntityDeath(class_1282 damageSource) {
        this.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.DEATH);
        Collection<class_1542> captureDrops = this.bridge$common$getCapturedDrops();
        List<Object> drops = captureDrops == null ? new ArrayList() : (captureDrops instanceof List ? Lists.transform((List)((List)captureDrops), e -> CraftItemStack.asCraftMirror(e.method_6983())) : captureDrops.stream().map(class_1542::method_6983).map(CraftItemStack::asCraftMirror).collect(Collectors.toList()));
        CraftEventFactory.callEntityDeathEvent((class_1309)((class_1531)this), damageSource == null ? this.method_48923().method_51847() : damageSource, drops);
    }

    @Inject(method={"swapItem"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;hasInfiniteMaterials()Z")})
    public void arclight$manipulateEvent(class_1657 playerEntity, class_1304 slotType, class_1799 itemStack, class_1268 hand, CallbackInfoReturnable<Boolean> cir) {
        class_1799 itemStack1 = this.method_6118(slotType);
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemStack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(itemStack);
        CraftPlayer player = ((ServerPlayerEntityBridge)playerEntity).bridge$getBukkitEntity();
        ArmorStand self = (ArmorStand)((Object)this.bridge$getBukkitEntity());
        EquipmentSlot slot = CraftEquipmentSlot.getSlot(slotType);
        EquipmentSlot bukkitHand = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent event = new PlayerArmorStandManipulateEvent(player, self, playerHeldItem, armorStandItem, slot, bukkitHand);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void onEquipItem(class_1304 slotIn, class_1799 stack, boolean silent) {
        switch (slotIn.method_5925()) {
            case field_6177: {
                this.bridge$playEquipSound(slotIn, (class_1799)this.field_7114.set(slotIn.method_5927(), (Object)stack), stack, silent);
                break;
            }
            case field_6178: {
                this.bridge$playEquipSound(slotIn, (class_1799)this.field_7108.set(slotIn.method_5927(), (Object)stack), stack, silent);
            }
        }
    }
}

