/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.player;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.core.entity.LivingEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.core.util.FoodStatsBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mixin.core.world.entity.LivingEntityMixin;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1542;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_8103;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends LivingEntityMixin
implements PlayerEntityBridge {
    @Shadow
    @Final
    private class_1656 field_7503;
    @Shadow
    private long field_19428;
    @Shadow
    public int field_7520;
    @Shadow
    @Final
    private class_1661 field_7514;
    @Shadow
    public class_1703 field_7512;
    @Shadow
    @Final
    public class_1723 field_7498;
    @Shadow
    public float field_7510;
    @Shadow
    public int field_7495;
    @Shadow
    protected class_1702 field_7493;
    @Shadow
    protected class_1730 field_7486;
    @Shadow
    public int field_7487;
    public boolean fauxSleeping;
    public int oldLevel;
    protected transient boolean arclight$forceSleep;
    private EntityExhaustionEvent.ExhaustionReason arclight$exhaustReason;

    @Override
    @Shadow
    public abstract String method_5820();

    @Shadow
    public abstract float method_7261(float var1);

    @Shadow
    public abstract void method_7350();

    @Override
    @Shadow
    public abstract class_3419 method_5634();

    @Shadow
    public abstract float method_6029();

    @Shadow
    public abstract void method_7263();

    @Shadow
    public abstract void method_7277(class_1297 var1);

    @Shadow
    public abstract void method_7304(class_1297 var1);

    @Shadow
    public abstract void method_7339(class_2960 var1, int var2);

    @Shadow
    public abstract void method_7322(float var1);

    @Shadow
    public abstract void method_7345(class_2487 var1);

    @Shadow
    public abstract void method_7273(class_2487 var1);

    @Shadow
    public abstract class_2487 method_7308();

    @Shadow
    public abstract class_2487 method_7356();

    @Shadow
    public abstract void method_7259(class_3445<?> var1);

    @Shadow
    public abstract void method_7281(class_2960 var1);

    @Shadow
    public abstract class_2561 method_5476();

    @Shadow
    public abstract class_1306 method_6068();

    @Shadow
    protected boolean method_6062() {
        return false;
    }

    @Shadow
    public abstract class_269 method_7327();

    @Shadow
    public abstract Either<class_1657.class_1658, class_3902> method_7269(class_2338 var1);

    @Shadow
    public abstract GameProfile method_7334();

    @Shadow
    public abstract class_1661 method_31548();

    @Shadow
    public abstract class_1656 method_31549();

    @Shadow
    public abstract void method_43120(Optional<class_4208> var1);

    @Shadow
    public abstract Optional<class_4208> method_43122();

    @Shadow
    public abstract void method_20803(int var1);

    @Shadow
    public abstract boolean method_7337();

    @Shadow
    public abstract class_1702 method_7344();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(CallbackInfo ci) {
        this.oldLevel = -1;
        ((FoodStatsBridge)this.field_7493).bridge$setEntityHuman((class_1657)this);
        ((IInventoryBridge)this.field_7486).setOwner(this.getBukkitEntity());
    }

    @Override
    public boolean bridge$isFauxSleeping() {
        return this.fauxSleeping;
    }

    @Inject(method={"turtleHelmetTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z")})
    private void arclight$turtleHelmet(CallbackInfo ci) {
        this.bridge$pushEffectCause(EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;heal(F)V")})
    private void arclight$healByRegen(CallbackInfo ci) {
        this.bridge$pushHealReason(EntityRegainHealthEvent.RegainReason.REGEN);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="RETURN", ordinal=1)})
    private void arclight$playerDropItem(class_1799 droppedItem, boolean dropAround, boolean traceItem, CallbackInfoReturnable<class_1542> cir, double d0, class_1542 itemEntity) {
        Player player = (Player)((Object)this.getBukkitEntity());
        Item drop = (Item)((Object)itemEntity.bridge$getBukkitEntity());
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (traceItem && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (traceItem && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(drop.getItemStack());
            }
            cir.setReturnValue(null);
        }
    }

    @Override
    @Overwrite
    public boolean method_5643(class_1282 source, float amount) {
        boolean damaged;
        if (this.method_5679(source)) {
            return false;
        }
        if (this.field_7503.field_7480 && !source.method_48789(class_8103.field_42242)) {
            return false;
        }
        this.field_6278 = 0;
        if (this.method_6032() <= 0.0f) {
            return false;
        }
        if (source.method_5514()) {
            if (this.method_37908().method_8407() == class_1267.field_5801) {
                return false;
            }
            if (this.method_37908().method_8407() == class_1267.field_5805) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.method_37908().method_8407() == class_1267.field_5807) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.method_5643(source, amount)) {
            this.method_7262();
        }
        return damaged;
    }

    @Overwrite
    public boolean method_7256(class_1657 entityhuman) {
        Team team;
        if (entityhuman instanceof class_3222) {
            class_3222 thatPlayer = (class_3222)entityhuman;
            team = ((ServerPlayerEntityBridge)thatPlayer).bridge$getBukkitEntity().getScoreboard().getPlayerTeam(((ServerPlayerEntityBridge)thatPlayer).bridge$getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = Bukkit.getOfflinePlayer(entityhuman.method_5820());
            team = Bukkit.getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof class_3222) {
            return !team.hasPlayer(((ServerPlayerEntityBridge)((Object)this)).bridge$getBukkitEntity());
        }
        return !team.hasPlayer(Bukkit.getOfflinePlayer(this.method_5820()));
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V"))
    private void arclight$skipResetAttackStrength(class_1657 instance) {
    }

    @Decorate(method={"attack"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;deflect(Lnet/minecraft/world/entity/projectile/ProjectileDeflection;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;Z)Z"))
    private void arclight$nonLivingDamage(class_1297 entity, @Local(ordinal=-1) class_1282 damageSource, @Local(ordinal=1) float enchantDamage) throws Throwable {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damageSource, enchantDamage, false)) {
            DecorationOps.cancel().invoke();
            return;
        }
        DecorationOps.blackhole().invoke();
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/entity/ai/attributes/Attributes;SWEEPING_DAMAGE_RATIO:Lnet/minecraft/core/Holder;")))
    private void arclight$skipKnockback(class_1309 instance, double d, double e, double f) {
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean arclight$applyKnockback(class_1309 instance, class_1282 damageSource, float f) throws Throwable {
        boolean result = DecorationOps.callsite().invoke(instance, damageSource, f);
        if (result) {
            ((LivingEntityBridge)instance).bridge$pushKnockbackCause((class_1297)this, EntityKnockbackEvent.KnockbackCause.SWEEP_ATTACK);
            instance.method_6005((double)0.4f, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
        }
        return result;
    }

    @Decorate(method={"attack"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/world/entity/Entity;hurtMarked:Z"))
    private boolean arclight$velocityEvent(class_1297 entity, @Local(ordinal=-1) class_243 deltaMovement) throws Throwable {
        boolean result = DecorationOps.callsite().invoke(entity);
        if (result) {
            Player player = (Player)((Object)entity.bridge$getBukkitEntity());
            Vector velocity = CraftVector.toBukkit(deltaMovement);
            PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                result = false;
            } else if (!velocity.equals(event.getVelocity())) {
                player.setVelocity(event.getVelocity());
            }
        }
        return result;
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V")})
    private void arclight$foodExhaust(class_1297 entity, CallbackInfo ci) {
        this.bridge$pushExhaustReason(EntityExhaustionEvent.ExhaustionReason.ATTACK);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/sounds/SoundEvents;PLAYER_ATTACK_NODAMAGE:Lnet/minecraft/sounds/SoundEvent;"))})
    private void arclight$updateInv(class_1297 entity, CallbackInfo ci) {
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof ServerPlayerEntityBridge) {
            ServerPlayerEntityBridge b = (ServerPlayerEntityBridge)((Object)playerMixin);
            b.bridge$getBukkitEntity().updateInventory();
        }
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;eat(Lnet/minecraft/world/food/FoodProperties;)V")})
    private void arclight$eatStack(class_1937 level, class_1799 itemStack, class_4174 foodProperties, CallbackInfoReturnable<class_1799> cir) {
        ((FoodStatsBridge)this.method_7344()).bridge$pushEatStack(itemStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Either<class_1657.class_1658, class_3902> startSleepInBed(class_2338 at, boolean force) {
        this.arclight$forceSleep = force;
        try {
            Either<class_1657.class_1658, class_3902> either = this.method_7269(at);
            return either;
        }
        finally {
            this.arclight$forceSleep = false;
        }
    }

    @Override
    public Either<class_1657.class_1658, class_3902> bridge$trySleep(class_2338 at, boolean force) {
        return this.startSleepInBed(at, force);
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;sleepCounter:I")})
    private void arclight$wakeup(boolean flag, boolean flag1, CallbackInfo ci) {
        class_2338 blockPos = this.method_18398().orElse(null);
        CraftHumanEntity craftHumanEntity = this.bridge$getBukkitEntity();
        if (craftHumanEntity instanceof Player) {
            Player player = (Player)((Object)craftHumanEntity);
            Block bed = blockPos != null ? CraftBlock.at((class_1936)this.method_37908(), blockPos) : ((WorldBridge)this.method_37908()).bridge$getWorld().getBlockAt(player.getLocation());
            PlayerBedLeaveEvent event = new PlayerBedLeaveEvent(player, bed, true);
            Bukkit.getPluginManager().callEvent(event);
        }
    }

    @ModifyArg(method={"jumpFromGround"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;causeFoodExhaustion(F)V"))
    private float arclight$exhaustInfo(float f) {
        SpigotWorldConfig config = ((WorldBridge)this.method_37908()).bridge$spigotConfig();
        if (config != null) {
            if (this.method_5624()) {
                f = config.jumpSprintExhaustion;
                this.bridge$pushExhaustReason(EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
            } else {
                f = config.jumpWalkExhaustion;
                this.bridge$pushExhaustReason(EntityExhaustionEvent.ExhaustionReason.JUMP);
            }
        }
        return f;
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setSharedFlag(IZ)V"))
    private void arclight$toggleGlide(class_1657 playerEntity, int flag, boolean set) {
        if (playerEntity.method_5795(flag) != set && !CraftEventFactory.callToggleGlideEvent((class_1309)((class_1657)this), set).isCancelled()) {
            playerEntity.method_5729(flag, set);
        }
    }

    @Inject(method={"startFallFlying"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$startGlidingEvent(CallbackInfo ci) {
        if (CraftEventFactory.callToggleGlideEvent((class_1309)((class_1657)this), true).isCancelled()) {
            this.method_5729(7, true);
            this.method_5729(7, false);
            ci.cancel();
        }
    }

    @Inject(method={"stopFallFlying"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$stopGlidingEvent(CallbackInfo ci) {
        if (CraftEventFactory.callToggleGlideEvent((class_1309)((class_1657)this), false).isCancelled()) {
            ci.cancel();
        }
    }

    @Overwrite
    protected void method_7262() {
        if (this.field_19428 + 20L < this.method_37908().method_8510()) {
            if (this.respawnEntityOnShoulder(this.method_7356())) {
                this.method_7273(new class_2487());
            }
            if (this.respawnEntityOnShoulder(this.method_7308())) {
                this.method_7345(new class_2487());
            }
        }
    }

    private boolean respawnEntityOnShoulder(class_2487 nbttagcompound) {
        return this.method_37908().field_9236 || nbttagcompound.method_33133() || class_1299.method_5892((class_2487)nbttagcompound, (class_1937)this.method_37908()).map(entity -> {
            if (entity instanceof class_1321) {
                ((class_1321)entity).method_6174(this.field_6021);
            }
            entity.method_5814(this.method_23317(), this.method_23318() + (double)0.7f, this.method_23321());
            return ((ServerWorldBridge)this.method_37908()).bridge$addEntitySerialized((class_1297)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }).orElse(true) != false;
    }

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)this.internal$getBukkitEntity();
    }

    @Override
    public CraftHumanEntity bridge$getBukkitEntity() {
        return (CraftHumanEntity)this.internal$getBukkitEntity();
    }

    @Override
    public void onEquipItem(class_1304 slot, class_1799 stack, boolean silent) {
        this.method_37410(stack);
        if (slot == class_1304.field_6173) {
            this.equipEventAndSound(slot, (class_1799)this.field_7514.field_7547.set(this.field_7514.field_7545, (Object)stack), stack, silent);
        } else if (slot == class_1304.field_6171) {
            this.equipEventAndSound(slot, (class_1799)this.field_7514.field_7544.set(0, (Object)stack), stack, silent);
        } else if (slot.method_5925() == class_1304.class_1305.field_6178) {
            this.equipEventAndSound(slot, (class_1799)this.field_7514.field_7548.set(slot.method_5927(), (Object)stack), stack, silent);
        }
    }

    @Redirect(method={"causeFoodExhaustion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V"))
    private void arclight$exhaustEvent(class_1702 foodData, float amount) {
        EntityExhaustionEvent.ExhaustionReason reason = this.arclight$exhaustReason == null ? EntityExhaustionEvent.ExhaustionReason.UNKNOWN : this.arclight$exhaustReason;
        this.arclight$exhaustReason = null;
        EntityExhaustionEvent event = CraftEventFactory.callPlayerExhaustionEvent((class_1657)this, reason, amount);
        if (!event.isCancelled()) {
            this.field_7493.method_7583(event.getExhaustion());
        }
    }

    public void applyExhaustion(float f, EntityExhaustionEvent.ExhaustionReason reason) {
        this.bridge$pushExhaustReason(reason);
        this.method_7322(f);
    }

    @Override
    public void bridge$pushExhaustReason(EntityExhaustionEvent.ExhaustionReason reason) {
        this.arclight$exhaustReason = reason;
    }

    @Override
    public double bridge$platform$getBlockReach() {
        return this.method_7337() ? 5.0 : 4.5;
    }
}

