/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.projectile;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.projectile.FishingHookBridge;
import io.izzel.arclight.common.mixin.core.world.entity.projectile.ProjectileMixin;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1536;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.bukkit.Bukkit;
import org.bukkit.entity.FishHook;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1536.class})
public abstract class FishingHookMixin
extends ProjectileMixin
implements FishingHookBridge {
    @Shadow
    public class_1297 field_7165;
    @Shadow
    private int field_7173;
    @Shadow
    @Final
    private int field_7171;
    @Shadow
    private int field_7172;
    @Shadow
    private int field_7174;
    @Shadow
    @Final
    private int field_7168;
    public int minWaitTime = 100;
    public int maxWaitTime = 600;
    public int minLureTime = 20;
    public int maxLureTime = 80;
    public float minLureAngle = 0.0f;
    public float maxLureAngle = 360.0f;
    public boolean applyLure = true;
    public boolean rainInfluenced = true;
    public boolean skyInfluenced = true;

    @Shadow
    public abstract class_1657 method_6947();

    @Shadow
    public abstract void method_6954(class_1297 var1);

    @Inject(method={"catchingFish"}, at={@At(value="FIELD", shift=At.Shift.AFTER, ordinal=0, target="Lnet/minecraft/world/entity/projectile/FishingHook;timeUntilHooked:I")})
    private void arclight$attemptFail(class_2338 blockPos, CallbackInfo ci) {
        PlayerFishEvent event = new PlayerFishEvent(((ServerPlayerEntityBridge)this.method_6947()).bridge$getBukkitEntity(), null, (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.FAILED_ATTEMPT);
        Bukkit.getPluginManager().callEvent(event);
    }

    @Inject(method={"catchingFish"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private void arclight$fishBite(class_2338 blockPos, CallbackInfo ci) {
        PlayerFishEvent event = new PlayerFishEvent(((ServerPlayerEntityBridge)this.method_6947()).bridge$getBukkitEntity(), null, (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.BITE);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRainingAt(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean arclight$rainInfluenced(class_1937 level, class_2338 pos) {
        return this.rainInfluenced && level.method_8520(pos);
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;canSeeSky(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean arclight$skyInfluenced(class_1937 instance, class_2338 blockPos) {
        return this.skyInfluenced && instance.method_8311(blockPos);
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", ordinal=2, target="Lnet/minecraft/util/Mth;nextFloat(Lnet/minecraft/util/RandomSource;FF)F"))
    private float arclight$lureAngleParam(class_5819 random, float p_216269_, float p_216270_) {
        return class_3532.method_15344((class_5819)random, (float)this.minLureAngle, (float)this.maxLureAngle);
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"))
    private int arclight$lureTimeParam(class_5819 random, int p_216273_, int p_216274_) {
        return class_3532.method_15395((class_5819)random, (int)this.minLureTime, (int)this.maxLureTime);
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", ordinal=2, target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"))
    private int arclight$waitTimeParam(class_5819 random, int p_216273_, int p_216274_) {
        return class_3532.method_15395((class_5819)random, (int)this.minWaitTime, (int)this.maxWaitTime);
    }

    @Redirect(method={"catchingFish"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/projectile/FishingHook;lureSpeed:I"))
    private int arclight$waitTimeParam2(class_1536 instance) {
        return this.applyLure ? this.field_7168 : 0;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void arclight$tickDespawn(CallbackInfo ci) {
        this.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.DESPAWN);
    }

    @Inject(method={"shouldStopFishing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void arclight$fishDespawn(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        this.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.DESPAWN);
    }

    @Inject(method={"retrieve"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;pullEntity(Lnet/minecraft/world/entity/Entity;)V")})
    private void arclight$catchEntity(class_1799 itemStack, CallbackInfoReturnable<Integer> cir) {
        PlayerFishEvent fishEvent = new PlayerFishEvent(((ServerPlayerEntityBridge)this.method_6947()).bridge$getBukkitEntity(), this.field_7165.bridge$getBukkitEntity(), (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.CAUGHT_ENTITY);
        Bukkit.getPluginManager().callEvent(fishEvent);
        if (fishEvent.isCancelled()) {
            cir.setReturnValue((Object)0);
        }
    }

    @Decorate(method={"retrieve"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V"))
    private void arclight$catchFish(class_1799 stack, @Local(ordinal=-1) class_1542 itementity, @Local(allocate="expToDrop") int expToDrop) throws Throwable {
        PlayerFishEvent playerFishEvent = new PlayerFishEvent(((ServerPlayerEntityBridge)this.method_6947()).bridge$getBukkitEntity(), itementity.bridge$getBukkitEntity(), (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.CAUGHT_FISH);
        playerFishEvent.setExpToDrop(this.field_5974.method_43048(6) + 1);
        Bukkit.getPluginManager().callEvent(playerFishEvent);
        if (playerFishEvent.isCancelled()) {
            DecorationOps.cancel().invoke(0);
            return;
        }
        expToDrop = playerFishEvent.getExpToDrop();
        DecorationOps.blackhole().invoke(expToDrop);
    }

    @Decorate(method={"retrieve"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"), slice=@Slice(from=@At(value="NEW", target="(Lnet/minecraft/world/level/Level;DDDI)Lnet/minecraft/world/entity/ExperienceOrb;")))
    private boolean arclight$spawnExpOrb(class_1937 instance, class_1297 entity, class_1799 stack, @Local(allocate="expToDrop") int expToDrop) throws Throwable {
        if (entity instanceof class_1303) {
            class_1303 orb = (class_1303)entity;
            if (expToDrop <= 0) {
                return false;
            }
            orb.field_6159 = expToDrop;
        }
        return DecorationOps.callsite().invoke(instance, entity);
    }

    @Inject(method={"retrieve"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;onGround()Z")})
    private void arclight$onGround(class_1799 itemStack, CallbackInfoReturnable<Integer> cir) {
        if (this.method_24828()) {
            PlayerFishEvent playerFishEvent = new PlayerFishEvent(((ServerPlayerEntityBridge)this.method_6947()).bridge$getBukkitEntity(), null, (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.IN_GROUND);
            Bukkit.getPluginManager().callEvent(playerFishEvent);
            if (playerFishEvent.isCancelled()) {
                cir.setReturnValue((Object)0);
            }
        }
    }

    @Inject(method={"retrieve"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/FishingHook;discard()V")})
    private void arclight$reelIn(class_1799 itemStack, CallbackInfoReturnable<Integer> cir, class_1657 player, int i) {
        if (i == 0) {
            PlayerFishEvent playerFishEvent = new PlayerFishEvent(((ServerPlayerEntityBridge)player).bridge$getBukkitEntity(), null, (FishHook)((Object)this.getBukkitEntity()), PlayerFishEvent.State.REEL_IN);
            Bukkit.getPluginManager().callEvent(playerFishEvent);
            if (playerFishEvent.isCancelled()) {
                cir.setReturnValue((Object)0);
                return;
            }
        }
        this.bridge$pushEntityRemoveCause(EntityRemoveEvent.Cause.DESPAWN);
    }
}

