/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.raid;

import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.raid.RaidBridge;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2135;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3765.class})
public class RaidMixin
implements RaidBridge {
    @Shadow
    @Final
    private Map<Integer, Set<class_3763>> field_16618;
    @Shadow
    @Final
    private class_3218 field_16619;
    private transient List<Player> arclight$winners;
    private transient class_3763 arclight$leader;
    private transient List<class_3763> arclight$raiders;

    @Inject(method={"tick"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/raid/Raid;stop()V")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/Difficulty;PEACEFUL:Lnet/minecraft/world/Difficulty;"))})
    public void arclight$stopPeace(CallbackInfo ci) {
        CraftEventFactory.callRaidStopEvent((class_3765)this, RaidStopEvent.Reason.PEACE);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;stop()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isVillage(Lnet/minecraft/core/BlockPos;)Z"), to=@At(value="FIELD", opcode=181, target="Lnet/minecraft/world/entity/raid/Raid;ticksActive:J"))})
    public void arclight$stopNotInVillage(CallbackInfo ci) {
        CraftEventFactory.callRaidStopEvent((class_3765)this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;stop()V")}, slice={@Slice(from=@At(value="FIELD", opcode=181, target="Lnet/minecraft/world/entity/raid/Raid;ticksActive:J"), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;getTotalRaidersAlive()I"))})
    public void arclight$stopTimeout(CallbackInfo ci) {
        CraftEventFactory.callRaidStopEvent((class_3765)this, RaidStopEvent.Reason.TIMEOUT);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;stop()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;shouldSpawnGroup()Z"), to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;isStarted()Z"))})
    public void arclight$stopUnspawnable(CallbackInfo ci) {
        CraftEventFactory.callRaidStopEvent((class_3765)this, RaidStopEvent.Reason.UNSPAWNABLE);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;stop()V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;isOver()Z"))})
    public void arclight$stopFinish(CallbackInfo ci) {
        CraftEventFactory.callRaidStopEvent((class_3765)this, RaidStopEvent.Reason.FINISHED);
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", shift=At.Shift.BY, by=2, target="Lnet/minecraft/world/entity/raid/Raid$RaidStatus;LOSS:Lnet/minecraft/world/entity/raid/Raid$RaidStatus;")})
    public void arclight$finishNone(CallbackInfo ci) {
        CraftEventFactory.callRaidFinishEvent((class_3765)this, new ArrayList<Player>());
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/PlayerTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;)V"))
    public void arclight$addWinner(class_2135 trigger, class_3222 player) {
        trigger.method_9141(player);
        if (this.arclight$winners == null) {
            this.arclight$winners = new ArrayList<Player>();
        }
        this.arclight$winners.add(((ServerPlayerEntityBridge)player).bridge$getBukkitEntity());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;setDirty()V")})
    public void arclight$finish(CallbackInfo ci) {
        ArrayList<Player> winners = this.arclight$winners == null ? new ArrayList() : this.arclight$winners;
        this.arclight$winners = null;
        CraftEventFactory.callRaidFinishEvent((class_3765)this, winners);
    }

    @Decorate(method={"spawnGroup"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;setLeader(ILnet/minecraft/world/entity/raid/Raider;)V"))
    public void arclight$captureLeader(class_3765 raid, int raidId, class_3763 entity) throws Throwable {
        DecorationOps.callsite().invoke(raid, raidId, entity);
        this.arclight$leader = entity;
    }

    @Decorate(method={"spawnGroup"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/raid/Raid;joinRaid(ILnet/minecraft/world/entity/raid/Raider;Lnet/minecraft/core/BlockPos;Z)V"))
    public void arclight$captureRaider(class_3765 raid, int wave, class_3763 entity, class_2338 pos, boolean flag) throws Throwable {
        DecorationOps.callsite().invoke(raid, wave, entity, pos, flag);
        if (this.arclight$raiders == null) {
            this.arclight$raiders = new ArrayList<class_3763>();
        }
        this.arclight$raiders.add(entity);
    }

    @Inject(method={"spawnGroup"}, at={@At(value="RETURN")})
    public void arclight$spawnWave(class_2338 pos, CallbackInfo ci) {
        CraftEventFactory.callRaidSpawnWaveEvent((class_3765)this, this.arclight$leader, this.arclight$raiders);
    }

    @Inject(method={"joinRaid(ILnet/minecraft/world/entity/raid/Raider;Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V")})
    public void arclight$addEntity(int wave, class_3763 p_221317_2_, class_2338 p_221317_3_, boolean p_221317_4_, CallbackInfo ci) {
        ((WorldBridge)this.field_16619).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.RAID);
    }

    public Collection<class_3763> getRaiders() {
        HashSet<class_3763> set = new HashSet<class_3763>();
        for (Set<class_3763> entities : this.field_16618.values()) {
            set.addAll(entities);
        }
        return set;
    }

    @Override
    public Collection<class_3763> bridge$getRaiders() {
        return this.getRaiders();
    }
}

