/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.vehicle;

import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.common.bridge.core.entity.vehicle.AbstractMinecartBridge;
import io.izzel.arclight.common.mixin.core.world.entity.vehicle.VehicleEntityMixin;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1688;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartMixin
extends VehicleEntityMixin
implements AbstractMinecartBridge {
    @Shadow
    private int field_45135;
    @Shadow
    private double field_45136;
    @Shadow
    private double field_45137;
    @Shadow
    private double field_45138;
    @Shadow
    private double field_45139;
    @Shadow
    private double field_45140;
    @Shadow
    private boolean field_7660;
    @Shadow
    private boolean field_44917;
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public double maxSpeed = 0.4;
    private transient Location arclight$prevLocation;

    @Shadow
    protected abstract void method_7513(class_2338 var1, class_2680 var2);

    @Shadow
    public abstract void method_7506(int var1, int var2, int var3, boolean var4);

    @Shadow
    public abstract class_1688.class_1689 method_7518();

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="RETURN")})
    private void arclight$init(class_1299<?> type, class_1937 worldIn, CallbackInfo ci) {
        this.slowWhenEmpty = true;
        this.derailedX = 0.5;
        this.derailedY = 0.5;
        this.derailedZ = 0.5;
        this.flyingX = 0.95;
        this.flyingY = 0.95;
        this.flyingZ = 0.95;
        this.maxSpeed = 0.4;
    }

    @Decorate(method={"tick"}, inject=true, at=@At(value="HEAD"))
    private void arclight$storePreviousLocation() {
        this.arclight$prevLocation = new Location(null, this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;setRot(FF)V")})
    private void arclight$vehicleUpdateEvent(CallbackInfo ci) {
        CraftWorld bworld = this.method_37908().bridge$getWorld();
        Location from = this.arclight$prevLocation;
        this.arclight$prevLocation = null;
        from.setWorld(bworld);
        Location to = new Location(bworld, this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        Vehicle vehicle = (Vehicle)((Object)this.getBukkitEntity());
        Bukkit.getPluginManager().callEvent(new VehicleUpdateEvent(vehicle));
        if (!from.equals(to)) {
            Bukkit.getPluginManager().callEvent(new VehicleMoveEvent(vehicle, from, to));
        }
    }

    @Decorate(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;startRiding(Lnet/minecraft/world/entity/Entity;)Z"))
    private boolean arclight$ridingCollide(class_1297 instance, class_1297 entity) throws Throwable {
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)((Object)this.getBukkitEntity()), instance.bridge$getBukkitEntity());
        Bukkit.getPluginManager().callEvent(collisionEvent);
        if (collisionEvent.isCancelled()) {
            return false;
        }
        return DecorationOps.callsite().invoke(instance, entity);
    }

    @Decorate(method={"tick"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/entity/Entity;push(Lnet/minecraft/world/entity/Entity;)V"))
    private void arclight$pushCollide(class_1297 instance, class_1297 entity) throws Throwable {
        if (!this.method_5794(instance)) {
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)((Object)this.getBukkitEntity()), instance.bridge$getBukkitEntity());
            Bukkit.getPluginManager().callEvent(collisionEvent);
            if (collisionEvent.isCancelled()) {
                return;
            }
        }
        DecorationOps.callsite().invoke(instance, entity);
    }

    @Decorate(method={"tick"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/entity/Entity;push(Lnet/minecraft/world/entity/Entity;)V"))
    private void arclight$pushCollide2(class_1297 instance, class_1297 entity) throws Throwable {
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)((Object)this.getBukkitEntity()), instance.bridge$getBukkitEntity());
        Bukkit.getPluginManager().callEvent(collisionEvent);
        if (collisionEvent.isCancelled()) {
            return;
        }
        DecorationOps.callsite().invoke(instance, entity);
    }

    @Overwrite
    protected double method_7504() {
        return this.method_5799() ? this.maxSpeed / 2.0 : this.maxSpeed;
    }

    @Overwrite
    protected void method_7512() {
        double d0 = this.method_7504();
        class_243 vec3d = this.method_18798();
        this.method_18800(class_3532.method_15350((double)vec3d.field_1352, (double)(-d0), (double)d0), vec3d.field_1351, class_3532.method_15350((double)vec3d.field_1350, (double)(-d0), (double)d0));
        if (this.field_5952) {
            this.method_18799(new class_243(this.method_18798().field_1352 * this.derailedX, this.method_18798().field_1351 * this.derailedY, this.method_18798().field_1350 * this.derailedZ));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (!this.field_5952) {
            this.method_18799(new class_243(this.method_18798().field_1352 * this.flyingX, this.method_18798().field_1351 * this.flyingY, this.method_18798().field_1350 * this.flyingZ));
        }
    }

    @Redirect(method={"applyNaturalSlowdown"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;isVehicle()Z"))
    private boolean arclight$slowWhenEmpty(class_1688 abstractMinecartEntity) {
        return this.method_5782() || !this.slowWhenEmpty;
    }

    @Inject(method={"push"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/AbstractMinecart;hasPassenger(Lnet/minecraft/world/entity/Entity;)Z")})
    private void arclight$vehicleCollide(class_1297 entityIn, CallbackInfo ci) {
        if (!this.method_5626(entityIn)) {
            VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)((Object)this.getBukkitEntity()), ((EntityBridge)entityIn).bridge$getBukkitEntity());
            Bukkit.getPluginManager().callEvent(collisionEvent);
            if (collisionEvent.isCancelled()) {
                ci.cancel();
            }
        }
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }
}

