/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.inventory;

import io.izzel.arclight.common.bridge.core.entity.player.PlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.core.inventory.EnchantmentMenuBridge;
import io.izzel.arclight.common.bridge.core.inventory.container.PosContainerBridge;
import io.izzel.arclight.common.bridge.core.util.IWorldPosCallableBridge;
import io.izzel.arclight.common.mixin.core.world.inventory.AbstractContainerMenuMixin;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_3914;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class}, priority=39)
public abstract class EnchantmentContainerMixin
extends AbstractContainerMenuMixin
implements PosContainerBridge,
EnchantmentMenuBridge {
    @Shadow
    @Final
    private class_1263 field_7809;
    @Shadow
    @Final
    private class_3914 field_7813;
    @Shadow
    @Final
    public int[] field_7808;
    @Shadow
    @Final
    public int[] field_7812;
    @Shadow
    @Final
    public int[] field_7810;
    private CraftInventoryView bukkitEntity = null;
    private class_1661 playerInventory;
    private transient boolean arclight$enchantable;
    private transient int arclight$power;

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    public void arclight$init(int id, class_1661 playerInventory, class_3914 worldPosCallable, CallbackInfo ci) {
        this.playerInventory = playerInventory;
    }

    @Inject(method={"stillValid"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$unreachable(class_1657 playerIn, CallbackInfoReturnable<Boolean> cir) {
        if (!this.bridge$isCheckReachable()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Decorate(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEnchantable()Z"))
    private boolean arclight$relaxCondition(class_1799 instance) throws Throwable {
        this.arclight$enchantable = DecorationOps.callsite().invoke(instance);
        return true;
    }

    @Decorate(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantmentCost(Lnet/minecraft/util/RandomSource;IILnet/minecraft/world/item/ItemStack;)I"))
    private int arclight$lastPower(class_5819 random, int i, int power, class_1799 arg) throws Throwable {
        this.arclight$power = power;
        return DecorationOps.callsite().invoke(random, i, this.arclight$power, arg);
    }

    @Decorate(method={"*"}, inject=true, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;broadcastChanges()V"))
    private void arclight$prepareEnchantEvent(@Local(ordinal=0) class_1799 itemstack, @Local(ordinal=0) class_1937 level) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41265);
        CraftItemStack item = CraftItemStack.asCraftMirror(itemstack);
        EnchantmentOffer[] offers = new EnchantmentOffer[3];
        for (int j = 0; j < 3; ++j) {
            Enchantment enchantment = this.field_7812[j] >= 0 ? Enchantment.getByKey(CraftNamespacedKey.fromMinecraft(registry.method_10221((Object)((class_1887)registry.method_10200(this.field_7812[j]))))) : null;
            offers[j] = enchantment != null ? new EnchantmentOffer(enchantment, this.field_7810[j], this.field_7808[j]) : null;
        }
        PrepareItemEnchantEvent event = new PrepareItemEnchantEvent(((ServerPlayerEntityBridge)this.playerInventory.field_7546).bridge$getBukkitEntity(), this.getBukkitView(), ((IWorldPosCallableBridge)this.field_7813).bridge$getLocation().getBlock(), item, offers, this.arclight$power);
        event.setCancelled(!this.arclight$enchantable);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            for (int j = 0; j < 3; ++j) {
                this.field_7808[j] = 0;
                this.field_7812[j] = -1;
                this.field_7810[j] = -1;
            }
            return;
        }
        for (int j = 0; j < 3; ++j) {
            EnchantmentOffer offer = event.getOffers()[j];
            if (offer != null) {
                this.field_7808[j] = offer.getCost();
                this.field_7812[j] = registry.method_10206((Object)((class_1887)registry.method_10223(CraftNamespacedKey.toMinecraft(offer.getEnchantment().getKey()))));
                this.field_7810[j] = offer.getEnchantmentLevel();
                continue;
            }
            this.field_7808[j] = 0;
            this.field_7812[j] = -1;
            this.field_7810[j] = -1;
        }
    }

    @Decorate(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;"), slice=@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onEnchantmentPerformed(Lnet/minecraft/world/item/ItemStack;I)V")))
    private List<class_1889> arclight$itemEnchantEvent(class_1718 instance, class_5455 registryAccess, class_1799 itemStack, int i, int j, @Local(ordinal=-1) class_1937 level, @Local(ordinal=-1) class_1657 playerIn) throws Throwable {
        List list = DecorationOps.callsite().invoke(instance, registryAccess, itemStack, i, j);
        class_2359 registry = level.method_30349().method_30530(class_7924.field_41265).method_40295();
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        for (class_1889 enchantmentInstance : list) {
            enchants.put(CraftEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)enchantmentInstance.field_9093), enchantmentInstance.field_9094);
        }
        CraftItemStack item = CraftItemStack.asCraftMirror(itemStack);
        Enchantment hintedEnchantment = CraftEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)((class_6880)registry.method_10200(this.field_7812[i])));
        int hintedEnchantmentLevel = this.field_7810[i];
        EnchantItemEvent event = new EnchantItemEvent((Player)((Object)((PlayerEntityBridge)playerIn).bridge$getBukkitEntity()), this.getBukkitView(), ((IWorldPosCallableBridge)this.field_7813).bridge$getLocation().getBlock(), item, this.field_7808[i], enchants, hintedEnchantment, hintedEnchantmentLevel, i);
        Bukkit.getPluginManager().callEvent(event);
        int levelCost = event.getExpLevelCost();
        if (event.isCancelled() || levelCost > playerIn.field_7520 && !playerIn.method_31549().field_7477 || event.getEnchantsToAdd().isEmpty()) {
            return DecorationOps.cancel().invoke();
        }
        ArrayList<class_1889> newList = new ArrayList<class_1889>();
        for (Map.Entry<Enchantment, Integer> entry : event.getEnchantsToAdd().entrySet()) {
            class_6880<class_1887> nms = CraftEnchantment.bukkitToMinecraftHolder(entry.getKey());
            if (nms == null) continue;
            class_1889 enchantmentInstance = new class_1889(nms, entry.getValue().intValue());
            newList.add(enchantmentInstance);
        }
        return newList;
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryEnchanting inventory = new CraftInventoryEnchanting(this.field_7809);
        this.bukkitEntity = new CraftInventoryView(((PlayerEntityBridge)this.playerInventory.field_7546).bridge$getBukkitEntity(), inventory, (class_1703)this);
        return this.bukkitEntity;
    }

    @Override
    public class_3914 bridge$getWorldPos() {
        return this.field_7813;
    }
}

