/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.izzel.arclight.common.bridge.core.entity.EntityBridge;
import io.izzel.arclight.common.bridge.core.util.DamageSourceBridge;
import io.izzel.arclight.common.bridge.core.world.ExplosionBridge;
import io.izzel.arclight.mixin.Decorate;
import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2680;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class ExplosionMixin
implements ExplosionBridge {
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_1927.class_4179 field_9184;
    @Shadow
    @Mutable
    @Final
    private float field_9190;
    @Shadow
    @Final
    private ObjectArrayList<class_2338> field_9188;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    public class_1297 field_9185;
    @Shadow
    @Final
    @Mutable
    private class_1282 field_9193;
    public float yield;
    public boolean wasCanceled = false;

    @Override
    @Accessor(value="source")
    public abstract class_1297 bridge$getExploder();

    @Override
    @Accessor(value="radius")
    public abstract float bridge$getSize();

    @Override
    @Accessor(value="radius")
    public abstract void bridge$setSize(float var1);

    @Override
    @Accessor(value="blockInteraction")
    public abstract class_1927.class_4179 bridge$getMode();

    @Override
    public float bridge$getYield() {
        return this.yield;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;)V"}, at={@At(value="RETURN")})
    public void arclight$adjustSize(class_1937 worldIn, class_1297 exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, class_1927.class_4179 modeIn, CallbackInfo ci) {
        this.field_9190 = Math.max(sizeIn, 0.0f);
        this.yield = this.field_9184 == class_1927.class_4179.field_40879 ? 1.0f / this.field_9190 : 1.0f;
        this.field_9193 = ((DamageSourceBridge)(this.field_9193 == null ? worldIn.method_48963().method_48807((class_1927)this) : this.field_9193)).bridge$customCausingEntity(exploderIn);
    }

    @Inject(method={"explode"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$returnRadius(CallbackInfo ci) {
        if (this.field_9190 < 0.1f) {
            ci.cancel();
        }
    }

    @Decorate(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private boolean arclight$handleMultiPart(class_1297 entity, class_1282 damageSource, float f, @Local(ordinal=-1) List<class_1297> list) throws Throwable {
        if (((EntityBridge)entity).bridge$forge$isPartEntity()) {
            throw DecorationOps.jumpToLoopStart();
        }
        ((EntityBridge)entity).bridge$setLastDamageCancelled(false);
        boolean result = false;
        class_1297[] parts = ((EntityBridge)entity).bridge$forge$getParts();
        if (parts != null) {
            for (class_1297 part : parts) {
                if (!list.contains(part)) continue;
                result |= part.method_5643(damageSource, f);
            }
        } else {
            result = DecorationOps.callsite().invoke(entity, damageSource, f);
        }
        if (((EntityBridge)entity).bridge$isLastDamageCancelled()) {
            throw DecorationOps.jumpToLoopStart();
        }
        return result;
    }

    @Decorate(method={"explode"}, at=@At(value="NEW", ordinal=0, target="(DDD)Lnet/minecraft/world/phys/Vec3;"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/ExplosionDamageCalculator;getKnockbackMultiplier(Lnet/minecraft/world/entity/Entity;)F")))
    private class_243 arclight$knockBack(double d, double e, double f, @Local(ordinal=-1) class_1297 entity) throws Throwable {
        class_243 vec3 = DecorationOps.callsite().invoke(d, e, f);
        double dx = entity.method_23317() - this.field_9195;
        double dy = entity.method_23320() - this.field_9192;
        double dz = entity.method_23321() - this.field_9189;
        double force = dx * dx + dy * dy + dz * dz;
        if (entity instanceof class_1309) {
            class_243 result = entity.method_18798().method_1019(vec3);
            EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity.bridge$getBukkitEntity(), this.field_9185, EntityKnockbackEvent.KnockbackCause.EXPLOSION, force, vec3, result.field_1352, result.field_1351, result.field_1350);
            vec3 = event.isCancelled() ? class_243.field_1353 : new class_243(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).method_1020(entity.method_18798());
        }
        return vec3;
    }

    @Override
    public boolean bridge$wasCancelled() {
        return this.wasCanceled;
    }

    @Inject(method={"finalizeExplosion"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/Util;shuffle(Ljava/util/List;Lnet/minecraft/util/RandomSource;)V")})
    private void arclight$blockExplode(boolean bl, CallbackInfo ci) {
        if (this.callBlockExplodeEvent()) {
            this.wasCanceled = true;
            ci.cancel();
        }
    }

    @Decorate(method={"finalizeExplosion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onExplosionHit(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;Ljava/util/function/BiConsumer;)V"))
    private void arclight$tntPrime(class_2680 instance, class_1937 level, class_2338 pos, class_1927 explosion, BiConsumer<?, ?> biConsumer) throws Throwable {
        if (instance.method_26204() instanceof class_2530) {
            class_2338 sourceBlock;
            class_1297 sourceEntity = this.field_9185 == null ? null : this.field_9185;
            class_2338 class_23382 = sourceBlock = sourceEntity == null ? class_2338.method_49637((double)this.field_9195, (double)this.field_9192, (double)this.field_9189) : null;
            if (!CraftEventFactory.callTNTPrimeEvent(this.field_9187, pos, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                this.field_9187.method_8413(pos, class_2246.field_10124.method_9564(), instance, 3);
                return;
            }
        }
        DecorationOps.callsite().invoke(instance, level, pos, explosion, biConsumer);
    }

    @Redirect(method={"finalizeExplosion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean arclight$blockIgnite(class_1937 instance, class_2338 blockPos, class_2680 blockState) throws Throwable {
        BlockIgniteEvent event = CraftEventFactory.callBlockIgniteEvent(this.field_9187, blockPos, (class_1927)this);
        if (event.isCancelled()) {
            return false;
        }
        return DecorationOps.callsite().invoke(instance, blockPos, blockState);
    }

    @Inject(method={"addOrAppendStack"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$fix(List<Pair<class_1799, class_2338>> p_311090_, class_1799 stack, class_2338 p_309821_, CallbackInfo ci) {
        if (stack.method_7960()) {
            ci.cancel();
        }
    }

    private boolean callBlockExplodeEvent() {
        List<Block> bukkitBlocks;
        boolean cancelled;
        Block block;
        CraftWorld world = this.field_9187.bridge$getWorld();
        CraftEntity exploder = this.field_9185 == null ? null : this.field_9185.bridge$getBukkitEntity();
        Location location = new Location(world, this.field_9195, this.field_9192, this.field_9189);
        ArrayList blockList = Lists.newArrayList();
        for (int i = this.field_9188.size() - 1; i >= 0; --i) {
            class_2338 blockPos = (class_2338)this.field_9188.get(i);
            block = world.getBlockAt(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            if (block.getType().isAir()) continue;
            blockList.add(block);
        }
        if (exploder != null) {
            EntityExplodeEvent event = new EntityExplodeEvent(exploder, location, blockList, this.field_9184 == class_1927.class_4179.field_40879 ? 1.0f / this.field_9190 : 1.0f);
            Bukkit.getPluginManager().callEvent(event);
            cancelled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        } else {
            block = location.getBlock();
            BlockState blockState = ((DamageSourceBridge)this.field_9193).bridge$directBlockState() != null ? ((DamageSourceBridge)this.field_9193).bridge$directBlockState() : block.getState();
            BlockExplodeEvent event = new BlockExplodeEvent(block, blockState, blockList, this.field_9184 == class_1927.class_4179.field_40879 ? 1.0f / this.field_9190 : 1.0f);
            Bukkit.getPluginManager().callEvent(event);
            cancelled = event.isCancelled();
            bukkitBlocks = event.blockList();
            this.yield = event.getYield();
        }
        this.field_9188.clear();
        for (Block block2 : bukkitBlocks) {
            class_2338 blockPos = new class_2338(block2.getX(), block2.getY(), block2.getZ());
            this.field_9188.add((Object)blockPos);
        }
        return cancelled;
    }
}

