/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.level;

import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.border.WorldBorderBridge;
import io.izzel.arclight.common.bridge.core.world.level.levelgen.ChunkGeneratorBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.core.world.server.ServerWorldBridge;
import io.izzel.arclight.common.mod.ArclightConstants;
import io.izzel.arclight.common.mod.mixins.annotation.CreateConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.ShadowConstructor;
import io.izzel.arclight.common.mod.mixins.annotation.TransformAccess;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.world.WrappedWorlds;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2794;
import net.minecraft.class_2818;
import net.minecraft.class_2874;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1937.class})
public abstract class LevelMixin
implements WorldBridge,
class_1936,
class_1945 {
    @Shadow
    @Final
    private class_2784 field_9223;
    @Shadow
    @Final
    public boolean field_9236;
    protected CraftWorld world;
    public boolean pvpMode;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public boolean populating;
    public ChunkGenerator generator;
    protected World.Environment environment;
    protected BiomeProvider biomeProvider;
    public SpigotWorldConfig spigotConfig;
    @TransformAccess(value=9)
    private static class_2338 lastPhysicsProblem;
    public boolean preventPoiUpdated = false;
    public Map<class_2338, CapturedBlockState> capturedBlockStates = new LinkedHashMap<class_2338, CapturedBlockState>();
    public Map<class_2338, class_2586> capturedTileEntities = new HashMap<class_2338, class_2586>();
    private transient class_1927.class_4179 arclight$blockInteractionOverride;

    @Shadow
    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        return null;
    }

    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Shadow
    public abstract class_2784 method_8621();

    @Shadow
    public abstract long method_8532();

    @Shadow
    public abstract MinecraftServer method_8503();

    @Shadow
    public abstract class_5217 method_8401();

    @Shadow
    public abstract class_5321<class_1937> method_27983();

    @Shadow
    public abstract class_2874 method_8597();

    @Shadow
    public abstract void method_16109(class_2338 var1, class_2680 var2, class_2680 var3);

    @Shadow
    public abstract void method_8413(class_2338 var1, class_2680 var2, class_2680 var3, int var4);

    @Shadow
    public abstract void method_8455(class_2338 var1, class_2248 var2);

    @Shadow
    public abstract void method_19282(class_2338 var1, class_2680 var2, class_2680 var3);

    @Shadow
    public abstract class_5455 method_30349();

    @Accessor(value="thread")
    public abstract Thread arclight$getMainThread();

    @ShadowConstructor
    public void arclight$constructor(class_5269 worldInfo, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimensionType, Supplier<class_3695> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdate) {
        throw new RuntimeException();
    }

    @CreateConstructor
    public void arclight$constructor(class_5269 worldInfo, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimensionType, Supplier<class_3695> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdate, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.arclight$constructor(worldInfo, dimension, registryAccess, dimensionType, profiler, isRemote, isDebug, seed, maxNeighborUpdate);
        this.generator = gen;
        this.environment = env;
        this.biomeProvider = biomeProvider;
        this.bridge$getWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void arclight$init(class_5269 info, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimType, Supplier<class_3695> profiler, boolean isRemote, boolean isDebug, long seed, int maxNeighborUpdates, CallbackInfo ci) {
        ((WorldBorderBridge)this.field_9223).bridge$setWorld((class_1937)this);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
    }

    @Override
    public Map<class_2338, CapturedBlockState> bridge$getCapturedBlockState() {
        return this.capturedBlockStates;
    }

    @Override
    public Map<class_2338, class_2586> bridge$getCapturedBlockEntity() {
        return this.capturedTileEntities;
    }

    @Override
    public void bridge$setLastPhysicsProblem(class_2338 pos) {
        lastPhysicsProblem = pos;
    }

    @Override
    public Object2LongOpenHashMap<SpawnCategory> bridge$ticksPerSpawnCategory() {
        return this.ticksPerSpawnCategory;
    }

    public abstract class_5321<class_5363> getTypeKey();

    @Override
    public class_5321<class_5363> bridge$getTypeKey() {
        return this.getTypeKey();
    }

    @Override
    public SpigotWorldConfig bridge$spigotConfig() {
        return this.spigotConfig;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void arclight$hooks(class_2338 pos, class_2680 newState, int flags, int i, CallbackInfoReturnable<Boolean> cir) {
        if (!ArclightCaptures.setLastEntityChangeBlockResult(this.processCaptures(pos, newState, flags))) {
            cir.setReturnValue((Object)false);
        }
    }

    private boolean processCaptures(class_2338 pos, class_2680 newState, int flags) {
        class_1297 entityChangeBlock = ArclightCaptures.getEntityChangeBlock();
        if (entityChangeBlock != null) {
            return CraftEventFactory.callEntityChangeBlockEvent(entityChangeBlock, pos, newState);
        }
        return true;
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, require=0, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;updateNeighbourShapes(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;II)V")})
    private void arclight$callBlockPhysics(class_2338 pos, class_2680 state, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        try {
            if (this.world != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(this, pos), CraftBlockData.fromData(state));
                Bukkit.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
        catch (StackOverflowError e) {
            lastPhysicsProblem = pos;
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, require=0, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void arclight$preventPoiUpdate(class_2338 blockPos, class_2680 blockState, int i, int j, CallbackInfoReturnable<Boolean> cir) {
        if (this.preventPoiUpdated) {
            cir.setReturnValue((Object)true);
        }
    }

    public void notifyAndUpdatePhysics(class_2338 pos, class_2818 chunk, class_2680 oldBlock, class_2680 newBlock, class_2680 actualBlock, int i, int j) {
        this.bridge$forge$notifyAndUpdatePhysics(pos, chunk, oldBlock, newBlock, i, j);
    }

    @Override
    public void bridge$forge$notifyAndUpdatePhysics(class_2338 pos, @Nullable class_2818 levelchunk, class_2680 oldBlock, class_2680 newBlock, int j, int k) {
        class_2248 block = newBlock.method_26204();
        class_2680 blockstate1 = this.method_8320(pos);
        if (blockstate1 == newBlock) {
            if (oldBlock != blockstate1) {
                this.method_16109(pos, oldBlock, blockstate1);
            }
            if ((j & 2) != 0 && (!this.field_9236 || (j & 4) == 0) && (this.field_9236 || levelchunk == null || levelchunk.method_12225() != null && levelchunk.method_12225().method_14014(class_3194.field_44856))) {
                this.method_8413(pos, oldBlock, newBlock, j);
            }
            if ((j & 1) != 0) {
                this.method_8408(pos, oldBlock.method_26204());
                if (!this.field_9236 && newBlock.method_26221()) {
                    this.method_8455(pos, block);
                }
            }
            if ((j & 0x10) == 0 && k > 0) {
                int i = j & 0xFFFFFFDE;
                oldBlock.method_26198((class_1936)this, pos, i, k - 1);
                try {
                    if (this.world != null) {
                        BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(this, pos), CraftBlockData.fromData(newBlock));
                        Bukkit.getPluginManager().callEvent(event);
                        if (event.isCancelled()) {
                            return;
                        }
                    }
                }
                catch (StackOverflowError e) {
                    lastPhysicsProblem = pos;
                }
                newBlock.method_26183((class_1936)this, pos, i, k - 1);
                newBlock.method_26198((class_1936)this, pos, i, k - 1);
            }
            if (!this.preventPoiUpdated) {
                this.method_19282(pos, oldBlock, blockstate1);
            }
        }
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public CraftWorld getWorld() {
        if (this.world == null) {
            Optional<Field> delegate = WrappedWorlds.getDelegate(this.getClass());
            if (delegate.isPresent()) {
                try {
                    return ((WorldBridge)delegate.get().get(this)).bridge$getWorld();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.environment == null) {
                this.environment = ArclightServer.getEnvironment(this.getTypeKey());
            }
            if (this.generator == null) {
                LevelMixin levelMixin;
                this.generator = this.getCraftServer().getGenerator(((class_5268)this.method_8401()).method_150());
                if (this.generator != null && (levelMixin = this) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)levelMixin;
                    CraftWorldInfo worldInfo = new CraftWorldInfo((class_5268)this.method_8401(), ((ServerWorldBridge)((Object)this)).bridge$getConvertable(), this.environment, this.method_8597());
                    if (this.biomeProvider == null && this.generator != null) {
                        this.biomeProvider = this.generator.getDefaultBiomeProvider(worldInfo);
                    }
                    class_2794 generator = serverWorld.method_14178().method_12129();
                    if (this.biomeProvider != null) {
                        CustomWorldChunkManager biomeSource = new CustomWorldChunkManager(worldInfo, this.biomeProvider, (class_2378<class_1959>)serverWorld.method_30349().method_30530(class_7924.field_41236));
                        ((ChunkGeneratorBridge)generator).bridge$setBiomeSource(biomeSource);
                    }
                    CustomChunkGenerator gen = new CustomChunkGenerator(serverWorld, generator, this.generator);
                    ((ServerChunkProviderBridge)serverWorld.method_14178()).bridge$setChunkGenerator(gen);
                }
            }
            this.world = new CraftWorld((class_3218)this, this.generator, this.biomeProvider, this.environment);
            this.getCraftServer().addWorld(this.world);
        }
        return this.world;
    }

    public class_2586 getBlockEntity(class_2338 pos, boolean validate) {
        return this.method_8321(pos);
    }

    @Override
    public class_2586 bridge$getTileEntity(class_2338 pos, boolean validate) {
        return this.getBlockEntity(pos, validate);
    }

    @Override
    public CraftServer bridge$getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public CraftWorld bridge$getWorld() {
        return this.getWorld();
    }

    @Override
    public boolean bridge$isPvpMode() {
        return this.pvpMode;
    }

    @Override
    public boolean bridge$isPopulating() {
        return this.populating;
    }

    @Override
    public void bridge$setPopulating(boolean populating) {
        this.populating = populating;
    }

    @Override
    public ChunkGenerator bridge$getGenerator() {
        return this.generator;
    }

    @Override
    public class_3218 bridge$getMinecraftWorld() {
        return this.getWorld().getHandle();
    }

    @Override
    public boolean bridge$addEntity(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$addEntity(entity, reason);
        }
        this.bridge$pushAddEntityReason(reason);
        return this.method_8649(entity);
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            ((WorldBridge)this.getWorld().getHandle()).bridge$pushAddEntityReason(reason);
        }
    }

    @Override
    public CreatureSpawnEvent.SpawnReason bridge$getAddEntityReason() {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$getAddEntityReason();
        }
        return null;
    }

    @Override
    public boolean bridge$preventPoiUpdated() {
        return this.preventPoiUpdated;
    }

    @Override
    public void bridge$preventPoiUpdated(boolean b) {
        this.preventPoiUpdated = b;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;ZLnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)Lnet/minecraft/world/level/Explosion;"}, ordinal=0, at=@At(value="HEAD"), argsOnly=true)
    private class_1937.class_7867 arclight$standardExplodePre(class_1937.class_7867 interaction) {
        if (interaction == ArclightConstants.STANDARD) {
            this.arclight$blockInteractionOverride = class_1927.class_4179.field_18687;
            return class_1937.class_7867.field_40889;
        }
        return interaction;
    }

    @ModifyVariable(method={"explode(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;ZLnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)Lnet/minecraft/world/level/Explosion;"}, at=@At(value="LOAD", ordinal=0))
    private class_1927.class_4179 arclight$standardExplodePost(class_1927.class_4179 interaction) {
        try {
            if (this.arclight$blockInteractionOverride != null) {
                class_1927.class_4179 class_41792 = this.arclight$blockInteractionOverride;
                return class_41792;
            }
            class_1927.class_4179 class_41793 = interaction;
            return class_41793;
        }
        finally {
            this.arclight$blockInteractionOverride = null;
        }
    }
}

